/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.dsi.core.utilities.future;

import com.cloudera.hiveserver1.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.hiveserver1.dsi.core.utilities.Variant;
import com.cloudera.hiveserver1.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSIMonthSpan;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DSITimeSpan;
import com.cloudera.hiveserver1.dsi.exceptions.InvalidArgumentException;
import com.cloudera.hiveserver1.dsi.utilities.DSIMessageKey;
import com.cloudera.hiveserver1.support.IWarningListener;
import java.util.Arrays;
import java.util.Collections;

public final class IntervalConverter {
    private static final IntervalFieldType[] s_fieldsInOrderOfDecreasingSize = IntervalFieldType.values();
    private static final IntervalFieldType[] s_fieldsInOrderOfIncreasingSize = IntervalFieldType.values();
    private static final char DAY_HOUR_SEPARATOR = ' ';
    private static final char HOUR_MINUTE_SECOND_SEPARATOR = ':';
    private static final char SECOND_FRACTION_SEPARATOR = '.';
    private static final char YEAR_MONTH_SEPARATOR = '-';
    private static final char MINUS_SIGN = '-';
    private static final char ZERO_DIGIT = '0';
    static final String[] ZERO_BUFFER;
    private static final int MONTHS_PER_YEAR = 12;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int NANOS_PER_SECOND = 1000000000;
    public static final int INTERVAL_LEADING_PRECISION = 9;
    public static final short INTERVAL_FRACTIONAL_PRECISION = 9;
    public static final IntervalConverter INSTANCE;
    private final boolean m_padLeadingField;
    private static DaySecondValueTranslator s_noOpTranslator;
    private static DaySecondValueTranslator s_leadingHourTranslator;
    private static DaySecondValueTranslator s_leadingMinuteTranslator;
    private static DaySecondValueTranslator s_secondTranslator;

    public IntervalConverter(boolean bl) {
        this.m_padLeadingField = bl;
    }

    public String daySecondToString(DSITimeSpan dSITimeSpan, int n, int n2) {
        assert (dSITimeSpan != null);
        StringBuilder stringBuilder = new StringBuilder(11 + n + n2);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getDay(), dSITimeSpan.isNegative(), n);
        stringBuilder.append(' ');
        this.formatInnerField(stringBuilder, dSITimeSpan.getHour());
        stringBuilder.append(':');
        this.formatInnerField(stringBuilder, dSITimeSpan.getMinute());
        stringBuilder.append(':');
        this.formatInnerField(stringBuilder, dSITimeSpan.getSecond());
        this.formatFractionField(stringBuilder, dSITimeSpan.getFraction(), n2);
        return stringBuilder.toString();
    }

    public String dayMinuteToString(DSITimeSpan dSITimeSpan, int n) {
        assert (dSITimeSpan != null);
        assert (dSITimeSpan.getSecond() == 0);
        assert (dSITimeSpan.getFraction() == 0);
        StringBuilder stringBuilder = new StringBuilder(7 + n);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getDay(), dSITimeSpan.isNegative(), n);
        stringBuilder.append(' ');
        this.formatInnerField(stringBuilder, dSITimeSpan.getHour());
        stringBuilder.append(':');
        this.formatInnerField(stringBuilder, dSITimeSpan.getMinute());
        return stringBuilder.toString();
    }

    public String dayHourToString(DSITimeSpan dSITimeSpan, int n) {
        assert (dSITimeSpan != null);
        assert (dSITimeSpan.getMinute() == 0);
        assert (dSITimeSpan.getSecond() == 0);
        assert (dSITimeSpan.getFraction() == 0);
        StringBuilder stringBuilder = new StringBuilder(4 + n);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getDay(), dSITimeSpan.isNegative(), n);
        stringBuilder.append(' ');
        this.formatInnerField(stringBuilder, dSITimeSpan.getHour());
        return stringBuilder.toString();
    }

    public String dayToString(DSITimeSpan dSITimeSpan, int n) {
        assert (dSITimeSpan != null);
        assert (dSITimeSpan.getHour() == 0);
        assert (dSITimeSpan.getMinute() == 0);
        assert (dSITimeSpan.getSecond() == 0);
        assert (dSITimeSpan.getFraction() == 0);
        StringBuilder stringBuilder = new StringBuilder(1 + n);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getDay(), dSITimeSpan.isNegative(), n);
        return stringBuilder.toString();
    }

    public String hourSecondToString(DSITimeSpan dSITimeSpan, int n, int n2) {
        assert (dSITimeSpan != null);
        assert (dSITimeSpan.getDay() == 0);
        StringBuilder stringBuilder = new StringBuilder(8 + n + n2);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getHour(), dSITimeSpan.isNegative(), n);
        stringBuilder.append(':');
        this.formatInnerField(stringBuilder, dSITimeSpan.getMinute());
        stringBuilder.append(':');
        this.formatInnerField(stringBuilder, dSITimeSpan.getSecond());
        this.formatFractionField(stringBuilder, dSITimeSpan.getFraction(), n2);
        return stringBuilder.toString();
    }

    public String hourMinuteToString(DSITimeSpan dSITimeSpan, int n) {
        assert (dSITimeSpan != null);
        assert (dSITimeSpan.getDay() == 0);
        assert (dSITimeSpan.getSecond() == 0);
        assert (dSITimeSpan.getFraction() == 0);
        StringBuilder stringBuilder = new StringBuilder(4 + n);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getHour(), dSITimeSpan.isNegative(), n);
        stringBuilder.append(':');
        this.formatInnerField(stringBuilder, dSITimeSpan.getMinute());
        return stringBuilder.toString();
    }

    public String hourToString(DSITimeSpan dSITimeSpan, int n) {
        assert (dSITimeSpan != null);
        assert (dSITimeSpan.getDay() == 0);
        assert (dSITimeSpan.getMinute() == 0);
        assert (dSITimeSpan.getSecond() == 0);
        assert (dSITimeSpan.getFraction() == 0);
        StringBuilder stringBuilder = new StringBuilder(1 + n);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getHour(), dSITimeSpan.isNegative(), n);
        return stringBuilder.toString();
    }

    public String minuteSecondToString(DSITimeSpan dSITimeSpan, int n, int n2) {
        assert (dSITimeSpan != null);
        assert (dSITimeSpan.getDay() == 0);
        assert (dSITimeSpan.getHour() == 0);
        StringBuilder stringBuilder = new StringBuilder(5 + n + n2);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getMinute(), dSITimeSpan.isNegative(), n);
        stringBuilder.append(':');
        this.formatInnerField(stringBuilder, dSITimeSpan.getSecond());
        this.formatFractionField(stringBuilder, dSITimeSpan.getFraction(), n2);
        return stringBuilder.toString();
    }

    public String minuteToString(DSITimeSpan dSITimeSpan, int n) {
        assert (dSITimeSpan != null);
        assert (dSITimeSpan.getDay() == 0);
        assert (dSITimeSpan.getHour() == 0);
        assert (dSITimeSpan.getSecond() == 0);
        assert (dSITimeSpan.getFraction() == 0);
        StringBuilder stringBuilder = new StringBuilder(1 + n);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getMinute(), dSITimeSpan.isNegative(), n);
        return stringBuilder.toString();
    }

    public String secondToString(DSITimeSpan dSITimeSpan, int n, int n2) {
        assert (dSITimeSpan != null);
        assert (dSITimeSpan.getDay() == 0);
        assert (dSITimeSpan.getHour() == 0);
        assert (dSITimeSpan.getMinute() == 0);
        StringBuilder stringBuilder = new StringBuilder(2 + n + n2);
        this.formatLeadingField(stringBuilder, dSITimeSpan.getSecond(), dSITimeSpan.isNegative(), n);
        this.formatFractionField(stringBuilder, dSITimeSpan.getFraction(), n2);
        return stringBuilder.toString();
    }

    public String yearMonthToString(DSIMonthSpan dSIMonthSpan, int n) {
        assert (dSIMonthSpan != null);
        StringBuilder stringBuilder = new StringBuilder(4 + n);
        this.formatLeadingField(stringBuilder, dSIMonthSpan.getYear(), dSIMonthSpan.isNegative(), n);
        stringBuilder.append('-');
        this.formatInnerField(stringBuilder, dSIMonthSpan.getMonth());
        return stringBuilder.toString();
    }

    public String yearToString(DSIMonthSpan dSIMonthSpan, int n) {
        assert (dSIMonthSpan != null);
        assert (dSIMonthSpan.getMonth() == 0);
        StringBuilder stringBuilder = new StringBuilder(1 + n);
        this.formatLeadingField(stringBuilder, dSIMonthSpan.getYear(), dSIMonthSpan.isNegative(), n);
        return stringBuilder.toString();
    }

    public String monthToString(DSIMonthSpan dSIMonthSpan, int n) {
        assert (dSIMonthSpan != null);
        assert (dSIMonthSpan.getYear() == 0);
        StringBuilder stringBuilder = new StringBuilder(1 + n);
        this.formatLeadingField(stringBuilder, dSIMonthSpan.getMonth(), dSIMonthSpan.isNegative(), n);
        return stringBuilder.toString();
    }

    private static int checkedAdd(int n, int n2) {
        long l = (long)n + (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException(String.format("Failed to add %d and %d as integers, as this caused overflow.", n, n2));
        }
        return (int)l;
    }

    private static int checkedMultiply(int n, int n2) {
        long l = (long)n * (long)n2;
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ArithmeticException(String.format("Failed to multiply %d and %d as integers, as this caused overflow.", n, n2));
        }
        return (int)l;
    }

    private static boolean normalize(DaySecondValue daySecondValue, IntervalFieldType intervalFieldType, IntervalFieldType intervalFieldType2) {
        int n;
        IntervalFieldType intervalFieldType3;
        int n2;
        assert (!intervalFieldType.equals((Object)IntervalFieldType.FRACTION));
        assert (intervalFieldType.ordinal() <= intervalFieldType2.ordinal());
        boolean bl = daySecondValue.FractionalTruncationOccurred;
        int n3 = 0;
        for (n2 = 0; n2 <= intervalFieldType.ordinal(); ++n2) {
            intervalFieldType3 = s_fieldsInOrderOfDecreasingSize[n2];
            n = IntervalConverter.checkedAdd(intervalFieldType3.getField(daySecondValue), n3);
            if (n2 < intervalFieldType.ordinal()) {
                n3 = IntervalConverter.checkedMultiply(n, s_fieldsInOrderOfDecreasingSize[n2 + 1].getNaturalLimit());
                intervalFieldType3.setField(daySecondValue, 0);
                continue;
            }
            intervalFieldType3.setField(daySecondValue, n);
        }
        n2 = 0;
        n3 = 0;
        while (s_fieldsInOrderOfIncreasingSize[n2] != intervalFieldType2) {
            intervalFieldType3 = s_fieldsInOrderOfIncreasingSize[n2];
            n = IntervalConverter.checkedAdd(intervalFieldType3.getField(daySecondValue), n3);
            n3 = n / intervalFieldType3.getNaturalLimit();
            if (n3 * intervalFieldType3.getNaturalLimit() != n) {
                bl = true;
            }
            intervalFieldType3.setField(daySecondValue, 0);
            ++n2;
        }
        while (s_fieldsInOrderOfIncreasingSize[n2] != intervalFieldType) {
            intervalFieldType3 = s_fieldsInOrderOfIncreasingSize[n2];
            n = IntervalConverter.checkedAdd(intervalFieldType3.getField(daySecondValue), n3);
            n3 = n / intervalFieldType3.getNaturalLimit();
            intervalFieldType3.setField(daySecondValue, n % intervalFieldType3.getNaturalLimit());
            ++n2;
        }
        intervalFieldType.setField(daySecondValue, IntervalConverter.checkedAdd(intervalFieldType.getField(daySecondValue), n3));
        return bl;
    }

    private static DSITimeSpan toTimeSpan(DaySecondValue daySecondValue, int n) {
        return new DSITimeSpan(n, daySecondValue.Day, daySecondValue.Hour, daySecondValue.Minute, daySecondValue.Second, daySecondValue.Fraction, daySecondValue.IsNegative);
    }

    private static DSITimeSpan stringToTimeSpan(String string, int n, int n2, int n3, IntervalFieldType intervalFieldType, IntervalFieldType intervalFieldType2, DSIMessageKey dSIMessageKey, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, n, n2, n3, intervalFieldType, intervalFieldType2, dSIMessageKey, iWarningListener, listener, s_noOpTranslator);
    }

    private static DSITimeSpan stringToTimeSpan(String string, int n, int n2, int n3, IntervalFieldType intervalFieldType, IntervalFieldType intervalFieldType2, DSIMessageKey dSIMessageKey, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener, DaySecondValueTranslator daySecondValueTranslator) {
        assert (string != null);
        DaySecondValue daySecondValue = IntervalConverter.stringToDaySecondValue(string, n3, iWarningListener, dSIMessageKey);
        boolean bl = IntervalConverter.normalize(daySecondValue, intervalFieldType, intervalFieldType2);
        if (!IntervalConverter.checkLeadingField(intervalFieldType.getField(daySecondValue), n2)) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.OVERFLOW);
        } else if (bl) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION);
        } else {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.SUCCESS);
        }
        return IntervalConverter.toTimeSpan(daySecondValue, n);
    }

    public DSITimeSpan stringToDaySecond(String string, int n, int n2, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 110, n, n2, IntervalFieldType.DAY, IntervalFieldType.FRACTION, DSIMessageKey.INVALID_INTERVAL_DAY_SECOND_FORMAT, iWarningListener, listener);
    }

    public DSITimeSpan stringToDayMinute(String string, int n, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 109, n, 0, IntervalFieldType.DAY, IntervalFieldType.MINUTE, DSIMessageKey.INVALID_INTERVAL_DAY_MINUTE_FORMAT, iWarningListener, listener);
    }

    public DSITimeSpan stringToDayHour(String string, int n, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 108, n, 0, IntervalFieldType.DAY, IntervalFieldType.HOUR, DSIMessageKey.INVALID_INTERVAL_DAY_HOUR_FORMAT, iWarningListener, listener);
    }

    public DSITimeSpan stringToDay(String string, int n, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 103, n, 0, IntervalFieldType.DAY, IntervalFieldType.DAY, DSIMessageKey.INVALID_INTERVAL_DAY_FORMAT, iWarningListener, listener);
    }

    public DSITimeSpan stringToHourSecond(String string, int n, int n2, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 112, n, n2, IntervalFieldType.HOUR, IntervalFieldType.FRACTION, DSIMessageKey.INVALID_INTERVAL_HOUR_SECOND_FORMAT, iWarningListener, listener, s_leadingHourTranslator);
    }

    public DSITimeSpan stringToHourMinute(String string, int n, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 111, n, 0, IntervalFieldType.HOUR, IntervalFieldType.MINUTE, DSIMessageKey.INVALID_INTERVAL_HOUR_MINUTE_FORMAT, iWarningListener, listener, s_leadingHourTranslator);
    }

    public DSITimeSpan stringToHour(String string, int n, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 104, n, 0, IntervalFieldType.HOUR, IntervalFieldType.HOUR, DSIMessageKey.INVALID_INTERVAL_HOUR_FORMAT, iWarningListener, listener, s_leadingHourTranslator);
    }

    public DSITimeSpan stringToMinuteSecond(String string, int n, int n2, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 113, n, n2, IntervalFieldType.MINUTE, IntervalFieldType.FRACTION, DSIMessageKey.INVALID_INTERVAL_MINUTE_SECOND_FORMAT, iWarningListener, listener, s_leadingMinuteTranslator);
    }

    public DSITimeSpan stringToMinute(String string, int n, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 105, n, 0, IntervalFieldType.MINUTE, IntervalFieldType.MINUTE, DSIMessageKey.INVALID_INTERVAL_MINUTE_FORMAT, iWarningListener, listener, s_leadingMinuteTranslator);
    }

    public DSITimeSpan stringToSecond(String string, int n, int n2, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        return IntervalConverter.stringToTimeSpan(string, 106, n, n2, IntervalFieldType.SECOND, IntervalFieldType.FRACTION, DSIMessageKey.INVALID_INTERVAL_SECOND_FORMAT, iWarningListener, listener, s_secondTranslator);
    }

    public DSIMonthSpan stringToYearMonth(String string, int n, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        assert (string != null);
        YearMonthValue yearMonthValue = IntervalConverter.stringToYearMonthValue(string, DSIMessageKey.INVALID_INTERVAL_YEAR_MONTH_FORMAT, iWarningListener);
        if (!IntervalConverter.checkLeadingField(yearMonthValue.First, n)) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.OVERFLOW);
        } else {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.SUCCESS);
        }
        return new DSIMonthSpan(107, yearMonthValue.First, yearMonthValue.Second, yearMonthValue.IsNegative);
    }

    public DSIMonthSpan stringToYear(String string, int n, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        DSIMonthSpan dSIMonthSpan;
        assert (string != null);
        YearMonthValue yearMonthValue = IntervalConverter.stringToYearMonthValue(string, DSIMessageKey.INVALID_INTERVAL_YEAR_FORMAT, iWarningListener);
        boolean bl = false;
        if (1 == yearMonthValue.NumFields) {
            dSIMonthSpan = new DSIMonthSpan(101, yearMonthValue.First, 0, yearMonthValue.IsNegative);
        } else {
            bl = yearMonthValue.Second % 12 != 0;
            dSIMonthSpan = new DSIMonthSpan(101, yearMonthValue.First + yearMonthValue.Second / 12, 0, yearMonthValue.IsNegative);
        }
        if (!IntervalConverter.checkLeadingField(dSIMonthSpan.getYear(), n)) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.OVERFLOW);
        } else if (bl) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION);
        } else {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.SUCCESS);
        }
        return dSIMonthSpan;
    }

    public DSIMonthSpan stringToMonth(String string, int n, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        assert (string != null);
        YearMonthValue yearMonthValue = IntervalConverter.stringToYearMonthValue(string, DSIMessageKey.INVALID_INTERVAL_MONTH_FORMAT, iWarningListener);
        DSIMonthSpan dSIMonthSpan = 1 == yearMonthValue.NumFields ? new DSIMonthSpan(102, 0, yearMonthValue.First, yearMonthValue.IsNegative) : new DSIMonthSpan(102, 0, yearMonthValue.First * 12 + yearMonthValue.Second, yearMonthValue.IsNegative);
        if (!IntervalConverter.checkLeadingField(dSIMonthSpan.getMonth(), n)) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.OVERFLOW);
        } else {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.SUCCESS);
        }
        return dSIMonthSpan;
    }

    private static IllegalArgumentException createException(DSIMessageKey dSIMessageKey, String string, IWarningListener iWarningListener) {
        return new IllegalArgumentException(iWarningListener.getMessageSource().loadMessage(iWarningListener.getLocale(), 2, dSIMessageKey.toString(), string));
    }

    private static DaySecondValue stringToDaySecondValue(String string, int n, IWarningListener iWarningListener, DSIMessageKey dSIMessageKey) {
        if (0 == (string = string.trim()).length()) {
            throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
        }
        DaySecondValue daySecondValue = new DaySecondValue();
        int n2 = 0;
        int n3 = string.length();
        if ('-' == string.charAt(0)) {
            daySecondValue.IsNegative = true;
            ++n2;
        }
        while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
            ++n2;
        }
        int n4 = n2;
        IntervalFieldType intervalFieldType = IntervalFieldType.DAY;
        if (n2 < n3) {
            switch (string.charAt(n2)) {
                case ' ': {
                    intervalFieldType = IntervalFieldType.DAY;
                    break;
                }
                case ':': {
                    ++n2;
                    while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
                        ++n2;
                    }
                    if (n2 < n3 && '.' == string.charAt(n2)) {
                        intervalFieldType = IntervalFieldType.MINUTE;
                        break;
                    }
                    intervalFieldType = IntervalFieldType.HOUR;
                    break;
                }
                case '.': {
                    intervalFieldType = IntervalFieldType.SECOND;
                    break;
                }
                default: {
                    throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
                }
            }
        }
        boolean bl = false;
        int n5 = n2 = daySecondValue.IsNegative ? 1 : 0;
        while (n2 < n3) {
            daySecondValue.NumFields = (short)(daySecondValue.NumFields + 1);
            switch (intervalFieldType) {
                case DAY: {
                    daySecondValue.Day = Integer.parseInt(string.substring(n2, n4));
                    bl = true;
                    intervalFieldType = IntervalFieldType.HOUR;
                    n2 = n4;
                    if (n2 == n3 || ' ' == string.charAt(n2)) break;
                    throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
                }
                case HOUR: {
                    if (bl) {
                        daySecondValue.Hour = Integer.parseInt(string.substring(n2, n2 + 2));
                        n2 += 2;
                    } else {
                        daySecondValue.Hour = Integer.parseInt(string.substring(n2, n4));
                        bl = true;
                        n2 = n4;
                    }
                    intervalFieldType = IntervalFieldType.MINUTE;
                    if (n2 == n3 || ':' == string.charAt(n2)) break;
                    throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
                }
                case MINUTE: {
                    if (bl) {
                        daySecondValue.Minute = Integer.parseInt(string.substring(n2, n2 + 2));
                        n2 += 2;
                    } else {
                        daySecondValue.Minute = Integer.parseInt(string.substring(n2, n4));
                        bl = true;
                        n2 = n4;
                    }
                    intervalFieldType = IntervalFieldType.SECOND;
                    if (n2 == n3 || ':' == string.charAt(n2)) break;
                    throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
                }
                case SECOND: {
                    if (bl) {
                        daySecondValue.Second = Integer.parseInt(string.substring(n2, n2 + 2));
                        n2 += 2;
                    } else {
                        daySecondValue.Second = Integer.parseInt(string.substring(n2, n4));
                        bl = true;
                        n2 = n4;
                    }
                    intervalFieldType = IntervalFieldType.FRACTION;
                    if (n2 == n3 || '.' == string.charAt(n2)) break;
                    throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
                }
                case FRACTION: {
                    if (!bl) {
                        throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
                    }
                    daySecondValue.Fraction = IntervalConverter.getFractionField(string.substring(n2), n);
                    if (daySecondValue.Fraction < 0) {
                        daySecondValue.Fraction = -daySecondValue.Fraction;
                        daySecondValue.FractionalTruncationOccurred = true;
                    }
                    return daySecondValue;
                }
                default: {
                    throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
                }
            }
            ++n2;
        }
        return daySecondValue;
    }

    private static YearMonthValue stringToYearMonthValue(String string, DSIMessageKey dSIMessageKey, IWarningListener iWarningListener) {
        if (0 == (string = string.trim()).length()) {
            throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
        }
        YearMonthValue yearMonthValue = new YearMonthValue();
        boolean bl = yearMonthValue.IsNegative = '-' == string.charAt(0);
        if (yearMonthValue.IsNegative) {
            string = string.substring(1);
        }
        int n = string.lastIndexOf(45);
        try {
            if (-1 == n) {
                yearMonthValue.First = Integer.parseInt(string);
                yearMonthValue.NumFields = 1;
            } else {
                yearMonthValue.First = Integer.parseInt(string.substring(0, n));
                yearMonthValue.Second = Integer.parseInt(string.substring(n + 1));
                yearMonthValue.NumFields = (short)2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw IntervalConverter.createException(dSIMessageKey, string, iWarningListener);
        }
        return yearMonthValue;
    }

    private static int getFractionField(String string, int n) {
        int n2 = 0;
        if (0 < n) {
            int n3 = string.length();
            if (n3 == n) {
                n2 = Integer.parseInt(string);
            } else if (n3 > n) {
                n2 = Integer.parseInt(string.substring(0, n));
                if (0 != Integer.parseInt(string.substring(n))) {
                    n2 = -n2;
                }
            } else {
                int n4 = n - n3;
                n2 = Integer.parseInt(string);
                while (n4-- > 0) {
                    n2 *= 10;
                }
            }
        }
        return n2;
    }

    private static boolean checkLeadingField(int n, int n2) {
        int n3 = 0;
        n3 = n < 100000 ? (n < 100 ? (n < 10 ? 1 : 2) : (n < 1000 ? 3 : (n < 10000 ? 4 : 5))) : (n < 10000000 ? (n < 1000000 ? 6 : 7) : (n < 100000000 ? 8 : (n < 1000000000 ? 9 : 10)));
        return n3 <= n2;
    }

    protected final void formatInnerField(StringBuilder stringBuilder, int n) {
        assert (n >= 0);
        assert (n <= 99);
        stringBuilder.append(this.digitToChar(n / 10));
        stringBuilder.append(this.digitToChar(n % 10));
    }

    protected void formatLeadingField(StringBuilder stringBuilder, int n, boolean bl, long l) {
        if (bl) {
            stringBuilder.append('-');
        }
        if (this.m_padLeadingField) {
            String string = Integer.toString(n);
            stringBuilder.append(ZERO_BUFFER[(int)l - string.length()]);
            stringBuilder.append(string);
        } else {
            stringBuilder.append(n);
        }
    }

    protected final char digitToChar(int n) {
        assert (n >= 0);
        assert (n <= 9);
        return (char)(48 + n);
    }

    protected void formatFractionField(StringBuilder stringBuilder, int n, int n2) {
        if (0 < n2) {
            stringBuilder.append('.');
            int n3 = n2;
            StringBuilder stringBuilder2 = new StringBuilder("000000000");
            while (n3 > 0) {
                stringBuilder2.setCharAt(--n3, this.digitToChar(n % 10));
                n /= 10;
            }
            if (n > 0) {
                throw new InvalidArgumentException(1, DSIMessageKey.INTERVAL_FIELD_OVERFLOW.name(), null);
            }
            stringBuilder.append(stringBuilder2.substring(0, n2));
        }
    }

    public DSIMonthSpan normalize(DSIMonthSpan dSIMonthSpan, int n, int n2, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        int n3;
        DSIMonthSpan dSIMonthSpan2;
        assert (dSIMonthSpan != null);
        boolean bl = false;
        switch (n) {
            case 101: {
                bl = dSIMonthSpan.getMonth() % 12 != 0;
                dSIMonthSpan2 = new DSIMonthSpan(n, dSIMonthSpan.getYear() + dSIMonthSpan.getMonth() / 12, 0, dSIMonthSpan.isNegative());
                n3 = dSIMonthSpan2.getYear();
                break;
            }
            case 107: {
                dSIMonthSpan2 = new DSIMonthSpan(n, dSIMonthSpan.getYear(), dSIMonthSpan.getMonth(), dSIMonthSpan.isNegative());
                n3 = dSIMonthSpan2.getYear();
                break;
            }
            case 102: {
                dSIMonthSpan2 = new DSIMonthSpan(n, 0, dSIMonthSpan.getMonth() + 12 * dSIMonthSpan.getYear(), dSIMonthSpan.isNegative());
                n3 = dSIMonthSpan2.getMonth();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (!IntervalConverter.checkLeadingField(n3, n2)) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.OVERFLOW);
        } else if (bl) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION);
        } else {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.SUCCESS);
        }
        return dSIMonthSpan2;
    }

    public DSITimeSpan normalize(DSITimeSpan dSITimeSpan, int n, int n2, int n3, IWarningListener iWarningListener, NonTrivialJDBCConversions.Listener listener) {
        IntervalFieldType intervalFieldType;
        IntervalFieldType intervalFieldType2;
        assert (dSITimeSpan != null);
        assert (n2 >= 0 && n2 <= 9);
        assert (n3 >= 0 && n3 <= 9);
        switch (n) {
            case 103: {
                intervalFieldType2 = IntervalFieldType.DAY;
                intervalFieldType = IntervalFieldType.DAY;
                break;
            }
            case 108: {
                intervalFieldType2 = IntervalFieldType.DAY;
                intervalFieldType = IntervalFieldType.HOUR;
                break;
            }
            case 109: {
                intervalFieldType2 = IntervalFieldType.DAY;
                intervalFieldType = IntervalFieldType.MINUTE;
                break;
            }
            case 110: {
                intervalFieldType2 = IntervalFieldType.DAY;
                intervalFieldType = IntervalFieldType.FRACTION;
                break;
            }
            case 104: {
                intervalFieldType2 = IntervalFieldType.HOUR;
                intervalFieldType = IntervalFieldType.HOUR;
                break;
            }
            case 111: {
                intervalFieldType2 = IntervalFieldType.HOUR;
                intervalFieldType = IntervalFieldType.MINUTE;
                break;
            }
            case 112: {
                intervalFieldType2 = IntervalFieldType.HOUR;
                intervalFieldType = IntervalFieldType.FRACTION;
                break;
            }
            case 105: {
                intervalFieldType2 = IntervalFieldType.MINUTE;
                intervalFieldType = IntervalFieldType.MINUTE;
                break;
            }
            case 113: {
                intervalFieldType2 = IntervalFieldType.MINUTE;
                intervalFieldType = IntervalFieldType.FRACTION;
                break;
            }
            case 106: {
                intervalFieldType2 = IntervalFieldType.SECOND;
                intervalFieldType = IntervalFieldType.FRACTION;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        DaySecondValue daySecondValue = new DaySecondValue();
        daySecondValue.Day = dSITimeSpan.getDay();
        daySecondValue.Hour = dSITimeSpan.getHour();
        daySecondValue.Minute = dSITimeSpan.getMinute();
        daySecondValue.Second = dSITimeSpan.getSecond();
        daySecondValue.IsNegative = dSITimeSpan.isNegative();
        daySecondValue.Fraction = NonTrivialJDBCConversions.roundNanosecondsToPrecision(dSITimeSpan.getFraction(), n3);
        daySecondValue.FractionalTruncationOccurred = daySecondValue.Fraction != dSITimeSpan.getFraction();
        boolean bl = IntervalConverter.normalize(daySecondValue, intervalFieldType2, intervalFieldType);
        if (!IntervalConverter.checkLeadingField(intervalFieldType2.getField(daySecondValue), n2)) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.OVERFLOW);
        } else if (bl) {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION);
        } else {
            listener.notifyConversionResult(NonTrivialJDBCConversions.ConversionStatus.SUCCESS);
        }
        return IntervalConverter.toTimeSpan(daySecondValue, n);
    }

    static {
        Collections.reverse(Arrays.asList(s_fieldsInOrderOfIncreasingSize));
        ZERO_BUFFER = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000"};
        try {
            Variant variant = DSIDriverSingleton.getInstance().getProperty(21);
            INSTANCE = new IntervalConverter(1L == variant.getLong());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        s_noOpTranslator = new DaySecondValueTranslator(){

            @Override
            public DaySecondValue translateIfNeeded(DaySecondValue daySecondValue) {
                return daySecondValue;
            }
        };
        s_leadingHourTranslator = new DaySecondValueTranslator(){

            @Override
            public DaySecondValue translateIfNeeded(DaySecondValue daySecondValue) {
                if (daySecondValue.NumFields == 1) {
                    daySecondValue.Hour = daySecondValue.Day;
                    daySecondValue.Day = 0;
                }
                return daySecondValue;
            }
        };
        s_leadingMinuteTranslator = new DaySecondValueTranslator(){

            @Override
            public DaySecondValue translateIfNeeded(DaySecondValue daySecondValue) {
                if (1 == daySecondValue.NumFields) {
                    daySecondValue.Minute = daySecondValue.Day;
                    daySecondValue.Day = 0;
                } else if (2 == daySecondValue.NumFields && 0 == daySecondValue.Day && 0 == daySecondValue.Second && 0 == daySecondValue.Fraction) {
                    daySecondValue.Second = daySecondValue.Minute;
                    daySecondValue.Minute = daySecondValue.Hour;
                    daySecondValue.Hour = 0;
                }
                return daySecondValue;
            }
        };
        s_secondTranslator = new DaySecondValueTranslator(){

            @Override
            public DaySecondValue translateIfNeeded(DaySecondValue daySecondValue) {
                if (1 == daySecondValue.NumFields) {
                    daySecondValue.Second = daySecondValue.Day;
                    daySecondValue.Day = 0;
                } else if (2 == daySecondValue.NumFields && 0 == daySecondValue.Day && 0 == daySecondValue.Second && 0 == daySecondValue.Fraction) {
                    daySecondValue.Second = daySecondValue.Hour * 60 + daySecondValue.Minute;
                    daySecondValue.Hour = 0;
                    daySecondValue.Minute = 0;
                }
                return daySecondValue;
            }
        };
    }

    private static interface DaySecondValueTranslator {
        public DaySecondValue translateIfNeeded(DaySecondValue var1);
    }

    private static enum IntervalFieldType {
        DAY(0){

            @Override
            public int getField(DaySecondValue daySecondValue) {
                return daySecondValue.Day;
            }

            @Override
            public void setField(DaySecondValue daySecondValue, int n) {
                daySecondValue.Day = n;
            }
        }
        ,
        HOUR(24){

            @Override
            public int getField(DaySecondValue daySecondValue) {
                return daySecondValue.Hour;
            }

            @Override
            public void setField(DaySecondValue daySecondValue, int n) {
                daySecondValue.Hour = n;
            }
        }
        ,
        MINUTE(60){

            @Override
            public int getField(DaySecondValue daySecondValue) {
                return daySecondValue.Minute;
            }

            @Override
            public void setField(DaySecondValue daySecondValue, int n) {
                daySecondValue.Minute = n;
            }
        }
        ,
        SECOND(60){

            @Override
            public int getField(DaySecondValue daySecondValue) {
                return daySecondValue.Second;
            }

            @Override
            public void setField(DaySecondValue daySecondValue, int n) {
                daySecondValue.Second = n;
            }
        }
        ,
        FRACTION(1000000000){

            @Override
            public int getField(DaySecondValue daySecondValue) {
                return daySecondValue.Fraction;
            }

            @Override
            public void setField(DaySecondValue daySecondValue, int n) {
                daySecondValue.Fraction = n;
            }
        };

        int m_limit;

        private IntervalFieldType(int n2) {
            this.m_limit = n2;
        }

        public int getNaturalLimit() {
            return this.m_limit;
        }

        public abstract int getField(DaySecondValue var1);

        public abstract void setField(DaySecondValue var1, int var2);
    }

    private static class YearMonthValue {
        public int First;
        public int Second;
        public short NumFields;
        public boolean IsNegative;

        private YearMonthValue() {
        }
    }

    private static class DaySecondValue {
        public int Day;
        public int Hour;
        public int Minute;
        public int Second;
        public int Fraction;
        public short NumFields;
        public boolean IsNegative;
        public boolean FractionalTruncationOccurred;

        private DaySecondValue() {
        }
    }
}

