/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.dsi.core.utilities.impl.future;

import com.cloudera.hiveserver1.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.hiveserver1.dsi.core.utilities.impl.future.ConvertingJDBCDataSource;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.future.IJDBCExecution;
import com.cloudera.hiveserver1.dsi.exceptions.ConversionFailed;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class DateJDBCDataSource
extends ConvertingJDBCDataSource {
    public DateJDBCDataSource(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    protected abstract boolean get(Calendar var1) throws ErrorException;

    protected Date doGetDate(Calendar calendar) throws ErrorException {
        assert (calendar != null);
        if (this.get(calendar)) {
            this.setWasNull(false);
            return new Date(calendar.getTimeInMillis());
        }
        this.setWasNull(true);
        return null;
    }

    @Override
    public Date get() throws ErrorException {
        return this.doGetDate(this.getLocalCalendarForConversions());
    }

    @Override
    public String getString() throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Date date = this.get();
        if (date == null) {
            return null;
        }
        return NonTrivialJDBCConversions.dateToString(date, this.getLocalCalendarForConversions());
    }

    @Override
    public Date getDate(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        return this.doGetDate(calendar);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws ErrorException, IncorrectTypeException, ConversionFailed, SQLException {
        Date date;
        if (calendar == null) {
            calendar = this.getLocalCalendarForConversions();
        }
        if ((date = this.getDate(calendar)) == null) {
            return null;
        }
        return NonTrivialJDBCConversions.dateToTimestamp(date, calendar);
    }

    @Override
    protected boolean supportsConversionToRegisteredType(IJDBCExecution.OutputParameterRegistration outputParameterRegistration) {
        int n = this.getSqlTypeFromRegistration(outputParameterRegistration);
        switch (n) {
            case 91: 
            case 93: 
            case 2000: {
                return true;
            }
        }
        return this.isCharType(n);
    }
}

