/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.dsi.dataengine.utilities;

import java.lang.reflect.Method;

public final class SqlTypeWrapper {
    private static final Class<?> s_sqlTypeClass;
    private static final Method s_getNameMethod;
    private static final Method s_getVendorMethod;
    private static final Method s_getVendorTypeNumberMethod;
    private final Object m_wrapped;

    public SqlTypeWrapper(Object object) {
        if (!SqlTypeWrapper.isSQLType(object)) {
            throw new RuntimeException(String.format("object to wrap must implement java.sql.SQLType, was of type \"%s\" that did not!", object.getClass().getCanonicalName()));
        }
        this.m_wrapped = object;
    }

    public static boolean isSQLType(Object object) {
        return s_sqlTypeClass.isInstance(object);
    }

    public String getName() {
        try {
            return (String)s_getNameMethod.invoke(this.m_wrapped, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getVendor() {
        try {
            return (String)s_getVendorMethod.invoke(this.m_wrapped, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Integer getVendorTypeNumber() {
        try {
            return (Integer)s_getVendorTypeNumberMethod.invoke(this.m_wrapped, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object getWrapped() {
        return this.m_wrapped;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.sql.SQLType");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        s_sqlTypeClass = clazz;
        if (s_sqlTypeClass != null) {
            try {
                s_getNameMethod = s_sqlTypeClass.getDeclaredMethod("getName", new Class[0]);
                s_getVendorMethod = s_sqlTypeClass.getDeclaredMethod("getVendor", new Class[0]);
                s_getVendorTypeNumberMethod = s_sqlTypeClass.getDeclaredMethod("getVendorTypeNumber", new Class[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            s_getNameMethod = null;
            s_getVendorMethod = null;
            s_getVendorTypeNumberMethod = null;
        }
    }
}

