/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.api;

import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.api.HiveJDBCOAuthBrowserServerResponse;
import com.cloudera.hiveserver1.hivecommon.api.WebBrowserClient;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

public class WebBrowserOAuthClient
extends WebBrowserClient {
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String RETRY_NEXT_PORT = "Retrying with next port.";
    private static final int MAX_SOCKET_PORT = 65535;
    public static final long SEC_TO_NANO = 1000000000L;

    public WebBrowserOAuthClient(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) throws ErrorException {
        super(hiveJDBCSettings, iLogger);
    }

    public synchronized String getCode() {
        return null == this.m_serverResponse ? null : ((HiveJDBCOAuthBrowserServerResponse)this.m_serverResponse).getCode();
    }

    public synchronized String getState() {
        return null == this.m_serverResponse ? null : ((HiveJDBCOAuthBrowserServerResponse)this.m_serverResponse).getState();
    }

    @Override
    protected ServerSocket getServerSocket() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ServerSocket serverSocket = null;
        int n = this.m_settings.m_oAuthSettings.m_OAuthBrowserSocketTimeout;
        long l = System.nanoTime() + (long)n * 1000000000L;
        if (this.m_settings.m_oAuthSettings.m_OAuth2RedirectUrlPort.size() == 1) {
            boolean bl = true;
            int n2 = 0;
            while (bl) {
                try {
                    serverSocket = this.tryServerPort(this.m_settings.m_oAuthSettings.m_OAuth2RedirectUrlPort.get(0) + n2);
                    bl = false;
                }
                catch (IOException iOException) {
                    bl = true;
                    ++n2;
                    LogUtilities.logError(RETRY_NEXT_PORT, this.m_logger);
                    if (l >= System.nanoTime()) continue;
                    break;
                }
            }
            if (serverSocket == null || bl) {
                ErrorException errorException = null;
                errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_SERVER_PORT_BIND_ERR_WITH_PORT_SET.name(), new String[]{"" + this.m_settings.m_oAuthSettings.m_OAuth2RedirectUrlPort, "SSOWebServerPort"});
                throw errorException;
            }
        } else {
            for (int i = 0; i < this.m_settings.m_oAuthSettings.m_OAuth2RedirectUrlPort.size(); ++i) {
                try {
                    serverSocket = this.tryServerPort(this.m_settings.m_oAuthSettings.m_OAuth2RedirectUrlPort.get(i));
                    break;
                }
                catch (IOException iOException) {
                    LogUtilities.logError(RETRY_NEXT_PORT, this.m_logger);
                    if (l < System.nanoTime()) break;
                    continue;
                }
            }
            if (serverSocket == null) {
                ErrorException errorException = null;
                errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSO_SERVER_PORT_BIND_ERR_WITH_PORT_SET.name(), new String[]{"" + this.m_settings.m_oAuthSettings.m_OAuth2RedirectUrlPort, "SSOWebServerPort"});
                throw errorException;
            }
        }
        return serverSocket;
    }

    protected ServerSocket tryServerPort(int n) throws UnknownHostException, IOException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_oAuthSettings.m_OAuthEmulatePortException && 65535 >= n) {
            throw new IOException("emulated error");
        }
        ServerSocket serverSocket = new ServerSocket(n, 0, InetAddress.getByName(DEFAULT_HOSTNAME));
        serverSocket.setReuseAddress(true);
        serverSocket.setSoTimeout(100);
        this.m_browserTimeout = this.m_settings.m_ssoSettings.m_ssoBrowserTimeout;
        return serverSocket;
    }

    @Override
    protected ErrorException getResponseException() {
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.OAUTH_2_BROWSER_TIMEOUT.name(), Integer.toString(this.m_browserTimeout / 1000));
        return errorException;
    }

    @Override
    protected String getSensitiveInfoLogMessage() {
        return "Code received is: " + this.getCode();
    }
}

