/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.hivecommon.core;

import com.cloudera.hiveserver1.hivecommon.api.HiveOperationContext;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import java.util.HashMap;
import java.util.Map;

public class BackgroundFetcherExecutionContextMap {
    private static Map<Long, HiveOperationContext> s_backgroundThreadToContext = new HashMap<Long, HiveOperationContext>(65535);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HiveOperationContext getContext(Long l) {
        Map<Long, HiveOperationContext> map = s_backgroundThreadToContext;
        synchronized (map) {
            ILogger iLogger;
            HiveOperationContext hiveOperationContext = s_backgroundThreadToContext.get(l);
            if (null != hiveOperationContext && null != (iLogger = hiveOperationContext.getLogger())) {
                LogUtilities.logDebug("Retrieving context from map, Foreground ID: " + String.valueOf(hiveOperationContext.m_foregroundThreadID) + ", Background ID: " + String.valueOf(l), iLogger);
            }
            return hiveOperationContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putContext(Long l, HiveOperationContext hiveOperationContext) {
        ILogger iLogger = hiveOperationContext.getLogger();
        if (null != iLogger) {
            LogUtilities.logFunctionEntrance(iLogger, hiveOperationContext);
        }
        Map<Long, HiveOperationContext> map = s_backgroundThreadToContext;
        synchronized (map) {
            s_backgroundThreadToContext.put(l, hiveOperationContext);
            if (null != iLogger) {
                LogUtilities.logDebug("Adding context to map, Foreground ID: " + String.valueOf(hiveOperationContext.m_foregroundThreadID) + ", Background ID: " + String.valueOf(l), iLogger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContext(Long l) {
        Map<Long, HiveOperationContext> map = s_backgroundThreadToContext;
        synchronized (map) {
            s_backgroundThreadToContext.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeContext(HiveOperationContext hiveOperationContext) {
        ILogger iLogger = hiveOperationContext.getLogger();
        if (null != iLogger) {
            LogUtilities.logFunctionEntrance(iLogger, hiveOperationContext);
        }
        Map<Long, HiveOperationContext> map = s_backgroundThreadToContext;
        synchronized (map) {
            Long l = hiveOperationContext.m_backgroundThreadID;
            HiveOperationContext hiveOperationContext2 = s_backgroundThreadToContext.get(l);
            if (null != hiveOperationContext2 && hiveOperationContext2.equals(hiveOperationContext)) {
                s_backgroundThreadToContext.remove(l);
                if (null != iLogger) {
                    LogUtilities.logDebug("Removing context from map, Foreground ID: " + String.valueOf(hiveOperationContext.m_foregroundThreadID) + ", Background ID: " + String.valueOf(l), iLogger);
                }
            }
        }
    }
}

