/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.jdbc.common;

import com.cloudera.hiveserver1.dsi.core.utilities.Variant;
import com.cloudera.hiveserver1.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.Warning;
import com.cloudera.hiveserver1.support.WarningCode;

public enum OAuthFlow {
    TOKEN_PASSTHROUGH,
    CLIENT_CREDENTIALS,
    BROWSER;


    public static OAuthFlow convertToOAuthFlow(Variant variant, IWarningListener iWarningListener) {
        try {
            int n = variant.getInt();
            if (n >= 0 && n < OAuthFlow.values().length) {
                return OAuthFlow.values()[n];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != iWarningListener) {
            iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"Auth_Flow", variant.getString(), "Invalid OAuth flow value"}));
        }
        return null;
    }
}

