/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.jdbc.oauth;

import com.cloudera.hive.jdbc42.internal.apache.commons.codec.binary.Base64;
import com.cloudera.hive.jdbc42.internal.apache.commons.lang.SystemUtils;
import com.cloudera.hive.jdbc42.internal.apache.http.HttpEntity;
import com.cloudera.hive.jdbc42.internal.apache.http.HttpHost;
import com.cloudera.hive.jdbc42.internal.apache.http.HttpResponse;
import com.cloudera.hive.jdbc42.internal.apache.http.HttpVersion;
import com.cloudera.hive.jdbc42.internal.apache.http.auth.AuthScope;
import com.cloudera.hive.jdbc42.internal.apache.http.auth.UsernamePasswordCredentials;
import com.cloudera.hive.jdbc42.internal.apache.http.client.CredentialsProvider;
import com.cloudera.hive.jdbc42.internal.apache.http.client.config.RequestConfig;
import com.cloudera.hive.jdbc42.internal.apache.http.client.entity.UrlEncodedFormEntity;
import com.cloudera.hive.jdbc42.internal.apache.http.client.methods.HttpGet;
import com.cloudera.hive.jdbc42.internal.apache.http.client.methods.HttpPost;
import com.cloudera.hive.jdbc42.internal.apache.http.conn.ssl.SSLSocketFactory;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.DefaultHttpResponseFactory;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.BasicCredentialsProvider;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.CloseableHttpClient;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.HttpClientBuilder;
import com.cloudera.hive.jdbc42.internal.apache.http.impl.client.HttpClients;
import com.cloudera.hive.jdbc42.internal.apache.http.message.BasicNameValuePair;
import com.cloudera.hive.jdbc42.internal.apache.http.message.BasicStatusLine;
import com.cloudera.hive.jdbc42.internal.apache.http.util.EntityUtils;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.JsonNode;
import com.cloudera.hive.jdbc42.internal.fasterxml.jackson.databind.ObjectMapper;
import com.cloudera.hiveserver1.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver1.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver1.hivecommon.utils.OAuthTokenCache;
import com.cloudera.hiveserver1.jdbc.common.CommonUtils;
import com.cloudera.hiveserver1.jdbc.common.OAuthFlow;
import com.cloudera.hiveserver1.jdbc.common.OAuthSettings;
import com.cloudera.hiveserver1.jdbc.common.ProxySettings;
import com.cloudera.hiveserver1.jdbc.common.SSLSettings;
import com.cloudera.hiveserver1.jdbc.core.DSDriver;
import com.cloudera.hiveserver1.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.hiveserver1.jdbc.oauth.RefreshTokenExpiredException;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuthFactory {
    protected static final String JSON_ACCESS_TOKEN_KEY = "access_token";
    private static final String JSON_REFRESH_TOKEN_KEY = "refresh_token";
    private static final String EXPIRY_TIME_KEY = "expires_in";
    private static final String JSON_ERROR_KEY = "error";
    private static final String JSON_ERROR_DESCRIPTION_KEY = "error_description";
    private static final String GRANT_TYPE_KEY = "grant_type";
    private static final String CLIENT_ASSERTION_TYPE_KEY = "client_assertion_type";
    private static final String CLIENT_ASSERTION_KEY = "client_assertion";
    private static final String SCOPE_KEY = "scope";
    private static final String CLIENT_ID_KEY = "client_id";
    private static final String CLIENT_SECRET_KEY = "client_secret";
    private static final String CLIENT_CRED_GRANT = "client_credentials";
    private static final String UTF_8_CHARSET = "UTF-8";
    private static final String CODE = "code";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String CODE_VERIFIER = "code_verifier";
    private static final String BROWSER_CRED_GRANT = "authorization_code";
    private static final String INVALID_AUTHORIZATION_URL_STRINGS = "metadata|fd00:ec2::254|169.254.169.254";
    private static final String CLIENT_ASSERTION_TYPE_DEFAULT = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    private static final String HTTPS_STRING = "https";
    private static final String HTTPS_ERROR_DESC = "HTTPS required";
    private static final String LOCAL_ADDRESS_ERROR_DESC = "Invalid local Address";
    private static final String URL_ERROR_DESC = "Invalid URL";
    private static final String IP_RANGE_PARSE_ERROR = "Invalid IP range parsed";
    private static final String METADATA_ERROR_DESC = "Invalid metadata access";
    private static final int EXPIRED_TOKEN_SECONDS = 0;
    private static final String REFRESH_TOKEN_ERROR_DESC = "Refresh token is invalid";
    private static final String RETRY_AFTER_HEADER_IN_SECONDS = "Retry-After";
    private static int m_retryAfterTimeSeconds = 30;
    private static final String JSON_AUTH_ENDPOINT_KEY = "authorization_endpoint";
    private static final String JSON_TOKEN_ENDPOINT_KEY = "token_endpoint";
    private static final String JSON_RESPONSE_TYPE_KEY = "response_types_supported";
    private static final String SUPPORTED_RESPONSE_TYPE = "code";
    private static final String DATABRICKS_RUNTIME_ENV = "DATABRICKS_RUNTIME_VERSION";
    private static final String IP_LIST_SPLIT_KEY = "-";
    private static final String HTTP_PROTOCOL = "https://";
    private static final int SECONDS = 60;
    private static final int MILLISECONDS = 1000;

    public static URI getServerURI(OAuthSettings oAuthSettings) throws ErrorException {
        URI uRI = null;
        OAuthFactory.checkInvalidAuthorizationUrl(oAuthSettings);
        try {
            uRI = new URL(oAuthSettings.m_authorizationUrl).toURI();
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage()});
            throw errorException;
        }
        return uRI;
    }

    public static void checkInvalidAuthorizationUrl(OAuthSettings oAuthSettings) throws ErrorException {
        Serializable serializable;
        Object object;
        String string = "";
        Boolean bl = false;
        String string2 = oAuthSettings.m_authorizationUrl;
        if (string2 == null) {
            bl = true;
        }
        try {
            if (OAuthFactory.isAuthURLEnabled(oAuthSettings)) {
                return;
            }
        }
        catch (MalformedURLException | UnknownHostException iOException) {
            bl = true;
            string = iOException.getMessage();
        }
        try {
            object = System.getenv(DATABRICKS_RUNTIME_ENV);
            serializable = Inet6Address.getByName(new URL(string2).getHost());
            if (SystemUtils.IS_OS_LINUX && object != null && serializable.isSiteLocalAddress()) {
                bl = true;
                string = LOCAL_ADDRESS_ERROR_DESC;
            }
        }
        catch (MalformedURLException | UnknownHostException iOException) {
            bl = true;
            string = URL_ERROR_DESC;
        }
        object = Pattern.compile(INVALID_AUTHORIZATION_URL_STRINGS, 2).matcher(string2);
        if (((Matcher)object).find()) {
            bl = true;
            string = METADATA_ERROR_DESC;
        }
        serializable = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.AUTHORIZATIONN_URL_ERROR.name(), string);
        if (bl.booleanValue()) {
            throw serializable;
        }
    }

    public static boolean isAuthURLEnabled(OAuthSettings oAuthSettings) throws UnknownHostException, ErrorException, MalformedURLException {
        String string = OAuthFactory.fetchIPString(oAuthSettings.m_authorizationUrl);
        BigInteger bigInteger = OAuthFactory.ipToBigInt(string);
        List<String> list = oAuthSettings.m_OAuth2EnableAuthURLIPRange;
        for (String string2 : list) {
            if (string2.contains(IP_LIST_SPLIT_KEY)) {
                Serializable serializable;
                String[] stringArray = string2.split(IP_LIST_SPLIT_KEY);
                if (stringArray.length != 2) {
                    serializable = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.AUTHORIZATIONN_URL_ERROR.name(), IP_RANGE_PARSE_ERROR);
                    throw serializable;
                }
                serializable = OAuthFactory.ipToBigInt(stringArray[0]);
                BigInteger bigInteger2 = OAuthFactory.ipToBigInt(stringArray[1]);
                BigInteger bigInteger3 = ((BigInteger)serializable).min(bigInteger2);
                BigInteger bigInteger4 = ((BigInteger)serializable).max(bigInteger2);
                if (bigInteger3.compareTo(bigInteger) == 1 || bigInteger4.compareTo(bigInteger) == -1) continue;
                return true;
            }
            if (OAuthFactory.ipToBigInt(string2).compareTo(bigInteger) != 0) continue;
            return true;
        }
        return false;
    }

    public static BigInteger ipToBigInt(String string) throws UnknownHostException, ErrorException {
        InetAddress inetAddress = Inet6Address.getByName(string);
        byte[] byArray = inetAddress.getAddress();
        return new BigInteger(1, byArray);
    }

    public static String fetchIPString(String string) throws UnknownHostException {
        try {
            string = Inet6Address.getByName(new URL(string).getHost()).getHostAddress();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return string;
    }

    public static void OIDCDiscoverEndpoint(String string, OAuthSettings oAuthSettings, ILogger iLogger) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(iLogger, string, iLogger);
        HttpGet httpGet = null;
        try {
            URI uRI = new URL(string).toURI();
            httpGet = new HttpGet(uRI);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.AUTHORIZATIONN_URL_ERROR.name(), HTTPS_ERROR_DESC);
            LogUtilities.logWarning(errorException.getMessage(), iLogger);
            return;
        }
        String string2 = null;
        httpGet.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        HttpResponse httpResponse = null;
        CloseableHttpClient closeableHttpClient = HttpClients.custom().build();
        try {
            httpResponse = closeableHttpClient.execute(httpGet);
            object = httpResponse.getEntity();
            string2 = EntityUtils.toString((HttpEntity)object);
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage()});
            LogUtilities.logWarning(errorException.getMessage(), iLogger);
            return;
        }
        OAuthFactory.checkResponse(httpResponse, string2, iLogger);
        object = OAuthFactory.parseJsonResponse(string2.toString(), JSON_AUTH_ENDPOINT_KEY);
        String string3 = OAuthFactory.parseJsonResponse(string2.toString(), JSON_TOKEN_ENDPOINT_KEY);
        String string4 = OAuthFactory.parseJsonResponse(string2.toString(), JSON_RESPONSE_TYPE_KEY);
        if (null != object) {
            oAuthSettings.m_Oauth2AuthorizeEndpoint = object;
        }
        if (null != string3) {
            oAuthSettings.m_Oauth2TokenEndpointKey = string3;
        }
        if (null != string4 || string4 != "code") {
            LogUtilities.logWarning("code is not a supported response type, the authentication may fail. The driver will still try it", iLogger);
        }
    }

    public static String clientCredentialOAuth(HiveJDBCSettings hiveJDBCSettings, SSLSettings sSLSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings, sSLSettings, iLogger);
        URI uRI = OAuthFactory.getServerURI(hiveJDBCSettings.m_oAuthSettings);
        String string = null;
        HttpPost httpPost = new HttpPost(uRI);
        httpPost = OAuthFactory.setRequestParams(hiveJDBCSettings.m_oAuthSettings, httpPost);
        httpPost.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        string = OAuthFactory.executeRequestWithRetry(hiveJDBCSettings, uRI, httpPost, iLogger);
        String string2 = OAuthFactory.parseJsonResponse(string.toString(), JSON_ACCESS_TOKEN_KEY);
        OAuthFactory.setExpiryTime(string, hiveJDBCSettings.m_oAuthSettings, iLogger);
        if (null == string2) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
            throw errorException;
        }
        return string2;
    }

    public static String browerCredentialOauth(ILogger iLogger, OAuthTokenCache oAuthTokenCache, OAuthTokenCache oAuthTokenCache2, HiveJDBCSettings hiveJDBCSettings, String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, hiveJDBCSettings);
        OAuthSettings oAuthSettings = hiveJDBCSettings.m_oAuthSettings;
        URI uRI = OAuthFactory.getServerURI(oAuthSettings);
        String string2 = null;
        HttpPost httpPost = new HttpPost(uRI);
        httpPost = OAuthFactory.setRequestParams(oAuthSettings, httpPost);
        httpPost.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        string2 = OAuthFactory.executeRequestWithRetry(hiveJDBCSettings, uRI, httpPost, iLogger);
        String string3 = OAuthFactory.parseJsonResponse(string2.toString(), JSON_ACCESS_TOKEN_KEY);
        String string4 = "";
        if (hiveJDBCSettings.m_oAuthSettings.m_authFlow == OAuthFlow.BROWSER && hiveJDBCSettings.m_enableTokenCache.booleanValue() && ((string4 = OAuthFactory.parseJsonResponse(string2.toString(), JSON_REFRESH_TOKEN_KEY)) == null || string4.isEmpty())) {
            LogUtilities.logDebug("Refresh token not found.", iLogger);
        }
        OAuthFactory.setExpiryTime(string2, oAuthSettings, iLogger);
        if (null == string3) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
            throw errorException;
        }
        if (hiveJDBCSettings.m_oAuthSettings.m_authFlow == OAuthFlow.BROWSER && hiveJDBCSettings.m_enableTokenCache.booleanValue()) {
            OAuthFactory.cacheToken(hiveJDBCSettings, string2, oAuthTokenCache2, string3, string4, iLogger);
        }
        return string3;
    }

    public static String tokenCredentialOauth(OAuthSettings oAuthSettings, SSLSettings sSLSettings, ILogger iLogger, OAuthTokenCache oAuthTokenCache, OAuthTokenCache oAuthTokenCache2, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, oAuthSettings, sSLSettings, iLogger);
        URI uRI = OAuthFactory.getServerURI(oAuthSettings);
        String string = null;
        HttpPost httpPost = new HttpPost(uRI);
        httpPost = OAuthFactory.setTokenRequestParams(oAuthSettings, httpPost);
        httpPost.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        if (!httpPost.getURI().getScheme().equals(HTTPS_STRING)) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.AUTHORIZATIONN_URL_ERROR.name(), HTTPS_ERROR_DESC);
            throw errorException;
        }
        try {
            string = OAuthFactory.executeRequestWithRetry(hiveJDBCSettings, uRI, httpPost, iLogger);
        }
        catch (RefreshTokenExpiredException refreshTokenExpiredException) {
            LogUtilities.logError("Error occured during access token request using refresh token.", iLogger);
            if (refreshTokenExpiredException.getMessageParams() != null && refreshTokenExpiredException.getMessageParams().length > 0) {
                for (String string2 : refreshTokenExpiredException.getMessageParams()) {
                    LogUtilities.logError("Following error occured while getting the new access token. " + string2, iLogger);
                }
            }
            if (oAuthTokenCache.getTokenCache().getValue(hiveJDBCSettings.m_host) != null) {
                oAuthTokenCache.getTokenCache().setValue(hiveJDBCSettings.m_host, oAuthTokenCache.getTokenCache().getValue(hiveJDBCSettings.m_host), 0L);
            }
            throw refreshTokenExpiredException;
        }
        String string3 = OAuthFactory.parseJsonResponse(string.toString(), JSON_ACCESS_TOKEN_KEY);
        OAuthFactory.setExpiryTime(string, oAuthSettings, iLogger);
        String string4 = OAuthFactory.parseJsonResponse(string.toString(), JSON_REFRESH_TOKEN_KEY);
        if (string4 != null && !string4.equals(oAuthSettings.m_refreshToken) && hiveJDBCSettings.m_enableTokenCache.booleanValue()) {
            LogUtilities.logError("New refresh token received. Replacing old cached refresh token.", iLogger);
            oAuthSettings.m_refreshToken = string4;
        }
        if (null == string3) {
            RefreshTokenExpiredException refreshTokenExpiredException = new RefreshTokenExpiredException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), 0, new String[]{"Access token is missing."});
            throw refreshTokenExpiredException;
        }
        if (hiveJDBCSettings.m_oAuthSettings.m_authFlow == OAuthFlow.BROWSER && hiveJDBCSettings.m_enableTokenCache.booleanValue()) {
            OAuthFactory.cacheToken(hiveJDBCSettings, string, oAuthTokenCache2, string3, string4, iLogger);
        }
        return string3;
    }

    protected static void setExpiryTime(String string, OAuthSettings oAuthSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        int n = Integer.valueOf(OAuthFactory.parseJsonResponse(string.toString(), EXPIRY_TIME_KEY));
        if (oAuthSettings.m_tokenExpiryBuffer < n) {
            n -= oAuthSettings.m_tokenExpiryBuffer;
        } else {
            LogUtilities.logWarning("Token expiry buffer " + String.valueOf(oAuthSettings.m_tokenExpiryBuffer) + " is greater than the token expiry time " + n + ". A new token will be requested.", iLogger);
            n = 0;
        }
        oAuthSettings.m_expiryTime = System.currentTimeMillis() + (long)(n * 1000);
    }

    private static void checkResponse(HttpResponse httpResponse, String string, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n != 200) {
            if (n == 400) {
                String string2 = OAuthFactory.parseJsonResponse(string, JSON_ERROR_KEY);
                String string3 = OAuthFactory.parseJsonResponse(string, JSON_ERROR_DESCRIPTION_KEY);
                LogUtilities.logDebug("Got response code 400. Error: " + string2 + " Error Description: " + string3, iLogger);
                if (string3.equalsIgnoreCase(REFRESH_TOKEN_ERROR_DESC)) {
                    RefreshTokenExpiredException refreshTokenExpiredException = new RefreshTokenExpiredException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), 0, new String[]{string2, string3});
                    throw refreshTokenExpiredException;
                }
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{string2, string3});
                throw errorException;
            }
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{Integer.toString(n), httpResponse.getStatusLine().getReasonPhrase()});
            throw errorException;
        }
    }

    protected static String parseJsonResponse(String string, String string2) throws ErrorException {
        JsonNode jsonNode = null;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode2 = null;
        try {
            jsonNode2 = objectMapper.readTree(string);
        }
        catch (IOException iOException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.ERROR_PARSING_JSON_RESPONSE.name(), iOException.getMessage());
            errorException.initCause(iOException);
            throw errorException;
        }
        jsonNode = jsonNode2.get(string2);
        if (jsonNode != null) {
            return jsonNode.asText();
        }
        return null;
    }

    protected static HttpPost setRequestParams(OAuthSettings oAuthSettings, HttpPost httpPost) throws ErrorException {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
        if (OAuthFlow.BROWSER == oAuthSettings.m_authFlow) {
            arrayList.add(new BasicNameValuePair(GRANT_TYPE_KEY, BROWSER_CRED_GRANT));
            arrayList.add(new BasicNameValuePair(CLIENT_ID_KEY, oAuthSettings.m_authClientID));
            arrayList.add(new BasicNameValuePair("code", oAuthSettings.m_code));
            arrayList.add(new BasicNameValuePair(REDIRECT_URI, oAuthSettings.m_redirectUri));
            arrayList.add(new BasicNameValuePair(CODE_VERIFIER, oAuthSettings.m_codeVerifier));
        } else if (OAuthFlow.CLIENT_CREDENTIALS == oAuthSettings.m_authFlow) {
            arrayList.add(new BasicNameValuePair(GRANT_TYPE_KEY, CLIENT_CRED_GRANT));
            if (oAuthSettings.m_OAuthUseJWTAssertion.booleanValue()) {
                arrayList.add(new BasicNameValuePair(CLIENT_ID_KEY, oAuthSettings.m_authClientID));
                arrayList.add(new BasicNameValuePair(CLIENT_ASSERTION_TYPE_KEY, CLIENT_ASSERTION_TYPE_DEFAULT));
                arrayList.add(new BasicNameValuePair(CLIENT_ASSERTION_KEY, oAuthSettings.m_OAuthClientAssertion));
            } else if (oAuthSettings.m_authSource == OAuthSettings.OAuthSource.AZURE) {
                arrayList.add(new BasicNameValuePair(CLIENT_ID_KEY, oAuthSettings.m_authClientID));
                arrayList.add(new BasicNameValuePair(CLIENT_SECRET_KEY, oAuthSettings.m_authClientSecret));
            } else if (oAuthSettings.m_authSource == OAuthSettings.OAuthSource.AWS) {
                httpPost.addHeader("Authorization", "Basic " + new String(Base64.encodeBase64((oAuthSettings.m_authClientID + ":" + oAuthSettings.m_authClientSecret).getBytes())));
            }
        }
        if (null != oAuthSettings.m_authScope) {
            arrayList.add(new BasicNameValuePair(SCOPE_KEY, oAuthSettings.m_authScope));
        }
        try {
            httpPost.setEntity(new UrlEncodedFormEntity(arrayList, UTF_8_CHARSET));
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), exception.getCause().toString()});
            throw errorException;
        }
        return httpPost;
    }

    protected static String executeRequestWithRetry(HiveJDBCSettings hiveJDBCSettings, URI uRI, HttpPost httpPost, ILogger iLogger) throws ErrorException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        LogUtilities.logFunctionEntrance(iLogger, uRI, httpPost);
        SSLSettings sSLSettings = hiveJDBCSettings.m_oAuthSettings.m_tokenEndpointSSLSettings;
        HttpResponse httpResponse = null;
        String string = null;
        int n = m_retryAfterTimeSeconds;
        Instant instant = Instant.now();
        SSLSocketFactory sSLSocketFactory = CommonUtils.getSocketFactory(uRI.getHost(), sSLSettings);
        int n2 = hiveJDBCSettings.m_oAuthHTTPRetryTimeout * 60 * 1000;
        LogUtilities.logDebug("Timeout for OAuth HTTP request is " + n2 + " minutes.", iLogger);
        RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(n2).setConnectionRequestTimeout(n2).setSocketTimeout(n2).setCookieSpec("standard");
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setSSLSocketFactory(sSLSocketFactory);
        if (hiveJDBCSettings.m_proxySettings.m_useProxy && !hiveJDBCSettings.m_proxySettings.m_disableProxyForCloudFetch.booleanValue() && !CommonUtils.isHostInProxyBypassList(hiveJDBCSettings.m_proxySettings, httpPost)) {
            LogUtilities.logDebug("Proxy is enabled for OAuth HTTP request.", iLogger);
            object4 = hiveJDBCSettings.m_proxySettings;
            object3 = new HttpHost(((ProxySettings)object4).m_proxyHost, ((ProxySettings)object4).m_proxyPort);
            if (((ProxySettings)object4).m_proxyAuth == ProxySettings.ProxyAuthentication.BASIC) {
                object2 = new BasicCredentialsProvider();
                object = new AuthScope(((ProxySettings)object4).m_proxyHost, ((ProxySettings)object4).m_proxyPort);
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(((ProxySettings)object4).m_proxyUid, ((ProxySettings)object4).m_proxyPwd);
                object2.setCredentials((AuthScope)object, usernamePasswordCredentials);
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)object2);
            }
            builder.setProxy((HttpHost)object3);
        }
        object4 = builder.build();
        CloseableHttpClient closeableHttpClient = httpClientBuilder.setDefaultRequestConfig((RequestConfig)object4).build();
        do {
            try {
                if (hiveJDBCSettings.m_enableOAuthHTTPErrorTesting) {
                    LogUtilities.logWarning("EnableOAuthHTTPErrorTesting is enabled. Dummy HTTP response for testing purposes.", iLogger);
                    object3 = new DefaultHttpResponseFactory();
                    httpResponse = object3.newHttpResponse(new BasicStatusLine(HttpVersion.HTTP_1_1, 502, "Dummy HTTP response for testing purposes"), null);
                } else {
                    httpPost.setConfig((RequestConfig)object4);
                    httpResponse = closeableHttpClient.execute(httpPost);
                    object3 = httpResponse.getEntity();
                    string = EntityUtils.toString((HttpEntity)object3);
                }
            }
            catch (Exception exception) {
                object2 = exception.getCause() == null ? "" : exception.getCause().toString();
                object = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), object2});
                throw object;
            }
            if (httpResponse == null) continue;
            int n3 = httpResponse.getStatusLine().getStatusCode();
            LogUtilities.logWarning("Got response code " + n3, iLogger);
            if (n3 == 200 || n3 == 201 || n3 == 202 || n3 == 204) break;
            if (hiveJDBCSettings.m_oAuthRetriableHttpCode.contains(String.valueOf(n3))) {
                LogUtilities.logWarning("OAuth HTTP request for token was unsuccessful. Received HTTP status code " + n3 + " Retrying HTTP request.", iLogger);
                object2 = httpResponse.getFirstHeader(RETRY_AFTER_HEADER_IN_SECONDS);
                try {
                    if (object2 == null) {
                        LogUtilities.logWarning("Got Http Retry-After header null when executing OAuth HTTP request for token . ", iLogger);
                        LogUtilities.logWarning("Retrying HTTP request after " + n + " seconds for OAuth token  ", iLogger);
                        Thread.sleep(n * 1000);
                        n *= 2;
                        continue;
                    }
                    LogUtilities.logWarning("Received succesfully Http Retry-After header  when executing OAuth HTTP request for token . ", iLogger);
                    int n4 = Integer.valueOf(object2.getValue());
                    LogUtilities.logWarning("Retrying HTTP request after " + n4 + " seconds for OAuth HTTP request for token  ", iLogger);
                    Thread.sleep(n4 * 1000);
                }
                catch (InterruptedException interruptedException) {
                    LogUtilities.logWarning("Thread interrupted while waiting for http retry: " + interruptedException.getMessage(), iLogger);
                }
                continue;
            }
            LogUtilities.logWarning("OAuth HTTP request for token was unsuccessful. Received HTTP status code " + n3, iLogger);
            LogUtilities.logWarning("This HTTP status code is not listed in triable HTTP code setting. This request will not be retried", iLogger);
            if (!hiveJDBCSettings.m_enableOAuthHTTPErrorTesting) break;
            object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), "This HTTP status code is not listed in triable HTTP code setting. This request will not be retried");
            throw object2;
        } while (0 == hiveJDBCSettings.m_oAuthHTTPRetryTimeout || OAuthFactory.timeLapsed(instant, iLogger) <= hiveJDBCSettings.m_oAuthHTTPRetryTimeout);
        OAuthFactory.checkResponse(httpResponse, string, iLogger);
        return string;
    }

    private static HttpPost setTokenRequestParams(OAuthSettings oAuthSettings, HttpPost httpPost) throws ErrorException {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>(2);
        String string = JSON_REFRESH_TOKEN_KEY;
        arrayList.add(new BasicNameValuePair(GRANT_TYPE_KEY, string));
        arrayList.add(new BasicNameValuePair(string, oAuthSettings.m_refreshToken));
        arrayList.add(new BasicNameValuePair(CLIENT_ID_KEY, oAuthSettings.m_authClientID));
        try {
            httpPost.setEntity(new UrlEncodedFormEntity(arrayList, UTF_8_CHARSET));
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name(), new String[]{exception.getMessage(), exception.getCause().toString()});
            throw errorException;
        }
        return httpPost;
    }

    private static void cacheToken(HiveJDBCSettings hiveJDBCSettings, String string, OAuthTokenCache oAuthTokenCache, String string2, String string3, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        if (string2 != null && !string2.isEmpty()) {
            int n;
            LogUtilities.logDebug("Caching the access token.", iLogger);
            String string4 = hiveJDBCSettings.m_host + ".accesskey";
            try {
                n = Integer.valueOf(OAuthFactory.parseJsonResponse(string.toString(), EXPIRY_TIME_KEY));
            }
            catch (ErrorException | NumberFormatException exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.FAILURE_OAUTH_REQUEST.name());
                throw errorException;
            }
            if (hiveJDBCSettings.m_oAuthSettings.m_tokenExpiryBuffer < n) {
                LogUtilities.logDebug("Removing token expiry buffer time from expiry time", iLogger);
                n -= hiveJDBCSettings.m_oAuthSettings.m_tokenExpiryBuffer;
            } else {
                n = 0;
                LogUtilities.logWarning("Token expiry buffer " + String.valueOf(hiveJDBCSettings.m_oAuthSettings.m_tokenExpiryBuffer) + " is greater than the token expiry time " + n + ". A new token will be requested. ", iLogger);
            }
            oAuthTokenCache.getTokenCache().setValue(string4, string2, n);
            if (string3 != null && !string3.isEmpty()) {
                LogUtilities.logDebug("Caching  the refresh token.", iLogger);
                oAuthTokenCache.getTokenCache().setValue(hiveJDBCSettings.m_host, string3, Instant.now().getEpochSecond() * 2L);
            }
        }
    }

    private static int timeLapsed(Instant instant, ILogger iLogger) {
        Instant instant2 = Instant.now();
        int n = (int)Duration.between(instant, instant2).toMinutes();
        LogUtilities.logWarning("Time lapsed for this http request is " + n + " minutes.", iLogger);
        return n;
    }
}

