/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.jdbc.rpc;

import com.cloudera.hive.jdbc42.internal.apache.http.conn.DnsResolver;
import com.cloudera.hiveserver1.jdbc.common.CustomNetworkHooksSettings;
import com.cloudera.hiveserver1.jdbc.core.DSDriver;
import com.cloudera.hiveserver1.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.hiveserver1.jdbc.rpc.InternalDnsResolver;
import com.cloudera.hiveserver1.jdbc.utils.rpc.CustomNetworkHooks;
import com.cloudera.hiveserver1.support.ILogger;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import com.interfaces.networking.CustomDnsResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class CustomDnsResolverLoader
extends CustomNetworkHooks {
    public static DnsResolver getDnsResolver(CustomNetworkHooksSettings customNetworkHooksSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, customNetworkHooksSettings);
        CustomDnsResolver customDnsResolver = null;
        if (null != customNetworkHooksSettings.m_dnsResolver) {
            Class<CustomDnsResolver> clazz = null;
            try {
                clazz = Class.forName(customNetworkHooksSettings.m_dnsResolver).asSubclass(CustomDnsResolver.class);
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_INVALID_CUSTOM_CLASS.name(), new String[]{customNetworkHooksSettings.m_dnsResolver, exception.getClass().getName()});
                errorException.initCause(exception);
                throw errorException;
            }
            try {
                customDnsResolver = null == customNetworkHooksSettings.m_dnsResolverArg ? clazz.getConstructor(new Class[0]).newInstance(new Object[0]) : clazz.getConstructor(String.class).newInstance(customNetworkHooksSettings.m_dnsResolverArg);
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_INVALID_METHOD.name(), new String[]{customNetworkHooksSettings.m_dnsResolver, exception.getClass().getName(), customNetworkHooksSettings.m_dnsResolverArg});
                errorException.initCause(exception);
                throw errorException;
            }
            return new InternalDnsResolver(customDnsResolver);
        }
        return new InternalDnsResolver(null);
    }

    public static String getResolvedHost(DnsResolver dnsResolver, String string, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, dnsResolver, string);
        try {
            InetAddress[] inetAddressArray = dnsResolver.resolve(string);
            if (null != inetAddressArray && inetAddressArray.length > 0) {
                string = inetAddressArray[0].getHostAddress();
            } else {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNKNOWN_HOST_EXCEPTION.name(), new String[]{string, dnsResolver.getClass().getName(), "resolved host is null or has zero elements in it."});
                LogUtilities.logWarning(errorException, iLogger);
            }
        }
        catch (UnknownHostException unknownHostException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNKNOWN_HOST_EXCEPTION.name(), new String[]{string, dnsResolver.getClass().getName(), unknownHostException.getMessage()});
            throw errorException;
        }
        return string;
    }
}

