/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.IAEBinaryNode;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.List;

public class AEComparison
extends AEBooleanExpr
implements IAEBinaryNode<AEValueExprList, AEValueExprList> {
    private static final int NUM_CHILDREN = 2;
    private final ICoercionHandler m_coercionHandler;
    private AEValueExprList m_leftOperand;
    private AEValueExprList m_rightOperand;
    private AEComparisonType m_compOp;
    private IColumn m_coercionColumnMeta;
    private IAENode m_parent = null;

    public AEComparison(SqlDataEngineContext sqlDataEngineContext, AEComparisonType aEComparisonType, AEValueExprList aEValueExprList, AEValueExprList aEValueExprList2) throws ErrorException {
        if (null == sqlDataEngineContext || null == aEComparisonType || null == aEValueExprList || null == aEValueExprList2) {
            throw new IllegalArgumentException("AEComparison does not accept null parameters.");
        }
        this.m_coercionHandler = sqlDataEngineContext.getCoercionHandler();
        this.m_compOp = aEComparisonType;
        this.m_leftOperand = aEValueExprList;
        this.m_leftOperand.setParent(this);
        this.m_rightOperand = aEValueExprList2;
        this.m_rightOperand.setParent(this);
        this.initalizeMetadata(this.m_coercionHandler);
    }

    private AEComparison(AEComparison aEComparison) {
        this.m_compOp = aEComparison.m_compOp;
        this.m_coercionHandler = aEComparison.m_coercionHandler;
        this.m_leftOperand = aEComparison.m_leftOperand.copy();
        this.m_leftOperand.setParent(this);
        this.m_rightOperand = aEComparison.m_rightOperand.copy();
        this.m_rightOperand.setParent(this);
        this.setIsOptimized(aEComparison.isOptimized());
        this.m_coercionColumnMeta = ColumnMetadata.copyOf(aEComparison.m_coercionColumnMeta);
    }

    private void initalizeMetadata(ICoercionHandler iCoercionHandler) throws ErrorException {
        if (this.m_leftOperand.getNumChildren() != 1 && this.m_rightOperand.getNumChildren() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Comparison lists are not supported.");
        }
        AEValueExpr aEValueExpr = (AEValueExpr)this.m_leftOperand.getChild(0);
        AEValueExpr aEValueExpr2 = (AEValueExpr)this.m_rightOperand.getChild(0);
        this.m_coercionColumnMeta = iCoercionHandler.coerceComparisonColumns(new AECoercionColumnInfo(aEValueExpr), new AECoercionColumnInfo(aEValueExpr2));
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    public IColumn getCoercedColumnMetadata() {
        return this.m_coercionColumnMeta;
    }

    public AEComparisonType getComparisonOp() {
        return this.m_compOp;
    }

    @Override
    public String getLogString() {
        String string = "AEComparison: ";
        string = string + this.m_compOp.toString();
        return string;
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public IAENode getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IAENode iAENode) {
        this.m_parent = iAENode;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEComparison)) {
            return false;
        }
        AEComparison aEComparison = (AEComparison)iAENode;
        return this.m_compOp == aEComparison.m_compOp && this.m_leftOperand.isEquivalent(aEComparison.m_leftOperand) && this.m_rightOperand.isEquivalent(aEComparison.m_rightOperand) || this.m_compOp == aEComparison.m_compOp.flip() && this.m_leftOperand.isEquivalent(aEComparison.m_rightOperand) && this.m_rightOperand.isEquivalent(aEComparison.m_leftOperand);
    }

    @Override
    public AEBooleanExpr.AEBooleanType getType() {
        return AEBooleanExpr.AEBooleanType.COMPARISON;
    }

    @Override
    public AEComparison copy() {
        return new AEComparison(this);
    }

    @Override
    public AEValueExprList getLeftOperand() {
        return this.m_leftOperand;
    }

    @Override
    public AEValueExprList getRightOperand() {
        return this.m_rightOperand;
    }

    @Override
    public void updateCoercion() throws ErrorException {
        this.initalizeMetadata(this.m_coercionHandler);
    }

    @Override
    protected List<IAENode> asList() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                switch (n) {
                    case 0: {
                        return AEComparison.this.m_leftOperand;
                    }
                    case 1: {
                        return AEComparison.this.m_rightOperand;
                    }
                }
                throw new IndexOutOfBoundsException("Index: " + n);
            }

            @Override
            public int size() {
                return 2;
            }
        };
    }
}

