/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.dsiext.dataengine;

import com.cloudera.hiveserver1.dsi.core.interfaces.IConnection;
import com.cloudera.hiveserver1.dsi.core.interfaces.IStatement;
import com.cloudera.hiveserver1.dsi.core.utilities.Variant;
import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.dsi.exceptions.NumericOverflowException;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.SqlCustomBehaviourProvider;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SqlDataEngineContext {
    private IStatement m_statement;
    private SqlDataEngine m_dataEngine;
    private Variant m_currentCatalog;
    private boolean m_isCaseSensitive;
    private ICoercionHandler m_coercionHandler;
    private HashSet<AETable> m_tables = new HashSet();
    private Map<String, Integer> m_stringToTypeMap = null;
    private SqlCustomBehaviourProvider m_customBehaviourProvider = null;

    public SqlDataEngineContext(IStatement iStatement, SqlDataEngine sqlDataEngine) throws ErrorException {
        this.m_statement = iStatement;
        this.m_dataEngine = sqlDataEngine;
        IConnection iConnection = this.m_statement.getParentConnection();
        this.m_currentCatalog = iConnection.getProperty(22);
        this.m_coercionHandler = this.m_dataEngine.createCoercionHandler();
        this.m_isCaseSensitive = false;
        try {
            this.m_isCaseSensitive = this.getConnProperty(57).getChar() == '\u0003';
        }
        catch (IncorrectTypeException incorrectTypeException) {
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        this.m_customBehaviourProvider = sqlDataEngine.createCustomBehaviorProvider();
        this.m_customBehaviourProvider.initColumnFactory(sqlDataEngine);
    }

    public Variant getConnProperty(int n) throws ErrorException {
        if (22 == n) {
            return this.m_currentCatalog;
        }
        return this.m_statement.getParentConnection().getProperty(n);
    }

    public ICoercionHandler getCoercionHandler() {
        return this.m_coercionHandler;
    }

    public Variant getStmtProperty(int n) throws ErrorException {
        return this.m_statement.getProperty(n);
    }

    public Variant getDataEngineProperty(int n) throws ErrorException {
        return this.m_dataEngine.getProperty(n);
    }

    public SqlDataEngine getDataEngine() {
        return this.m_dataEngine;
    }

    public boolean isSqlCaseSensitive() {
        return this.m_isCaseSensitive;
    }

    public int getSqlTypeForTypeName(String string) throws ErrorException {
        Integer n;
        assert (null != string);
        Map<String, Integer> map = this.m_stringToTypeMap;
        if (null == map) {
            this.m_stringToTypeMap = map = this.initializeStringToTypeMap();
        }
        return null == (n = map.get(string)) ? 0 : n;
    }

    public void addReferencedTable(AETable aETable) throws ErrorException {
        if (!this.m_tables.add(aETable)) {
            throw new UnsupportedOperationException("Attempt to add duplicate table to set of referenced tables.");
        }
    }

    public Set<AETable> getReferencedTables() {
        return this.m_tables;
    }

    private TreeMap<String, Integer> initializeStringToTypeMap() throws ErrorException {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(String.valueOf(0));
        IResultSet iResultSet = this.m_dataEngine.makeNewMetadataResult(MetadataSourceID.TYPE_INFO, arrayList, "", "", false);
        DataWrapper dataWrapper = new DataWrapper();
        while (iResultSet.moveToNextRow()) {
            try {
                iResultSet.getData(0, 0L, -1L, dataWrapper);
                String string = dataWrapper.getVarChar();
                iResultSet.getData(1, 0L, -1L, dataWrapper);
                int n = dataWrapper.getSmallInt();
                treeMap.put(string, n);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new AssertionError((Object)incorrectTypeException);
            }
        }
        return treeMap;
    }

    public SqlCustomBehaviourProvider getCustomBehaviourProvider() {
        return this.m_customBehaviourProvider;
    }

    public IWarningListener getWarningListener() {
        return this.m_statement.getWarningListener();
    }
}

