/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor;

import com.cloudera.hiveserver1.dsi.dataengine.utilities.CursorType;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ExecutionContext;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ParameterInputValue;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ParameterOutputValue;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.ParameterType;
import com.cloudera.hiveserver1.dsi.exceptions.DefaultParamException;
import com.cloudera.hiveserver1.dsi.exceptions.ParamAlreadyPushedException;
import com.cloudera.hiveserver1.sqlengine.aeprocessor.aetree.statement.AEProcedureCall;
import com.cloudera.hiveserver1.sqlengine.dsiext.dataengine.ProcedureParameterMetadata;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.executor.ETProcedureResultSet;
import com.cloudera.hiveserver1.sqlengine.executor.IStatementExecutor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETCancelState;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETResourceManager;
import com.cloudera.hiveserver1.sqlengine.executor.etree.statement.ETProcedureCall;
import com.cloudera.hiveserver1.sqlengine.executor.etree.util.RegisterWarningListenerUtil;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETParameter;
import com.cloudera.hiveserver1.sqlengine.executor.materializer.MaterializerContext;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.LogUtilities;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProcedureExecutor
implements IStatementExecutor {
    private ETProcedureCall m_etProcedureCall;
    private AEProcedureCall m_aeProcedureCall;
    private ETResourceManager m_rscManager;
    private MaterializerContext m_materializerContext;

    public ProcedureExecutor(ETProcedureCall eTProcedureCall, AEProcedureCall aEProcedureCall, MaterializerContext materializerContext) {
        if (null == eTProcedureCall.getProcedure()) {
            throw new IllegalArgumentException();
        }
        this.m_etProcedureCall = eTProcedureCall;
        this.m_aeProcedureCall = aEProcedureCall;
        this.m_rscManager = materializerContext.getResourceManager();
        this.m_materializerContext = materializerContext;
    }

    @Override
    public void close() {
        if (this.m_etProcedureCall.isResultSet()) {
            try {
                this.m_etProcedureCall.getOperand().close(true);
            }
            catch (Exception exception) {
                LogUtilities.logError(exception, this.m_materializerContext.getLog());
            }
            this.m_etProcedureCall = null;
            if (null != this.m_rscManager) {
                try {
                    this.m_rscManager.free();
                }
                catch (Exception exception) {
                    LogUtilities.logError(exception, this.m_materializerContext.getLog());
                }
                this.m_rscManager = null;
            }
        }
    }

    @Override
    public ETCancelState getCancelState() {
        return this.m_materializerContext.getCancelState();
    }

    @Override
    public ExecutionResult execute(ExecutionContext executionContext) throws ErrorException {
        this.m_materializerContext.getCancelState().checkCancel();
        if (this.m_etProcedureCall.getOperand().isOpen()) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Multiple active open result sets is not supported.");
        }
        this.pushParameters(executionContext);
        ETProcedureResultSet eTProcedureResultSet = new ETProcedureResultSet(this.m_etProcedureCall, this.m_rscManager, this.m_materializerContext.getCancelState());
        eTProcedureResultSet.open(CursorType.FORWARD_ONLY);
        return eTProcedureResultSet.getExecutionResult();
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        RegisterWarningListenerUtil.registerWarningListener(iWarningListener, this.m_etProcedureCall);
    }

    private void pushParameters(ExecutionContext executionContext) {
        List<ProcedureParameterMetadata> list = this.m_aeProcedureCall.getOperand().getExpectedDynamicParamMeta();
        ArrayList<ParameterInputValue> arrayList = executionContext.getInputs();
        ArrayList<ParameterOutputValue> arrayList2 = executionContext.getOutputs();
        int n = 0;
        int n2 = 0;
        for (Map.Entry<Integer, ETParameter> entry : this.m_etProcedureCall.getParameters().entrySet()) {
            int n3 = entry.getKey();
            try {
                Object object;
                ParameterType parameterType = entry.getValue().getParamType();
                if (ParameterType.OUTPUT == parameterType || ParameterType.RETURN_VALUE == parameterType) {
                    object = arrayList2.get(n2);
                    entry.getValue().setOutputData(((ParameterOutputValue)object).getData());
                    entry.getValue().setCachedDataWrapper(((ParameterOutputValue)object).getData());
                    ++n2;
                    continue;
                }
                if (ParameterType.INPUT == parameterType || ParameterType.INPUT_OUTPUT == parameterType) {
                    object = arrayList.get(n);
                    entry.getValue().setInputData(((ParameterInputValue)object).getData());
                    ++n;
                    if (ParameterType.INPUT_OUTPUT != parameterType) continue;
                    ParameterOutputValue parameterOutputValue = arrayList2.get(n2);
                    entry.getValue().setCachedDataWrapper(parameterOutputValue.getData());
                    ++n2;
                    continue;
                }
                throw new IllegalStateException("Invalid parameter type.");
            }
            catch (ParamAlreadyPushedException paramAlreadyPushedException) {
                throw new IllegalStateException("pushed parameter encountered during execution.");
            }
            catch (DefaultParamException defaultParamException) {
                throw new IllegalStateException("Default parameter encountered during execution.");
            }
        }
    }

    @Override
    public void startBatch() {
    }

    @Override
    public void endBatch() throws ErrorException {
    }

    @Override
    public boolean generatesResultSet() {
        return true;
    }
}

