/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.conversions;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.exceptions.InvalidOperationException;
import com.cloudera.hiveserver1.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.hiveserver1.sqlengine.executor.conversions.SqlConverterGenerator;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.IWarningListener;
import com.cloudera.hiveserver1.support.Warning;
import com.cloudera.hiveserver1.support.WarningCode;
import com.cloudera.hiveserver1.support.conv.ConversionResult;
import com.cloudera.hiveserver1.support.exceptions.DiagState;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

public class ConversionUtil {
    private ConversionUtil() {
    }

    public static final void checkForErrorOnly(ConversionResult conversionResult, boolean bl, int n, int n2) throws ErrorException {
        switch (conversionResult.getState()) {
            case DATETIME_OVERFLOW: {
                if (!bl) break;
                throw new ErrorException(DiagState.DIAG_DATETIME_OVERFLOW, 7, SQLEngineMessageKey.DATETIME_OVERFLOW.name(), n2, n);
            }
            case FRAC_TRUNCATION_ROUNDED_UP: 
            case FRAC_TRUNCATION_ROUNDED_DOWN: {
                if (!bl) break;
                throw new ErrorException(DiagState.DIAG_FRACTIONAL_TRUNC, 7, SQLEngineMessageKey.FRAC_TRUNCATION.name(), n2, n);
            }
            case INTERVAL_OVERFLOW_TOO_LARGE: 
            case INTERVAL_OVERFLOW_TOO_SMALL: {
                throw new ErrorException(DiagState.DIAG_INTERVAL_OVERFLOW, 7, SQLEngineMessageKey.INTERVAL_FIELD_OVERFLOW.name(), n2, n);
            }
            case INVALID_CHAR_VAL_FOR_CAST: {
                throw new ErrorException(DiagState.DIAG_INVALID_CHAR_VAL_FOR_CAST, 7, SQLEngineMessageKey.INVALID_CHAR_FOR_CAST.name(), n2, n);
            }
            case INVALID_DATA: {
                throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 7, SQLEngineMessageKey.CONV_LOGIC_ERROR.name(), n2, n);
            }
            case NUMERIC_OUT_OF_RANGE_TOO_LARGE: 
            case NUMERIC_OUT_OF_RANGE_TOO_SMALL: {
                throw new ErrorException(DiagState.DIAG_NUM_VAL_OUT_OF_RANGE, 7, SQLEngineMessageKey.CONV_NUMERIC_OUT_OF_RANGE.name(), n2, n);
            }
            case RESTRICTED_DATA_TYPE_ATTR_VIOLATION: {
                throw new ErrorException(DiagState.DIAG_RESTRICTED_DATA_TYPE_ATTR_VIOLATION, 7, SQLEngineMessageKey.INVALID_MULTI_FIELD_INTERVAL_CONV.name(), n2, n);
            }
            case STRING_RIGHT_TRUNCATION: {
                if (!bl) break;
                throw new ErrorException(DiagState.DIAG_STR_RIGHT_TRUNC_ERR, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), n2, n);
            }
        }
    }

    public static final void checkResult(ConversionResult conversionResult, boolean bl, boolean bl2, IWarningListener iWarningListener, int n, int n2) throws ErrorException {
        switch (conversionResult.getState()) {
            case SUCCESS: {
                break;
            }
            case DATETIME_OVERFLOW: {
                if (bl) {
                    throw new ErrorException(DiagState.DIAG_DATETIME_OVERFLOW, 7, SQLEngineMessageKey.DATETIME_OVERFLOW.name(), n2, n);
                }
                if (null == iWarningListener) break;
                iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 7, SQLEngineMessageKey.DATETIME_OVERFLOW.name(), (long)n2, n));
                break;
            }
            case FRAC_TRUNCATION_ROUNDED_UP: 
            case FRAC_TRUNCATION_ROUNDED_DOWN: {
                if (bl) {
                    throw new ErrorException(DiagState.DIAG_FRACTIONAL_TRUNC, 7, SQLEngineMessageKey.FRAC_TRUNCATION.name(), n2, n);
                }
                if (null == iWarningListener) break;
                iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 7, SQLEngineMessageKey.FRAC_TRUNCATION.name(), (long)n2, n));
                break;
            }
            case INTERVAL_OVERFLOW_TOO_LARGE: 
            case INTERVAL_OVERFLOW_TOO_SMALL: {
                throw new ErrorException(DiagState.DIAG_INTERVAL_OVERFLOW, 7, SQLEngineMessageKey.INTERVAL_FIELD_OVERFLOW.name(), n2, n);
            }
            case INVALID_CHAR_VAL_FOR_CAST: {
                throw new ErrorException(DiagState.DIAG_INVALID_CHAR_VAL_FOR_CAST, 7, SQLEngineMessageKey.INVALID_CHAR_FOR_CAST.name(), n2, n);
            }
            case INVALID_DATA: {
                throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 7, SQLEngineMessageKey.CONV_LOGIC_ERROR.name(), n2, n);
            }
            case NUMERIC_OUT_OF_RANGE_TOO_LARGE: 
            case NUMERIC_OUT_OF_RANGE_TOO_SMALL: {
                throw new ErrorException(DiagState.DIAG_NUM_VAL_OUT_OF_RANGE, 7, SQLEngineMessageKey.CONV_NUMERIC_OUT_OF_RANGE.name(), n2, n);
            }
            case RESTRICTED_DATA_TYPE_ATTR_VIOLATION: {
                throw new ErrorException(DiagState.DIAG_RESTRICTED_DATA_TYPE_ATTR_VIOLATION, 7, SQLEngineMessageKey.INVALID_MULTI_FIELD_INTERVAL_CONV.name(), n2, n);
            }
            case STRING_RIGHT_TRUNCATION: {
                if (bl2) {
                    throw new ErrorException(DiagState.DIAG_STR_RIGHT_TRUNC_ERR, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), n2, n);
                }
                if (null == iWarningListener) break;
                iWarningListener.postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), (long)n2, n));
                break;
            }
            case INTEGRAL_PRECISION_LOSS: {
                if (null == iWarningListener) break;
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 7, SQLEngineMessageKey.INTEGRAL_PRECISION_LOSS.name(), (long)n2, n));
                break;
            }
            default: {
                throw new InvalidOperationException();
            }
        }
    }

    public static final void checkResult(ConversionResult conversionResult, IWarningListener iWarningListener, int n, int n2) throws ErrorException {
        ConversionUtil.checkResult(conversionResult, false, false, iWarningListener, n, n2);
    }

    public static boolean doConvert(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlConverter iSqlConverter, IWarningListener iWarningListener, boolean bl) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper2 = eTDataRequest.getData();
        ConversionResult conversionResult = iSqlConverter.convert(iSqlDataWrapper, iSqlDataWrapper2);
        ConversionUtil.checkResult(conversionResult, false, bl, iWarningListener, -1, -1);
        boolean bl2 = false;
        if (!iSqlDataWrapper2.isNull()) {
            if (eTDataRequest.getMetadata().isBinaryType()) {
                bl2 = DataRetrievalUtil.retrieveBinaryData(iSqlDataWrapper2, eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
            }
            if (eTDataRequest.getMetadata().isCharacterType()) {
                bl2 = DataRetrievalUtil.retrieveCharData(iSqlDataWrapper2, eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
            }
        }
        return bl2;
    }

    public static ISqlConverter createConverter(SqlConverterGenerator sqlConverterGenerator, IColumn iColumn, IColumn iColumn2) throws ErrorException {
        ISqlConverter iSqlConverter = sqlConverterGenerator.createCustomConverter(iColumn, iColumn2);
        if (iSqlConverter != null) {
            return iSqlConverter;
        }
        if (DefaultSqlDataWrapper.isImplicitConvSupported(iColumn, iColumn2)) {
            return null;
        }
        return sqlConverterGenerator.createConverter(iColumn, iColumn2);
    }
}

