/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.conversions;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.support.conv.ApproxNumConverter;
import com.cloudera.hiveserver1.support.conv.ConversionResult;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SqlApproxNumConverter
implements ISqlConverter {
    private final IColumn m_targetMeta;
    private final short m_targetType;

    public SqlApproxNumConverter(IColumn iColumn, IColumn iColumn2) {
        assert (iColumn.getTypeMetadata().isApproximateNumericType());
        this.m_targetMeta = iColumn2;
        this.m_targetType = this.m_targetMeta.getTypeMetadata().getType();
    }

    @Override
    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return conversionResult;
        }
        double d = iSqlDataWrapper.getDouble();
        switch (this.m_targetType) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = ApproxNumConverter.toChar(d, this.m_targetMeta.getColumnLength(), conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            case 7: {
                float f = ApproxNumConverter.toFloat(d, conversionResult);
                iSqlDataWrapper2.setReal(f);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ApproxNumConverter.toBigDecimal(d, this.m_targetMeta.getTypeMetadata().getPrecision(), this.m_targetMeta.getTypeMetadata().getScale(), conversionResult);
                iSqlDataWrapper2.setExactNumber(bigDecimal);
                break;
            }
            case -5: {
                BigInteger bigInteger = ApproxNumConverter.toBigInt(d, this.m_targetMeta.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setBigInt(bigInteger);
                break;
            }
            case 4: {
                long l = ApproxNumConverter.toInteger(d, this.m_targetMeta.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setInteger(l);
                break;
            }
            case 5: {
                int n = ApproxNumConverter.toSmallInt(d, this.m_targetMeta.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setSmallInt(n);
                break;
            }
            case -6: {
                short s = ApproxNumConverter.toTinyInt(d, this.m_targetMeta.getTypeMetadata().isSigned(), conversionResult);
                iSqlDataWrapper2.setTinyInt(s);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString(this.m_targetType));
            }
        }
        return conversionResult;
    }
}

