/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.datawrapper;

import com.cloudera.hiveserver1.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver1.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.Date;

public final class SqlDateDataWrapper
extends DefaultSqlDataWrapper {
    private java.sql.Date m_data;
    private boolean m_isSet = false;

    @Override
    public java.sql.Date getDate() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public Date getJavaUtilDate() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public int getType() {
        return 91;
    }

    @Override
    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setDate(java.sql.Date date) {
        this.m_isSet = true;
        this.m_data = date;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            switch (dataWrapper.getType()) {
                case 91: {
                    this.setDate(dataWrapper.getDate());
                    break;
                }
                case 0: {
                    if (dataWrapper.isNull()) {
                        this.setNull();
                        break;
                    }
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        dataWrapper.setDate(this.m_data);
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

