/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.bool;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.CursorType;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETBinaryNode;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver1.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

public abstract class ETComplexBooleanExpr
extends ETBooleanExpr
implements IETBinaryNode<ETValueExpr, ETRelationalExpr> {
    private ETDataRequest m_leftData;
    private ETDataRequest m_rightData;
    private ETValueExpr m_leftOperand;
    private ETRelationalExpr m_rightOperand;

    protected ETComplexBooleanExpr(IColumn iColumn, ETValueExpr eTValueExpr, ETRelationalExpr eTRelationalExpr) {
        if (iColumn == null || eTValueExpr == null || eTRelationalExpr == null) {
            throw new NullPointerException("ETComplexBooleanExpr does not take null input.");
        }
        assert (1 == eTRelationalExpr.getColumnCount()) : "Not yet supported";
        this.m_leftOperand = eTValueExpr;
        this.m_rightOperand = eTRelationalExpr;
        this.m_rightData = new ETDataRequest(iColumn);
        this.m_rightData.setMaxBytes(-1L);
        this.m_leftData = new ETDataRequest(iColumn);
        this.m_leftData.setMaxBytes(-1L);
    }

    @Override
    public void close(boolean bl) {
        this.m_leftOperand.close(bl);
        this.m_rightOperand.close(bl);
    }

    @Override
    public boolean isOpen() {
        return this.m_leftOperand.isOpen() && this.m_rightOperand.isOpen();
    }

    @Override
    public void open() throws ErrorException {
        this.m_leftOperand.open();
        this.m_rightOperand.open(CursorType.FORWARD_ONLY);
    }

    @Override
    public void reset() throws ErrorException {
        this.m_leftOperand.reset();
        this.m_rightOperand.reset();
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public ETValueExpr getLeftOperand() {
        return this.m_leftOperand;
    }

    @Override
    public ETRelationalExpr getRightOperand() {
        return this.m_rightOperand;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (0 == n) {
            return this.getLeftOperand();
        }
        if (1 == n) {
            return this.getRightOperand();
        }
        throw new IndexOutOfBoundsException();
    }

    protected ETDataRequest getLeftData() {
        return this.m_leftData;
    }

    protected ETDataRequest getRightData() {
        return this.m_rightData;
    }

    protected void fillLeftData() throws ErrorException {
        this.m_leftData.getData().setNull();
        this.m_leftOperand.retrieveData(this.m_leftData);
    }

    protected void fillRightData() throws ErrorException {
        this.m_rightData.getData().setNull();
        this.m_rightOperand.retrieveData(0, this.m_rightData);
    }
}

