/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.bool;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETBoolean;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;

public class ETNullPredicate
extends ETBooleanExpr {
    private ETValueExpr m_operand;
    private ETDataRequest m_data;

    public ETNullPredicate(ETValueExpr eTValueExpr, IColumn iColumn) throws ErrorException {
        if (eTValueExpr == null) {
            throw new NullPointerException("ETArithmeticValueExpr does not take null input.");
        }
        this.m_data = new ETDataRequest(iColumn);
        this.m_operand = eTValueExpr;
    }

    @Override
    public void close(boolean bl) {
        this.m_operand.close(bl);
    }

    @Override
    public boolean isOpen() {
        return this.m_operand.isOpen();
    }

    @Override
    public void reset() throws ErrorException {
        this.m_operand.reset();
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public ETBoolean evaluate() throws ErrorException {
        this.m_operand.retrieveData(this.m_data);
        return this.m_data.getData().isNull() ? ETBoolean.SQL_BOOLEAN_TRUE : ETBoolean.SQL_BOOLEAN_FALSE;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.m_operand;
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }

    @Override
    public void open() throws ErrorException {
        this.m_operand.open();
    }
}

