/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.relation;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.dsi.dataengine.utilities.CursorType;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IMemManagerAgent;
import com.cloudera.hiveserver1.sqlengine.executor.etree.IMemoryConsumer;
import com.cloudera.hiveserver1.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.relation.ETUnaryRelationalExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.IRowView;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.InMemTable;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.IndexRowView;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.LongDataStore;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.TemporaryFile;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver1.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.hiveserver1.sqlengine.utilities.ExternalAlgorithmUtil;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.Comparator;
import java.util.List;

public class ETDistinctMove
extends ETUnaryRelationalExpr
implements IMemoryConsumer {
    private static final int EIGHT_KB = 8192;
    private ETRowListener m_rowListener;
    private Comparator<IRowView> m_rowComparator;
    private IColumn[] m_metadata;
    private InMemTable m_rowCache;
    private boolean[] m_isLongData;
    private LongDataStore m_longDataStore;
    private int m_currentCacheRow;
    private int m_nextCacheRow;
    private ExternalAlgorithmUtil.ExternalAlgorithmProperties m_extProps;
    private long m_memoryAllocated = 0L;
    private ETDataRequest[] m_dataRequests;
    private boolean m_isCacheInitialized = false;
    private boolean m_isFirstMove;
    private boolean m_hasMoreRows;
    private IMemManagerAgent m_memAgent;

    public ETDistinctMove(ETRelationalExpr eTRelationalExpr, List<IColumn> list, Comparator<IRowView> comparator, ExternalAlgorithmUtil.ExternalAlgorithmProperties externalAlgorithmProperties, boolean[] blArray) {
        super(eTRelationalExpr, blArray);
        this.m_metadata = list.toArray(new IColumn[0]);
        this.m_extProps = externalAlgorithmProperties;
        this.m_rowComparator = comparator;
        this.m_rowCache = new InMemTable(this.m_metadata, externalAlgorithmProperties.getCellMemoryLimit(), 2, blArray, null);
        this.m_isLongData = new boolean[this.m_metadata.length];
        for (int i = 0; i < this.m_metadata.length; ++i) {
            boolean bl;
            this.m_isLongData[i] = bl = ColumnSizeCalculator.isLongData(this.m_metadata[i], externalAlgorithmProperties.getCellMemoryLimit());
        }
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.getOperand().getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return this.getOperand().getColumnCount();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.getOperand().getRowCount();
    }

    @Override
    public String getLogString() {
        return "ETDistinctMove";
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        int n;
        super.open(cursorType);
        if (this.m_memoryAllocated < this.getRequiredMemory()) {
            throw new IllegalStateException("Not enough memory allocated.");
        }
        for (n = 0; n < this.m_isLongData.length; ++n) {
            if (!this.m_dataNeeded[n] || !this.m_isLongData[n] || null != this.m_longDataStore) continue;
            this.m_longDataStore = new LongDataStore(this.m_extProps.getStorageDir(), 8192L, null);
        }
        if (null == this.m_dataRequests) {
            this.m_dataRequests = new ETDataRequest[this.m_metadata.length];
            for (n = 0; n < this.m_metadata.length; ++n) {
                if (!this.m_dataNeeded[n]) continue;
                this.m_dataRequests[n] = new ETDataRequest(this.m_metadata[n]);
            }
        }
        if (!this.m_isCacheInitialized) {
            this.m_rowCache.setMemLimit(Long.MAX_VALUE);
            this.m_currentCacheRow = this.m_rowCache.appendRow();
            this.m_nextCacheRow = this.m_rowCache.appendRow();
            this.m_rowCache.reduceMemoryUsage();
            this.m_isCacheInitialized = true;
        }
        this.m_isFirstMove = true;
        this.m_hasMoreRows = true;
    }

    @Override
    public void close(boolean bl) {
        super.close(bl);
        this.m_rowCache.setMemLimit(0L);
        this.m_rowCache.clear();
        this.m_isCacheInitialized = false;
        if (!bl) {
            this.m_memAgent.recycleMemory(this.m_memoryAllocated);
            this.m_memAgent.unregisterConsumer();
            this.m_memoryAllocated = 0L;
        }
    }

    @Override
    public void reset() throws ErrorException {
        super.reset();
        this.m_isFirstMove = true;
        this.m_hasMoreRows = true;
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        assert (this.m_dataNeeded[n]) : "data not needed " + n;
        IndexRowView indexRowView = new IndexRowView(this.m_rowCache);
        indexRowView.setRowNum(this.m_currentCacheRow);
        return DataRetrievalUtil.retrieveFromRowView(n, this.m_isLongData[n], eTDataRequest, (IRowView)indexRowView, this.m_longDataStore);
    }

    public void registerRowLister(ETRowListener eTRowListener) {
        this.m_rowListener = eTRowListener;
    }

    @Override
    public long assign(long l) {
        long l2 = this.getRequiredMemory();
        if (this.m_memoryAllocated >= l2) {
            return 0L;
        }
        l = Math.min(l, l2 - this.m_memoryAllocated);
        this.m_memoryAllocated += l;
        return l;
    }

    @Override
    public long getRequiredMemory() {
        return 2L * this.m_rowCache.getRowSize() + (long)this.m_rowCache.getMemOverhead() + 8192L;
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_memAgent = iMemManagerAgent;
    }

    @Override
    protected boolean doMove() throws ErrorException {
        if (this.m_hasMoreRows) {
            boolean bl;
            boolean bl2 = false;
            if (this.m_isFirstMove) {
                this.m_isFirstMove = false;
                bl = this.moveAndFetchToCache();
            } else {
                this.flipCache();
                bl = true;
            }
            if (bl) {
                this.updateRowListener();
            }
            while (this.moveAndFetchToCache()) {
                if (!this.isDuplicateRow()) {
                    this.flipCache();
                    bl2 = true;
                    break;
                }
                this.updateRowListener();
            }
            this.m_hasMoreRows = bl2;
            return bl;
        }
        return false;
    }

    private void updateRowListener() throws ErrorException {
        if (null != this.m_rowListener) {
            this.m_rowListener.onNewRow();
        }
    }

    private void flipCache() {
        int n = this.m_currentCacheRow;
        this.m_currentCacheRow = this.m_nextCacheRow;
        this.m_nextCacheRow = n;
    }

    private boolean isDuplicateRow() {
        IndexRowView indexRowView = new IndexRowView(this.m_rowCache);
        indexRowView.setRowNum(this.m_currentCacheRow);
        IndexRowView indexRowView2 = new IndexRowView(this.m_rowCache);
        indexRowView2.setRowNum(this.m_nextCacheRow);
        return 0 == this.m_rowComparator.compare(indexRowView, indexRowView2);
    }

    private boolean moveAndFetchToCache() throws ErrorException {
        if (this.getOperand().move()) {
            this.flipCache();
            for (int i = 0; i < this.m_metadata.length; ++i) {
                Object object;
                if (!this.m_dataNeeded[i]) continue;
                if (this.m_isLongData[i]) {
                    object = this.m_longDataStore.put(i, this.getOperand());
                    if (null == object) {
                        this.m_rowCache.setNull(this.m_currentCacheRow, i);
                        continue;
                    }
                    this.m_rowCache.setFileMarker(this.m_currentCacheRow, i, (TemporaryFile.FileMarker)object);
                    continue;
                }
                object = this.m_dataRequests[i];
                ((ETDataRequest)object).getData().setNull();
                this.getOperand().retrieveData(i, (ETDataRequest)object);
                ISqlDataWrapper iSqlDataWrapper = ((ETDataRequest)object).getData();
                InMemTable.setColumn(this.m_rowCache, iSqlDataWrapper, this.m_metadata[i], i, this.m_currentCacheRow);
            }
            return true;
        }
        return false;
    }

    static interface ETRowListener {
        public void onNewRow() throws ErrorException;
    }
}

