/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.relation.join;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

class ResizeableByteArrayOS
extends OutputStream
implements Closeable,
Flushable {
    private byte[] m_buff;
    private int m_count = 0;

    public ResizeableByteArrayOS() {
        this(32);
    }

    public ResizeableByteArrayOS(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.m_buff = new byte[n];
    }

    @Override
    public void close() {
    }

    public void reset() {
        this.m_count = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.m_buff, this.m_count);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.m_count + n2;
        if (n3 > this.m_buff.length) {
            this.m_buff = Arrays.copyOf(this.m_buff, Math.max(this.m_buff.length << 1, n3));
        }
        System.arraycopy(byArray, n, this.m_buff, this.m_count, n2);
        this.m_count = n3;
    }

    @Override
    public void write(int n) throws IOException {
        int n2 = this.m_count + 1;
        if (n2 > this.m_buff.length) {
            this.m_buff = Arrays.copyOf(this.m_buff, Math.max(this.m_buff.length << 1, n2));
        }
        this.m_buff[this.m_count] = (byte)n;
        this.m_count = n2;
    }

    public void writeToOutputStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.m_buff, 0, this.m_count);
    }

    public void destroyBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.m_count = 0;
        this.m_buff = new byte[n];
    }

    public int size() {
        return this.m_count;
    }
}

