/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column;

import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.cloudera.hiveserver1.sqlengine.executor.etree.temptable.column.IColumnSlice;

public final class CharColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = 2677650540629864998L;
    private String[] m_data;
    private final int m_columnNumber;

    public CharColumnSlice(int n, int n2) {
        this.m_data = new String[n];
        this.m_columnNumber = n2;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return null == this.m_data[n];
    }

    @Override
    public void setNull(int n) {
        this.m_data[n] = null;
    }

    @Override
    public String getString(int n) {
        return this.m_data[n];
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.CHAR;
    }

    @Override
    public void setString(int n, String string) {
        this.m_data[n] = string;
    }

    @Override
    public int size() {
        return this.m_data.length;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        if (!(iColumnSlice instanceof CharColumnSlice)) {
            throw new IllegalArgumentException("Unknown column slice type");
        }
        CharColumnSlice charColumnSlice = (CharColumnSlice)iColumnSlice;
        System.arraycopy(charColumnSlice.m_data, n, this.m_data, n3, n2);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize, int n) {
        return javaSize.estimateStringSize(n);
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return javaSize.getObjectRefSize();
    }
}

