/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.List;

public final class ETCurDateFn
extends ETScalarFn {
    private long m_dateInMillis;

    public ETCurDateFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (list.isEmpty() && list2.isEmpty());
    }

    @Override
    public void open() throws ErrorException {
        super.open();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        this.m_dateInMillis = gregorianCalendar.getTimeInMillis();
    }

    @Override
    public String getLogString() {
        return "ETCurDateFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        assert (this.isOpen());
        eTDataRequest.getData().setDate(new Date(this.m_dateInMillis));
        return false;
    }
}

