/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar;

import com.cloudera.hiveserver1.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver1.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.hiveserver1.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver1.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.hiveserver1.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.hiveserver1.support.Warning;
import com.cloudera.hiveserver1.support.WarningCode;
import com.cloudera.hiveserver1.support.exceptions.ErrorException;
import java.util.List;

public final class ETSubstringFn
extends ETScalarFn {
    private final long m_columnLength;
    private final boolean m_hasLengthArg;

    public ETSubstringFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (2 == this.getNumChildren() || 3 == this.getNumChildren());
        assert (iColumn.getTypeMetadata().isCharacterType());
        this.m_columnLength = iColumn.getColumnLength();
        this.m_hasLengthArg = 2 < this.getNumChildren();
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper;
        long l = eTDataRequest.getOffset() / 2L;
        long l2 = eTDataRequest.getMaxSize();
        long l3 = this.m_columnLength - l;
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(1);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        long l4 = Math.max(iSqlDataWrapper2.getInteger(), 1L) - 1L + l;
        long l5 = (l4 + this.m_columnLength) * 2L;
        long l6 = 0L;
        if (this.m_hasLengthArg) {
            iSqlDataWrapper = this.getArgumentData(2);
            if (iSqlDataWrapper.isNull()) {
                eTDataRequest.getData().setNull();
                return false;
            }
            l6 = Math.max(iSqlDataWrapper.getInteger(), 0L) - l;
            if (this.m_columnLength > l6) {
                l5 = (l4 + l6) * 2L;
            }
        }
        if (-1L != l2 && l5 - 2L * l4 > l2) {
            l5 = 2L * l4 + l2;
        }
        if ((iSqlDataWrapper = this.getArgumentData(0, 0L, l5)).isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper.getChar();
        l4 = Math.min(l4, (long)string.length());
        string = string.substring((int)l4);
        eTDataRequest.getData().setChar(string);
        if (this.hasMoreData(0)) {
            if (!((long)string.length() < l3 || this.m_hasLengthArg && l3 >= l6)) {
                this.getWarningListener().postWarning(new Warning(WarningCode.STRING_RIGHT_TRUNCATION_WARNING, 7, SQLEngineMessageKey.STRING_RIGHT_TRUNCATION.name(), -1L, -1));
            } else if (!this.m_hasLengthArg || (long)string.length() < l6) {
                return true;
            }
        }
        return false;
    }
}

