/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver1.sqlengine.parser;

import com.cloudera.hiveserver1.sqlengine.exceptions.SQLEngineException;
import com.cloudera.hiveserver1.sqlengine.parser.DefaultLimitChecker;
import com.cloudera.hiveserver1.sqlengine.parser.IPTLimitChecker;
import com.cloudera.hiveserver1.sqlengine.parser.generated.YYParser;
import com.cloudera.hiveserver1.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.hiveserver1.sqlengine.parser.type.PTStringConstraint;

public class PTParser {
    private PTParser() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static IPTNode parse(String string) throws SQLEngineException {
        return PTParser.parse(string, new DefaultLimitChecker());
    }

    public static IPTNode parse(String string, IPTLimitChecker iPTLimitChecker) throws SQLEngineException {
        if (null == string) {
            throw new NullPointerException("sqlStatement must not be null");
        }
        if (null == iPTLimitChecker) {
            throw new NullPointerException("limitChecker must not be null");
        }
        iPTLimitChecker.checkString(PTStringConstraint.STATEMENT_LEN, string);
        return YYParser.doParse(string, iPTLimitChecker);
    }
}

