/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.dsi.core.utilities.impl.future;

import com.cloudera.hiveserver2.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.cloudera.hiveserver2.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.cloudera.hiveserver2.dsi.exceptions.ConversionFailed;
import com.cloudera.hiveserver2.dsi.exceptions.IncorrectTypeException;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class SignedIntJDBCDataSink
extends NumberJDBCDataSink<Integer> {
    public SignedIntJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException, ConversionFailed {
        if (object == null || object instanceof Integer) {
            this.doSet((Integer)object);
        } else {
            int n = NonTrivialJDBCConversions.objectToInt(object, this.getAndClearListener());
            this.handleConversionResult(object, "set");
            this.doSet(n);
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setInt(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.setInt(s);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        this.doSet(n);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        int n = NonTrivialJDBCConversions.LongConverter.toInt(l, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(n, "setLong");
        }
        this.setInt(n);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        int n = NonTrivialJDBCConversions.DoubleConverter.toInt(f, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(Float.valueOf(f), "setFloat");
        }
        this.setInt(n);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        int n = NonTrivialJDBCConversions.DoubleConverter.toInt(d, this.getAndClearListener());
        if (!this.conversionSuccessful()) {
            this.handleConversionResult(d, "setDouble");
        }
        this.setInt(n);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            int n = NonTrivialJDBCConversions.DecimalConverter.toInt(bigDecimal, this.getAndClearListener());
            this.handleConversionResult(bigDecimal, "setBigDecimal");
            this.setInt(n);
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            string = string.trim();
            try {
                this.setInt(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                int n = NonTrivialJDBCConversions.DecimalConverter.toInt(NonTrivialJDBCConversions.stringToBigDecimal(string), this.getAndClearListener());
                this.handleConversionResult(string, "setString");
                this.setInt(n);
            }
        }
    }
}

