/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.dsi.dataengine.utilities;

import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ParameterMetadata;
import com.cloudera.hiveserver2.dsi.exceptions.DefaultParamException;
import com.cloudera.hiveserver2.dsi.exceptions.ParamAlreadyPushedException;

public final class ParameterInputValue {
    private ParameterMetadata m_metadata;
    private boolean m_isPushed;
    private boolean m_isDefault;
    private DataWrapper m_data;

    public ParameterInputValue(ParameterMetadata parameterMetadata, boolean bl, boolean bl2, DataWrapper dataWrapper) {
        this.m_metadata = parameterMetadata;
        this.m_isPushed = bl;
        this.m_isDefault = bl2;
        this.m_data = dataWrapper;
    }

    public ParameterInputValue(ParameterMetadata parameterMetadata, boolean bl, DataWrapper dataWrapper) {
        this.m_metadata = parameterMetadata;
        this.m_isPushed = bl;
        this.m_isDefault = false;
        this.m_data = dataWrapper;
    }

    public ParameterInputValue(ParameterMetadata parameterMetadata, DataWrapper dataWrapper) {
        this.m_metadata = parameterMetadata;
        this.m_isPushed = false;
        this.m_isDefault = false;
        this.m_data = dataWrapper;
    }

    public DataWrapper getData() throws ParamAlreadyPushedException, DefaultParamException {
        if (this.m_isPushed) {
            throw new ParamAlreadyPushedException();
        }
        if (this.m_isDefault) {
            throw new DefaultParamException();
        }
        return this.m_data;
    }

    public ParameterMetadata getMetadata() {
        return this.m_metadata;
    }

    public boolean isDefaultValue() {
        return this.m_isDefault;
    }

    public boolean isNull() {
        return null == this.m_data || this.m_data.isNull();
    }

    public boolean isPushed() {
        return this.m_isPushed;
    }

    public void setIsDefaultValue(boolean bl) {
        this.m_isDefault = bl;
    }

    public void setPushed(boolean bl) {
        this.m_isPushed = bl;
    }
}

