/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.api;

import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TBoolColumn;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCLIService;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCancelOperationResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseImpalaOperationReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseImpalaOperationResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseOperationResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TCloseSessionResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TColumn;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TExecuteStatementResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TFetchResultsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCatalogsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetColumnsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCrossReferenceReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetCrossReferenceResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetFunctionsReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetFunctionsResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetInfoResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetOperationStatusResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetPrimaryKeysReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetPrimaryKeysResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetResultSetMetadataResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetSchemasResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTableTypesReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTableTypesResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTablesResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTypeInfoReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TGetTypeInfoResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOpenSessionResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TRowSet;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TStatus;
import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TStatusCode;
import com.cloudera.hive.jdbc42.internal.apache.thrift.TException;
import com.cloudera.hive.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.hive.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.HttpErrorEmulationSettings;
import com.cloudera.hiveserver2.hivecommon.HttpRetrySettings;
import com.cloudera.hiveserver2.hivecommon.api.TEHTTPSettings;
import com.cloudera.hiveserver2.hivecommon.exceptions.TEHttpRetryException;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;

public class HS2ClientWrapper
extends TCLIService.Client {
    protected ILogger m_logger;
    TEHTTPSettings m_teHttpSettings;
    private HiveJDBCSettings m_settings;

    public synchronized Object executeWithRetry(TCLIFunction tCLIFunction, Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
        Object object2 = null;
        hS2ClientWrapper.m_teHttpSettings.m_currentAPICall = tCLIFunction.getApiCallName();
        for (HttpRetrySettings object3 : this.m_teHttpSettings.m_httpRetrySettingsList) {
            object3.reset();
        }
        boolean bl = true;
        while (bl) {
            HttpErrorEmulationSettings httpErrorEmulationSettings = hS2ClientWrapper.m_teHttpSettings.m_httpErrorEmulationSettingsMap.get(tCLIFunction.getApiCallName());
            if (null != httpErrorEmulationSettings) {
                ++httpErrorEmulationSettings.m_apiIndex;
                hS2ClientWrapper.m_teHttpSettings.m_currentHttpErrorEmulationSettings = httpErrorEmulationSettings.shouldEmulateError() ? httpErrorEmulationSettings : null;
            } else {
                hS2ClientWrapper.m_teHttpSettings.m_currentHttpErrorEmulationSettings = null;
            }
            try {
                object2 = tCLIFunction.clientCall(object, hS2ClientWrapper);
                bl = false;
            }
            catch (TEHttpRetryException tEHttpRetryException) {
                bl = this.shouldReexecuteRequest(tEHttpRetryException);
                if (bl) continue;
                String string = "";
                if (-1 != tEHttpRetryException.retryAfterTime) {
                    for (HttpRetrySettings httpRetrySettings : this.m_teHttpSettings.m_httpRetrySettingsList) {
                        if (httpRetrySettings.m_enableRetry || !httpRetrySettings.m_codeRanges.IsNumberInIntervals(tEHttpRetryException.errorCode)) continue;
                        string = httpRetrySettings.m_httpRetryType.m_httpRetryTypeKey + " is disabled, but received a HTTP retry after response. Configure these values with " + httpRetrySettings.m_httpRetryType.m_httpRetryTypeKey + " and " + httpRetrySettings.m_httpRetryType.m_httpRetryTypeKey + "Timeout" + ". Error from server: ";
                        break;
                    }
                }
                throw new TTransportException(string + tEHttpRetryException.getMessage());
            }
        }
        return object2;
    }

    public HS2ClientWrapper(TProtocol tProtocol, ILogger iLogger) {
        super(tProtocol);
        this.m_logger = iLogger;
    }

    public HS2ClientWrapper(TProtocol tProtocol, ILogger iLogger, HiveJDBCSettings hiveJDBCSettings) {
        super(tProtocol);
        this.m_logger = iLogger;
        this.m_teHttpSettings = hiveJDBCSettings.m_thriftHTTPSettings;
        this.m_settings = hiveJDBCSettings;
    }

    public HS2ClientWrapper(TProtocol tProtocol, TProtocol tProtocol2, ILogger iLogger) {
        super(tProtocol, tProtocol2);
        this.m_logger = iLogger;
    }

    @Override
    public TCancelDelegationTokenResp CancelDelegationToken(TCancelDelegationTokenReq tCancelDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCancelDelegationTokenReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TCancelDelegationTokenResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TCancelDelegationTokenResp tCancelDelegationTokenResp = hS2ClientWrapper.callCancelDelegationToken((TCancelDelegationTokenReq)object);
                return tCancelDelegationTokenResp;
            }

            @Override
            public String getApiCallName() {
                return "CancelDelegationToken";
            }
        };
        return (TCancelDelegationTokenResp)this.executeWithRetry(tCLIFunction, tCancelDelegationTokenReq, this);
    }

    @Override
    public TCloseOperationResp CloseOperation(TCloseOperationReq tCloseOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseOperationReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TCloseOperationResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TCloseOperationResp tCloseOperationResp = hS2ClientWrapper.callCloseOperation((TCloseOperationReq)object);
                return tCloseOperationResp;
            }

            @Override
            public String getApiCallName() {
                return "CloseOperation";
            }
        };
        return (TCloseOperationResp)this.executeWithRetry(tCLIFunction, tCloseOperationReq, this);
    }

    @Override
    public TCloseImpalaOperationResp CloseImpalaOperation(TCloseImpalaOperationReq tCloseImpalaOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseImpalaOperationReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TCloseImpalaOperationResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TCloseImpalaOperationResp tCloseImpalaOperationResp = hS2ClientWrapper.callCloseImpalaOperation((TCloseImpalaOperationReq)object);
                return tCloseImpalaOperationResp;
            }

            @Override
            public String getApiCallName() {
                return "CloseImpalaOperation";
            }
        };
        return (TCloseImpalaOperationResp)this.executeWithRetry(tCLIFunction, tCloseImpalaOperationReq, this);
    }

    @Override
    public TCloseSessionResp CloseSession(TCloseSessionReq tCloseSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tCloseSessionReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TCloseSessionResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TCloseSessionResp tCloseSessionResp = hS2ClientWrapper.callCloseSession((TCloseSessionReq)object);
                return tCloseSessionResp;
            }

            @Override
            public String getApiCallName() {
                return "CloseSession";
            }
        };
        return (TCloseSessionResp)this.executeWithRetry(tCLIFunction, tCloseSessionReq, this);
    }

    @Override
    public TExecuteStatementResp ExecuteStatement(TExecuteStatementReq tExecuteStatementReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tExecuteStatementReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TExecuteStatementResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TExecuteStatementResp tExecuteStatementResp = hS2ClientWrapper.callExecuteStatement((TExecuteStatementReq)object);
                return tExecuteStatementResp;
            }

            @Override
            public String getApiCallName() {
                return "ExecuteStatement";
            }
        };
        return (TExecuteStatementResp)this.executeWithRetry(tCLIFunction, tExecuteStatementReq, this);
    }

    @Override
    public TFetchResultsResp FetchResults(TFetchResultsReq tFetchResultsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tFetchResultsReq);
        if (this.m_teHttpSettings.m_enableZeroRowsTesting && this.m_teHttpSettings.m_emulateZeroRowBlocks > this.m_teHttpSettings.m_resultSetBlocksFetched) {
            TFetchResultsResp tFetchResultsResp = new TFetchResultsResp();
            tFetchResultsResp.setHasMoreRows(true);
            TRowSet tRowSet = new TRowSet();
            TColumn tColumn = new TColumn();
            tColumn.setBoolVal(new TBoolColumn());
            tRowSet.addToColumns(tColumn);
            tFetchResultsResp.setResults(tRowSet);
            tFetchResultsResp.setStatus(new TStatus(TStatusCode.SUCCESS_STATUS));
            ++this.m_teHttpSettings.m_resultSetBlocksFetched;
            return tFetchResultsResp;
        }
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TFetchResultsResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TFetchResultsResp tFetchResultsResp = hS2ClientWrapper.callFetchResults((TFetchResultsReq)object);
                return tFetchResultsResp;
            }

            @Override
            public String getApiCallName() {
                return "FetchResults";
            }
        };
        return (TFetchResultsResp)this.executeWithRetry(tCLIFunction, tFetchResultsReq, this);
    }

    @Override
    public TGetCatalogsResp GetCatalogs(TGetCatalogsReq tGetCatalogsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetCatalogsReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetCatalogsResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetCatalogsResp tGetCatalogsResp = hS2ClientWrapper.callGetCatalogs((TGetCatalogsReq)object);
                return tGetCatalogsResp;
            }

            @Override
            public String getApiCallName() {
                return "GetCatalogs";
            }
        };
        return (TGetCatalogsResp)this.executeWithRetry(tCLIFunction, tGetCatalogsReq, this);
    }

    @Override
    public TGetColumnsResp GetColumns(TGetColumnsReq tGetColumnsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetColumnsReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetColumnsResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetColumnsResp tGetColumnsResp = hS2ClientWrapper.callGetColumns((TGetColumnsReq)object);
                return tGetColumnsResp;
            }

            @Override
            public String getApiCallName() {
                return "GetColumns";
            }
        };
        return (TGetColumnsResp)this.executeWithRetry(tCLIFunction, tGetColumnsReq, this);
    }

    @Override
    public TGetCrossReferenceResp GetCrossReference(TGetCrossReferenceReq tGetCrossReferenceReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetCrossReferenceReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public Object clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetCrossReferenceResp tGetCrossReferenceResp = hS2ClientWrapper.callGetCrossReference((TGetCrossReferenceReq)object);
                return tGetCrossReferenceResp;
            }

            @Override
            public String getApiCallName() {
                return "GetCrossReference";
            }
        };
        return (TGetCrossReferenceResp)this.executeWithRetry(tCLIFunction, tGetCrossReferenceReq, this);
    }

    @Override
    public TGetDelegationTokenResp GetDelegationToken(TGetDelegationTokenReq tGetDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetDelegationTokenReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetDelegationTokenResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetDelegationTokenResp tGetDelegationTokenResp = hS2ClientWrapper.callGetDelegationToken((TGetDelegationTokenReq)object);
                return tGetDelegationTokenResp;
            }

            @Override
            public String getApiCallName() {
                return "GetDelegationToken";
            }
        };
        return (TGetDelegationTokenResp)this.executeWithRetry(tCLIFunction, tGetDelegationTokenReq, this);
    }

    @Override
    public TGetFunctionsResp GetFunctions(TGetFunctionsReq tGetFunctionsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetFunctionsReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetFunctionsResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetFunctionsResp tGetFunctionsResp = hS2ClientWrapper.callGetFunctions((TGetFunctionsReq)object);
                return tGetFunctionsResp;
            }

            @Override
            public String getApiCallName() {
                return "GetFunctions";
            }
        };
        return (TGetFunctionsResp)this.executeWithRetry(tCLIFunction, tGetFunctionsReq, this);
    }

    @Override
    public TGetInfoResp GetInfo(TGetInfoReq tGetInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetInfoReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetInfoResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetInfoResp tGetInfoResp = hS2ClientWrapper.callGetInfo((TGetInfoReq)object);
                return tGetInfoResp;
            }

            @Override
            public String getApiCallName() {
                return "GetInfo";
            }
        };
        return (TGetInfoResp)this.executeWithRetry(tCLIFunction, tGetInfoReq, this);
    }

    @Override
    public TGetOperationStatusResp GetOperationStatus(TGetOperationStatusReq tGetOperationStatusReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetOperationStatusReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetOperationStatusResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetOperationStatusResp tGetOperationStatusResp = hS2ClientWrapper.callGetOperationStatus((TGetOperationStatusReq)object);
                return tGetOperationStatusResp;
            }

            @Override
            public String getApiCallName() {
                return "GetOperationStatus";
            }
        };
        return (TGetOperationStatusResp)this.executeWithRetry(tCLIFunction, tGetOperationStatusReq, this);
    }

    @Override
    public TGetPrimaryKeysResp GetPrimaryKeys(TGetPrimaryKeysReq tGetPrimaryKeysReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetPrimaryKeysReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public Object clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetPrimaryKeysResp tGetPrimaryKeysResp = hS2ClientWrapper.callGetPrimaryKeys((TGetPrimaryKeysReq)object);
                return tGetPrimaryKeysResp;
            }

            @Override
            public String getApiCallName() {
                return "GetPrimaryKeys";
            }
        };
        return (TGetPrimaryKeysResp)this.executeWithRetry(tCLIFunction, tGetPrimaryKeysReq, this);
    }

    @Override
    public TGetResultSetMetadataResp GetResultSetMetadata(TGetResultSetMetadataReq tGetResultSetMetadataReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetResultSetMetadataReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetResultSetMetadataResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetResultSetMetadataResp tGetResultSetMetadataResp = hS2ClientWrapper.callGetResultSetMetadata((TGetResultSetMetadataReq)object);
                return tGetResultSetMetadataResp;
            }

            @Override
            public String getApiCallName() {
                return "GetResultSetMetadata";
            }
        };
        return (TGetResultSetMetadataResp)this.executeWithRetry(tCLIFunction, tGetResultSetMetadataReq, this);
    }

    @Override
    public TGetSchemasResp GetSchemas(TGetSchemasReq tGetSchemasReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetSchemasReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetSchemasResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetSchemasResp tGetSchemasResp = hS2ClientWrapper.callGetSchemas((TGetSchemasReq)object);
                return tGetSchemasResp;
            }

            @Override
            public String getApiCallName() {
                return "GetSchemas";
            }
        };
        return (TGetSchemasResp)this.executeWithRetry(tCLIFunction, tGetSchemasReq, this);
    }

    @Override
    public TGetTableTypesResp GetTableTypes(TGetTableTypesReq tGetTableTypesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTableTypesReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetTableTypesResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetTableTypesResp tGetTableTypesResp = hS2ClientWrapper.callGetTableTypes((TGetTableTypesReq)object);
                return tGetTableTypesResp;
            }

            @Override
            public String getApiCallName() {
                return "GetTableTypes";
            }
        };
        return (TGetTableTypesResp)this.executeWithRetry(tCLIFunction, tGetTableTypesReq, this);
    }

    @Override
    public TGetTablesResp GetTables(TGetTablesReq tGetTablesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTablesReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetTablesResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetTablesResp tGetTablesResp = hS2ClientWrapper.callGetTables((TGetTablesReq)object);
                return tGetTablesResp;
            }

            @Override
            public String getApiCallName() {
                return "GetTables";
            }
        };
        return (TGetTablesResp)this.executeWithRetry(tCLIFunction, tGetTablesReq, this);
    }

    @Override
    public TGetTypeInfoResp GetTypeInfo(TGetTypeInfoReq tGetTypeInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tGetTypeInfoReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TGetTypeInfoResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TGetTypeInfoResp tGetTypeInfoResp = hS2ClientWrapper.callGetTypeInfo((TGetTypeInfoReq)object);
                return tGetTypeInfoResp;
            }

            @Override
            public String getApiCallName() {
                return "GetTypeInfo";
            }
        };
        return (TGetTypeInfoResp)this.executeWithRetry(tCLIFunction, tGetTypeInfoReq, this);
    }

    @Override
    public TOpenSessionResp OpenSession(TOpenSessionReq tOpenSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tOpenSessionReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TOpenSessionResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TOpenSessionResp tOpenSessionResp = hS2ClientWrapper.callOpenSession((TOpenSessionReq)object);
                return tOpenSessionResp;
            }

            @Override
            public String getApiCallName() {
                return "OpenSession";
            }
        };
        return (TOpenSessionResp)this.executeWithRetry(tCLIFunction, tOpenSessionReq, this);
    }

    @Override
    public TRenewDelegationTokenResp RenewDelegationToken(TRenewDelegationTokenReq tRenewDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, tRenewDelegationTokenReq);
        TCLIFunction tCLIFunction = new TCLIFunction(){

            @Override
            public TRenewDelegationTokenResp clientCall(Object object, HS2ClientWrapper hS2ClientWrapper) throws TException {
                TRenewDelegationTokenResp tRenewDelegationTokenResp = hS2ClientWrapper.callRenewDelegationToken((TRenewDelegationTokenReq)object);
                return tRenewDelegationTokenResp;
            }

            @Override
            public String getApiCallName() {
                return "RenewDelegationToken";
            }
        };
        return (TRenewDelegationTokenResp)this.executeWithRetry(tCLIFunction, tRenewDelegationTokenReq, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCancelDelegationTokenResp recv_CancelDelegationToken() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_CancelDelegationToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCancelOperationResp recv_CancelOperation() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_CancelOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCloseOperationResp recv_CloseOperation() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_CloseOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCloseImpalaOperationResp recv_CloseImpalaOperation() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_CloseImpalaOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCloseSessionResp recv_CloseSession() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_CloseSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TExecuteStatementResp recv_ExecuteStatement() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_ExecuteStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TFetchResultsResp recv_FetchResults() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_FetchResults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetCatalogsResp recv_GetCatalogs() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetCatalogs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetColumnsResp recv_GetColumns() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetColumns();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetCrossReferenceResp recv_GetCrossReference() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetCrossReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetDelegationTokenResp recv_GetDelegationToken() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetDelegationToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetFunctionsResp recv_GetFunctions() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetFunctions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetInfoResp recv_GetInfo() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetOperationStatusResp recv_GetOperationStatus() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetOperationStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetPrimaryKeysResp recv_GetPrimaryKeys() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetPrimaryKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetResultSetMetadataResp recv_GetResultSetMetadata() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetResultSetMetadata();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetSchemasResp recv_GetSchemas() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetSchemas();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetTableTypesResp recv_GetTableTypes() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetTableTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetTablesResp recv_GetTables() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetTables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TGetTypeInfoResp recv_GetTypeInfo() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_GetTypeInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TOpenSessionResp recv_OpenSession() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_OpenSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TRenewDelegationTokenResp recv_RenewDelegationToken() throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            return super.recv_RenewDelegationToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_CancelDelegationToken(TCancelDelegationTokenReq tCancelDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_CancelDelegationToken(tCancelDelegationTokenReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_CancelOperation(TCancelOperationReq tCancelOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_CancelOperation(tCancelOperationReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_CloseOperation(TCloseOperationReq tCloseOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_CloseOperation(tCloseOperationReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_CloseImpalaOperation(TCloseImpalaOperationReq tCloseImpalaOperationReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_CloseImpalaOperation(tCloseImpalaOperationReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_CloseSession(TCloseSessionReq tCloseSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_CloseSession(tCloseSessionReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_ExecuteStatement(TExecuteStatementReq tExecuteStatementReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_ExecuteStatement(tExecuteStatementReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_FetchResults(TFetchResultsReq tFetchResultsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_FetchResults(tFetchResultsReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetCatalogs(TGetCatalogsReq tGetCatalogsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetCatalogs(tGetCatalogsReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetColumns(TGetColumnsReq tGetColumnsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetColumns(tGetColumnsReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetCrossReference(TGetCrossReferenceReq tGetCrossReferenceReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetCrossReference(tGetCrossReferenceReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetDelegationToken(TGetDelegationTokenReq tGetDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetDelegationToken(tGetDelegationTokenReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetFunctions(TGetFunctionsReq tGetFunctionsReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetFunctions(tGetFunctionsReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetInfo(TGetInfoReq tGetInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetInfo(tGetInfoReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetOperationStatus(TGetOperationStatusReq tGetOperationStatusReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetOperationStatus(tGetOperationStatusReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetPrimaryKeys(TGetPrimaryKeysReq tGetPrimaryKeysReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetPrimaryKeys(tGetPrimaryKeysReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetResultSetMetadata(TGetResultSetMetadataReq tGetResultSetMetadataReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetResultSetMetadata(tGetResultSetMetadataReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetSchemas(TGetSchemasReq tGetSchemasReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetSchemas(tGetSchemasReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetTableTypes(TGetTableTypesReq tGetTableTypesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetTableTypes(tGetTableTypesReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetTables(TGetTablesReq tGetTablesReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetTables(tGetTablesReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_GetTypeInfo(TGetTypeInfoReq tGetTypeInfoReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_GetTypeInfo(tGetTypeInfoReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_OpenSession(TOpenSessionReq tOpenSessionReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_OpenSession(tOpenSessionReq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send_RenewDelegationToken(TRenewDelegationTokenReq tRenewDelegationTokenReq) throws TException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HS2ClientWrapper hS2ClientWrapper = this;
        synchronized (hS2ClientWrapper) {
            super.send_RenewDelegationToken(tRenewDelegationTokenReq);
        }
    }

    private TCancelDelegationTokenResp callCancelDelegationToken(TCancelDelegationTokenReq tCancelDelegationTokenReq) throws TException {
        return super.CancelDelegationToken(tCancelDelegationTokenReq);
    }

    private TCloseOperationResp callCloseOperation(TCloseOperationReq tCloseOperationReq) throws TException {
        return super.CloseOperation(tCloseOperationReq);
    }

    private TCloseImpalaOperationResp callCloseImpalaOperation(TCloseImpalaOperationReq tCloseImpalaOperationReq) throws TException {
        return super.CloseImpalaOperation(tCloseImpalaOperationReq);
    }

    private TCloseSessionResp callCloseSession(TCloseSessionReq tCloseSessionReq) throws TException {
        return super.CloseSession(tCloseSessionReq);
    }

    private TExecuteStatementResp callExecuteStatement(TExecuteStatementReq tExecuteStatementReq) throws TException {
        return super.ExecuteStatement(tExecuteStatementReq);
    }

    private TFetchResultsResp callFetchResults(TFetchResultsReq tFetchResultsReq) throws TException {
        return super.FetchResults(tFetchResultsReq);
    }

    private TGetCatalogsResp callGetCatalogs(TGetCatalogsReq tGetCatalogsReq) throws TException {
        return super.GetCatalogs(tGetCatalogsReq);
    }

    private TGetColumnsResp callGetColumns(TGetColumnsReq tGetColumnsReq) throws TException {
        return super.GetColumns(tGetColumnsReq);
    }

    private TGetCrossReferenceResp callGetCrossReference(TGetCrossReferenceReq tGetCrossReferenceReq) throws TException {
        return super.GetCrossReference(tGetCrossReferenceReq);
    }

    private TGetDelegationTokenResp callGetDelegationToken(TGetDelegationTokenReq tGetDelegationTokenReq) throws TException {
        return super.GetDelegationToken(tGetDelegationTokenReq);
    }

    private TGetFunctionsResp callGetFunctions(TGetFunctionsReq tGetFunctionsReq) throws TException {
        return super.GetFunctions(tGetFunctionsReq);
    }

    private TGetInfoResp callGetInfo(TGetInfoReq tGetInfoReq) throws TException {
        return super.GetInfo(tGetInfoReq);
    }

    private TGetOperationStatusResp callGetOperationStatus(TGetOperationStatusReq tGetOperationStatusReq) throws TException {
        return super.GetOperationStatus(tGetOperationStatusReq);
    }

    private TGetPrimaryKeysResp callGetPrimaryKeys(TGetPrimaryKeysReq tGetPrimaryKeysReq) throws TException {
        return super.GetPrimaryKeys(tGetPrimaryKeysReq);
    }

    private TGetResultSetMetadataResp callGetResultSetMetadata(TGetResultSetMetadataReq tGetResultSetMetadataReq) throws TException {
        return super.GetResultSetMetadata(tGetResultSetMetadataReq);
    }

    private TGetSchemasResp callGetSchemas(TGetSchemasReq tGetSchemasReq) throws TException {
        return super.GetSchemas(tGetSchemasReq);
    }

    private TGetTableTypesResp callGetTableTypes(TGetTableTypesReq tGetTableTypesReq) throws TException {
        return super.GetTableTypes(tGetTableTypesReq);
    }

    private TGetTablesResp callGetTables(TGetTablesReq tGetTablesReq) throws TException {
        return super.GetTables(tGetTablesReq);
    }

    private TGetTypeInfoResp callGetTypeInfo(TGetTypeInfoReq tGetTypeInfoReq) throws TException {
        return super.GetTypeInfo(tGetTypeInfoReq);
    }

    private TOpenSessionResp callOpenSession(TOpenSessionReq tOpenSessionReq) throws TException {
        return super.OpenSession(tOpenSessionReq);
    }

    private TRenewDelegationTokenResp callRenewDelegationToken(TRenewDelegationTokenReq tRenewDelegationTokenReq) throws TException {
        return super.RenewDelegationToken(tRenewDelegationTokenReq);
    }

    protected boolean shouldReexecuteRequest(TEHttpRetryException tEHttpRetryException) throws TException {
        if (null == tEHttpRetryException || null == this.m_teHttpSettings) {
            return false;
        }
        for (HttpRetrySettings httpRetrySettings : this.m_teHttpSettings.m_httpRetrySettingsList) {
            if (!httpRetrySettings.shouldRetry(this.m_teHttpSettings.m_currentAPICall, this.m_teHttpSettings.m_currentQuery, tEHttpRetryException)) continue;
            return true;
        }
        return false;
    }

    static interface TCLIFunction {
        public Object clientCall(Object var1, HS2ClientWrapper var2) throws TException;

        public String getApiCallName();
    }
}

