/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.api;

import com.cloudera.hiveserver2.hivecommon.api.HiveJDBCBrowserServerResponse;
import com.cloudera.hiveserver2.hivecommon.api.SSOSettings;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;

public abstract class WebConnection
implements Runnable {
    public static final int BUFFER_SIZE = 16384;
    public static final String UTF8_STR = "UTF-8";
    public static final String OAUTH_RESPONSE_HEADER_PREFIX = "GET /?";
    public static final String OAUTH_RESPONSE_HEADER_SUFFIX = " HTTP/1.1";
    protected ILogger m_logger;
    private SetValueFunction m_setValueFunction;
    private final Socket m_socket;
    protected SSOSettings m_settings;

    public WebConnection(Socket socket, SetValueFunction setValueFunction, ILogger iLogger, SSOSettings sSOSettings) {
        this.m_setValueFunction = setValueFunction;
        this.m_socket = socket;
        this.m_logger = iLogger;
        this.m_settings = sSOSettings;
    }

    @Override
    public void run() {
        try {
            this.readServerResponse(this.m_socket);
        }
        catch (IOException iOException) {
            LogUtilities.logDebug("Encountered exception on remote port " + this.m_socket.getPort() + " when listening for browser response: " + iOException.getMessage(), this.m_logger);
        }
        finally {
            if (null != this.m_socket) {
                try {
                    this.m_socket.close();
                }
                catch (IOException iOException) {
                    LogUtilities.logDebug("Error closing socket: " + iOException.getMessage(), this.m_logger);
                }
            }
        }
    }

    protected abstract HiveJDBCBrowserServerResponse parseServerResponse(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readServerResponse(Socket socket) throws IOException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HiveJDBCBrowserServerResponse hiveJDBCBrowserServerResponse = null;
        try {
            object = new BufferedReader(new InputStreamReader(socket.getInputStream(), UTF8_STR));
            LogUtilities.logDebug("Waiting for a server response on port " + socket.getLocalPort() + " with a timeout of " + socket.getSoTimeout() + " ms on socket " + socket.toString(), this.m_logger);
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[16384];
            while (((Reader)object).read(cArray) != -1) {
                stringBuilder.append(cArray);
                String string = stringBuilder.toString().replaceAll("\u0000", "");
                hiveJDBCBrowserServerResponse = this.parseServerResponse(string);
                if (null == hiveJDBCBrowserServerResponse) continue;
                LogUtilities.logTrace("Parsed response", this.m_logger);
                break;
            }
            LogUtilities.logTrace("Done reading from connection", this.m_logger);
        }
        catch (IOException iOException) {
            try {
                LogUtilities.logTrace("Unexpected exception while processing server response " + iOException.getMessage(), this.m_logger);
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    this.sendBrowserMsg(socket, hiveJDBCBrowserServerResponse);
                }
                catch (IOException iOException2) {
                    LogUtilities.logTrace("Unexpected exception while responding to browser " + iOException2.getMessage(), this.m_logger);
                }
                WebConnection iOException2 = this;
                synchronized (iOException2) {
                    if (hiveJDBCBrowserServerResponse == null) throw throwable;
                    this.m_setValueFunction.setValue(hiveJDBCBrowserServerResponse);
                    throw throwable;
                }
            }
        }
        try {
            this.sendBrowserMsg(socket, hiveJDBCBrowserServerResponse);
        }
        catch (IOException iOException) {
            LogUtilities.logTrace("Unexpected exception while responding to browser " + iOException.getMessage(), this.m_logger);
        }
        object = this;
        synchronized (object) {
            if (hiveJDBCBrowserServerResponse != null) {
                this.m_setValueFunction.setValue(hiveJDBCBrowserServerResponse);
            }
        }
        if (null != hiveJDBCBrowserServerResponse) return true;
        return false;
    }

    protected abstract void sendBrowserMsg(Socket var1, HiveJDBCBrowserServerResponse var2) throws IOException;

    public static interface SetValueFunction {
        public void setValue(HiveJDBCBrowserServerResponse var1);
    }
}

