/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.utils;

import com.cloudera.hive.jdbc42.internal.apache.hive.service.rpc.thrift.TOperationHandle;
import com.cloudera.hiveserver2.hivecommon.api.HS2Client;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCExceptionUtils;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class HeartBeatThread
implements Runnable {
    private HS2Client m_client;
    private ArrayList<TOperationHandle> m_handleList = new ArrayList();
    private int m_heartBeatInterval;
    private ILogger m_logger;
    private AtomicBoolean m_stopped;
    private Thread m_thread;

    public HeartBeatThread(HS2Client hS2Client, int n, ILogger iLogger) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_client = hS2Client;
        this.m_heartBeatInterval = n;
        this.m_stopped = new AtomicBoolean(false);
        this.m_thread = new Thread(this);
        this.m_thread.setDaemon(true);
        this.m_thread.start();
    }

    public synchronized void addOperationHandle(TOperationHandle tOperationHandle) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        LogUtilities.logInfo("Adding " + tOperationHandle.getOperationId() + " to the heart beat operation handle list.", this.m_logger);
        this.m_handleList.add(tOperationHandle);
    }

    public synchronized int countOperationHandle() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        LogUtilities.logInfo("Number of operation handles in the heart beat are " + this.m_handleList.size(), this.m_logger);
        return this.m_handleList.size();
    }

    public synchronized void removeOperationHandle(TOperationHandle tOperationHandle) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        LogUtilities.logInfo("Removing " + tOperationHandle.getOperationId() + " from the heart beat operation handle list.", this.m_logger);
        if (!this.m_handleList.remove(tOperationHandle)) {
            LogUtilities.logWarning(tOperationHandle.getOperationId() + " is not in the heartbeat opeartion handle list", this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        while (!this.isStopped()) {
            try {
                Thread.sleep(this.m_heartBeatInterval);
                HeartBeatThread heartBeatThread = this;
                synchronized (heartBeatThread) {
                    for (int i = 0; i < this.m_handleList.size(); ++i) {
                        TOperationHandle tOperationHandle = this.m_handleList.get(i);
                        LogUtilities.logDebug("Sending hear beat for " + tOperationHandle.getOperationId(), this.m_logger);
                        if (this.m_client.sendHeartBeat(tOperationHandle)) continue;
                        this.m_handleList.remove(i);
                        --i;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                LogUtilities.logDebug("Heartbeat thread was interrupted. ", this.m_logger);
                break;
            }
        }
    }

    public void stop() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_stopped.set(true);
        this.m_thread.interrupt();
        try {
            this.m_thread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            HiveJDBCExceptionUtils.logException(interruptedException, this.m_logger);
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DICONNECT_ERR.name(), interruptedException.getMessage());
            errorException.initCause(interruptedException);
            throw errorException;
        }
    }

    public boolean isStopped() {
        return this.m_stopped.get();
    }
}

