/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.hivecommon.utils;

import com.cloudera.hiveserver2.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.hiveserver2.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.hiveserver2.dsi.core.utilities.Variant;
import com.cloudera.hiveserver2.hivecommon.DownloadableResultSettings;
import com.cloudera.hiveserver2.hivecommon.HiveJDBCSettings;
import com.cloudera.hiveserver2.hivecommon.HttpErrorEmulationSettings;
import com.cloudera.hiveserver2.hivecommon.HttpRetrySettings;
import com.cloudera.hiveserver2.hivecommon.HttpRetryType;
import com.cloudera.hiveserver2.hivecommon.WholeNumberIntervalList;
import com.cloudera.hiveserver2.hivecommon.api.SSOSettings;
import com.cloudera.hiveserver2.hivecommon.api.ZookeeperSettings;
import com.cloudera.hiveserver2.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hiveserver2.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hiveserver2.jdbc.common.SSLSettings;
import com.cloudera.hiveserver2.jdbc.core.DSDriver;
import com.cloudera.hiveserver2.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.IWarningListener;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.Warning;
import com.cloudera.hiveserver2.support.WarningCode;
import com.cloudera.hiveserver2.support.conv.CharConverter;
import com.cloudera.hiveserver2.support.conv.ConversionResult;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HiveCommonConnectionUtils {
    private static final String HTTP_ERROR_EMULATION_ITEM_DELIMITER = ":";
    private static final int HTTP_ERROR_EMULATION_API_NAME_INDEX = 0;
    private static final int HTTP_ERROR_EMULATION_API_COUNT_INTERVAL_INDEX = 1;
    private static final int HTTP_ERROR_EMULATION_ERROR_CODE_INDEX = 2;
    private static final int HTTP_ERROR_EMULATION_MESSAGE = 3;
    private static final int HTTP_ERROR_EMULATION_MIN_ITEM = 3;
    private static final int HTTP_ERROR_EMULATION_MAX_ITEM = 4;
    private static int DEFAULT_MAX_HTTP_RETRY_TIME = 3;
    private static int DEFAULT_MIN_HTTP_RETRY_TIME_INTERVAL = 1;
    private static int DEFAULT_HTTP_RETRY_TIMEOUT = -1;
    private static boolean DEFAULT_HTTP_RETRY_OVERRIDE_RETRY_AFTER_TIME = true;
    private static boolean DEFAULT_HTTP_INCREASE_RETRY_INTERVAL_AFTER_EACH_RETRY = true;
    static final int DEFAULT_DOWNLOAD_RESULT_TIMEOUT = 300;
    static final int DEFAULT_DOWNLOAD_RESULT_MAX_BYTES_PER_FILE = 20000000;
    static final int DEFAULT_DOWNLOAD_RETRY_WAIT_TIME = 0;
    static final int DEFAULT_DOWNLOAD_RESULT_MAX_RETRY_TIME = 10;
    static final int DEFAULT_MAX_DOWNLOAD_THREADS = 80;
    static final int MIN_DOWNLOAD_RESULT_MAX_BYTES_PER_FILE = 20000000;
    static final int S_TO_MS_MULTIPLIER = 1000;

    public static void readDownloadableResultSettings(ConnSettingRequestMap connSettingRequestMap, DownloadableResultSettings downloadableResultSettings, Map<String, Boolean> map, SSLSettings sSLSettings, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        map.put("EnableQueryResultDownload", true);
        downloadableResultSettings.m_isEnableQueryResultDownload = HiveCommonConnectionUtils.ParseBoolean(connSettingRequestMap, "EnableQueryResultDownload", true);
        map.put("SslRequiredForResultDownload", true);
        map.put("ResultFileMaxBytesPerFile", true);
        map.put("MaxConsecutiveResultFileDownloadRetries", true);
        map.put("ResultFileDownloadTimeout", true);
        map.put("MaxResultFileDownloadThreads", true);
        map.put("ResultFileDownloadRetryWaitTime", true);
        map.put("ConsiderAllResultFileDownloadErrorsRetriable", true);
        map.put("ResultFileRetriableHttpCode", true);
        if (downloadableResultSettings.m_isEnableQueryResultDownload) {
            downloadableResultSettings.m_isSslRequiredForQueryResultDownload = HiveCommonConnectionUtils.ParseBoolean(connSettingRequestMap, "SslRequiredForResultDownload", true);
            Variant variant = connSettingRequestMap.getProperty("ResultFileMaxBytesPerFile");
            if (null != variant) {
                downloadableResultSettings.m_maxBytesPerFile = HiveCommonConnectionUtils.readOptionalPositiveIntegerSetting(connSettingRequestMap, "ResultFileMaxBytesPerFile", 20000000, iLogger, iWarningListener);
                if (downloadableResultSettings.m_maxBytesPerFile < 20000000) {
                    LogUtilities.logWarning("ResultFileMaxBytesPerFile was set to " + downloadableResultSettings.m_maxBytesPerFile + ". It is less than the minimal requirement: " + 20000000 + ". The driver will use " + 20000000 + " instead.", iLogger);
                    downloadableResultSettings.m_maxBytesPerFile = 20000000;
                }
            } else {
                downloadableResultSettings.m_maxBytesPerFile = DownloadableResultSettings.MAX_BYTES_PER_FILE_IS_NOT_SET;
            }
            downloadableResultSettings.m_maxConsecutiveResultFileDownloadRetries = HiveCommonConnectionUtils.readOptionalPositiveIntegerSetting(connSettingRequestMap, "MaxConsecutiveResultFileDownloadRetries", 10, iLogger, iWarningListener);
            downloadableResultSettings.m_maxDownloadThreads = HiveCommonConnectionUtils.readOptionalPositiveIntegerSetting(connSettingRequestMap, "MaxResultFileDownloadThreads", 80, iLogger, iWarningListener);
            downloadableResultSettings.m_downloadTimeout = HiveCommonConnectionUtils.readOptionalPositiveIntegerSetting(connSettingRequestMap, "ResultFileDownloadTimeout", 300, iLogger, iWarningListener);
            downloadableResultSettings.m_downloadRetryWaitTime = HiveCommonConnectionUtils.readOptionalPositiveIntegerSetting(connSettingRequestMap, "ResultFileDownloadRetryWaitTime", 0, iLogger, iWarningListener);
            downloadableResultSettings.m_isConsiderAllResultFileDownloadErrorsRetriable = HiveCommonConnectionUtils.ParseBoolean(connSettingRequestMap, "ConsiderAllResultFileDownloadErrorsRetriable", true);
            downloadableResultSettings.m_retriableHttpCodeForDownloadableResult = new WholeNumberIntervalList();
            downloadableResultSettings.m_retriableHttpCodeForDownloadableResult.AddInterval(100, 199);
            downloadableResultSettings.m_retriableHttpCodeForDownloadableResult.AddInterval(201, 999);
            variant = connSettingRequestMap.getProperty("ResultFileRetriableHttpCode");
            if (variant != null) {
                try {
                    String string = variant.getString();
                    if (!downloadableResultSettings.m_retriableHttpCodeForDownloadableResult.InitializeIntervalList(string)) {
                        ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ResultFileRetriableHttpCode", variant.getString(), "<unsigned integer interval>(, <unsigned integer interval>)\r\n<unsigned integer interval> = <unsigned integer>-(<unsigned integer>)? \r\ne.g. 400, 404-405, 408-"});
                        throw errorException;
                    }
                }
                catch (Exception exception) {
                    ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ResultFileRetriableHttpCode", variant.getString(), "<unsigned integer interval>(, <unsigned integer interval>)\r\n<unsigned integer interval> = <unsigned integer>-(<unsigned integer>)? \r\ne.g. 400, 404-405, 408-"});
                    errorException.initCause(exception);
                    throw errorException;
                }
            }
        }
    }

    public static void readHttpRetrySettings(ConnSettingRequestMap connSettingRequestMap, ArrayList<HttpRetryType> arrayList, ArrayList<HttpRetrySettings> arrayList2, IWarningListener iWarningListener) throws ErrorException {
        if (null == arrayList || null == arrayList2) {
            return;
        }
        arrayList2.clear();
        for (HttpRetryType httpRetryType : arrayList) {
            HttpRetrySettings httpRetrySettings = new HttpRetrySettings(httpRetryType);
            HiveCommonConnectionUtils.readHttpRetrySettings(connSettingRequestMap, httpRetrySettings, iWarningListener, httpRetryType.m_httpRetryTypeKey);
            arrayList2.add(httpRetrySettings);
        }
    }

    public static void readHttpErrorEmulationSettings(ConnSettingRequestMap connSettingRequestMap, Map<String, HttpErrorEmulationSettings> map, IWarningListener iWarningListener) throws ErrorException {
        if (null == connSettingRequestMap || null == map) {
            return;
        }
        Variant variant = connSettingRequestMap.getProperty("EnableHttpErrorTesting");
        if (variant != null) {
            int n;
            try {
                n = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"EnableHttpErrorTesting", variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (1 == n && (variant = connSettingRequestMap.getProperty("HttpEmulatedError")) != null) {
                try {
                    String string = variant.getString();
                    if (!HiveCommonConnectionUtils.interpretHttpEmulatedError(string, map)) {
                        ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"HttpEmulatedError", variant.getString(), "[<apiCallName>:<apiCallIndexRange>:<httpErrorCode>(:<httpHeader>)?], e.g: [GetOperationStatus:1,3:503], [FetchResults:2-5:429: \"error messages\"]"});
                        throw errorException;
                    }
                }
                catch (Exception exception) {
                    ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"HttpEmulatedError", variant.getString(), "[<apiCallName>:<apiCallIndexRange>:<httpErrorCode>(:<httpHeader>)?], e.g: [GetOperationStatus:1,3:503], [FetchResults:2-5:429: \"error messages\"]"});
                    errorException.initCause(exception);
                    throw errorException;
                }
            }
        }
    }

    public static void readPortRetrySettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, int n, ILogger iLogger) throws ErrorException {
        hiveJDBCSettings.m_oAuthSettings.m_OAuth2RedirectUrlPort = new ArrayList<Integer>();
        Variant variant = connSettingRequestMap.getProperty("OAuth2RedirectUrlPort");
        if (null != variant) {
            try {
                String string = variant.getString();
                String[] stringArray = string.split(",");
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (String string2 : stringArray) {
                    int n2 = Integer.parseInt(string2);
                    if (n2 < 0) {
                        throw new Exception();
                    }
                    arrayList.add(n2);
                }
                hiveJDBCSettings.m_oAuthSettings.m_OAuth2RedirectUrlPort = arrayList;
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"OAuth2RedirectUrlPort", variant.getString(), "All postitive integers"});
                LogUtilities.logWarning(errorException.getMessage(), iLogger);
            }
        }
        if (hiveJDBCSettings.m_oAuthSettings.m_OAuth2RedirectUrlPort.isEmpty()) {
            hiveJDBCSettings.m_oAuthSettings.m_OAuth2RedirectUrlPort.add(n);
        }
    }

    public static void readEnableOAuthIPRangeSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, ILogger iLogger) throws ErrorException {
        hiveJDBCSettings.m_oAuthSettings.m_OAuth2EnableAuthURLIPRange = new ArrayList<String>();
        Variant variant = connSettingRequestMap.getProperty("OAuthEnabledIPAddressRanges");
        if (null != variant) {
            try {
                String string = variant.getString();
                String[] stringArray = string.split(",");
                hiveJDBCSettings.m_oAuthSettings.m_OAuth2EnableAuthURLIPRange = Arrays.asList(stringArray);
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"OAuthEnabledIPAddressRanges", variant.getString()});
                LogUtilities.logWarning(errorException.getMessage(), iLogger);
            }
        }
    }

    private static void readHttpRetrySettings(ConnSettingRequestMap connSettingRequestMap, HttpRetrySettings httpRetrySettings, IWarningListener iWarningListener, String string) throws ErrorException {
        int n;
        if (null == connSettingRequestMap || null == httpRetrySettings) {
            return;
        }
        Variant variant = connSettingRequestMap.getProperty(string);
        if (variant != null) {
            try {
                n = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string, variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (0 == n) {
                httpRetrySettings.m_enableRetry = false;
                return;
            }
            if (1 == n) {
                httpRetrySettings.m_enableRetry = true;
            }
        }
        if (httpRetrySettings.m_httpRetryType.isPropertyEnabled("Timeout") && (variant = connSettingRequestMap.getProperty(string + "Timeout")) != null) {
            try {
                n = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "Timeout", variant.getString(), "should be non negative integer."});
                errorException.initCause(exception);
                throw errorException;
            }
            if (n >= 0) {
                httpRetrySettings.m_timeout = n;
            } else if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{String.valueOf(string + "Timeout"), variant.getString(), "should be non negative integer."}));
            }
        }
        if (httpRetrySettings.m_httpRetryType.isPropertyEnabled("MaxRetryTime") && (variant = connSettingRequestMap.getProperty(string + "MaxRetryTime")) != null) {
            try {
                n = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "MaxRetryTime", variant.getString(), "should be non negative integers"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (n >= 0) {
                httpRetrySettings.m_maxRetryTime = n;
            } else if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{String.valueOf(string + "MaxRetryTime"), variant.getString(), "should be non negative integers"}));
            }
        }
        if (httpRetrySettings.m_httpRetryType.isPropertyEnabled("MinRetryInterval") && (variant = connSettingRequestMap.getProperty(string + "MinRetryInterval")) != null) {
            try {
                n = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "MinRetryInterval", variant.getString(), "should be non negative integers"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (n >= 0) {
                httpRetrySettings.m_minRetryInterval = n;
            } else if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 105, CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{String.valueOf(string + "MinRetryInterval"), variant.getString(), "should be non negative integers"}));
            }
        }
        if (httpRetrySettings.m_httpRetryType.isPropertyEnabled("IncreaseRetryIntervalAfterEachRetry") && (variant = connSettingRequestMap.getProperty(string + "IncreaseRetryIntervalAfterEachRetry")) != null) {
            try {
                n = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "IncreaseRetryIntervalAfterEachRetry", variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (0 == n) {
                httpRetrySettings.m_increaseRetryIntervalAfterEachRetry = false;
            } else if (1 == n) {
                httpRetrySettings.m_increaseRetryIntervalAfterEachRetry = true;
            }
        }
        if (httpRetrySettings.m_httpRetryType.isPropertyEnabled("OverrideRetryAfterTime") && (variant = connSettingRequestMap.getProperty(string + "OverrideRetryAfterTime")) != null) {
            try {
                n = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "OverrideRetryAfterTime", variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (0 == n) {
                httpRetrySettings.m_overrideRetryAfterTime = false;
            } else if (1 == n) {
                httpRetrySettings.m_overrideRetryAfterTime = true;
            }
        }
        if (httpRetrySettings.m_httpRetryType.isPropertyEnabled("CodeRanges") && (variant = connSettingRequestMap.getProperty(string + "CodeRanges")) != null) {
            try {
                String string2 = variant.getString();
                if (null == httpRetrySettings.m_codeRanges) {
                    httpRetrySettings.m_codeRanges = new WholeNumberIntervalList();
                }
                if (!httpRetrySettings.m_codeRanges.InitializeIntervalList(string2)) {
                    ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "CodeRanges", variant.getString(), "0 , 1"});
                    throw errorException;
                }
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string + "CodeRanges", variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
    }

    private static boolean interpretHttpEmulatedError(String string, Map<String, HttpErrorEmulationSettings> map) {
        String[] stringArray;
        boolean bl = true;
        if (!(string = string.trim()).startsWith("[") || !string.endsWith("]")) {
            return false;
        }
        if (string.length() <= "[]".length()) {
            return false;
        }
        string = string.substring(1, string.length() - 1);
        for (String string2 : stringArray = string.split("\\] *, *\\[")) {
            String[] stringArray2 = (string2 = string2.trim()).split(HTTP_ERROR_EMULATION_ITEM_DELIMITER);
            if (stringArray2.length < 3 || stringArray2.length > 4) {
                return false;
            }
            boolean bl2 = false;
            ConversionResult conversionResult = new ConversionResult();
            long l = CharConverter.toInteger(stringArray2[2], conversionResult, bl2);
            int n = -1;
            switch (conversionResult.getState()) {
                case SUCCESS: {
                    if (!bl2) {
                        n = (int)l;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                return false;
            }
            HttpErrorEmulationSettings httpErrorEmulationSettings = null;
            if (map.containsKey(stringArray2[0])) {
                httpErrorEmulationSettings = map.get(stringArray2[0]);
            } else {
                httpErrorEmulationSettings = new HttpErrorEmulationSettings();
                map.put(stringArray2[0], httpErrorEmulationSettings);
            }
            if (stringArray2.length == 4) {
                httpErrorEmulationSettings.addHttpErrors(stringArray2[1], n, stringArray2[3]);
                continue;
            }
            httpErrorEmulationSettings.addHttpErrors(stringArray2[1], n);
        }
        return bl;
    }

    public static void readZookeeperSettings(ConnSettingRequestMap connSettingRequestMap, ZookeeperSettings zookeeperSettings, IWarningListener iWarningListener, ILogger iLogger) throws ErrorException {
        Object object;
        int n;
        Object object2;
        int n2;
        zookeeperSettings.m_enableRoundRobin = true;
        Variant variant = connSettingRequestMap.getProperty("EnableZkRoundRobinStrategy");
        if (null != variant) {
            try {
                n2 = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"EnableZkRoundRobinStrategy", variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (1 == n2) {
                zookeeperSettings.m_enableRoundRobin = true;
            }
        }
        zookeeperSettings.m_zkTestingEnabled = false;
        variant = connSettingRequestMap.getProperty("EnableZookeeperTesting");
        if (null != variant) {
            try {
                n2 = variant.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"EnableZookeeperTesting", variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
            if (1 == n2) {
                zookeeperSettings.m_zkTestingEnabled = true;
                object2 = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.TESTING_SETTING_ENABLED.name(), "Zookeeper Emulation");
                ((ErrorException)object2).loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
                LogUtilities.logWarning(((ErrorException)object2).getMessage(), iLogger);
            }
        }
        zookeeperSettings.m_zkTestingHostsList = new ArrayList<List<String>>();
        variant = connSettingRequestMap.getProperty("ZKTestHosts");
        if (null != variant) {
            try {
                String string = variant.getString();
                object2 = string.split("\\|");
                for (n = 0; n < ((String[])object2).length; ++n) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    object = object2[n].split(",");
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        arrayList.add(object[i].trim());
                    }
                    zookeeperSettings.m_zkTestingHostsList.add(arrayList);
                }
            }
            catch (Exception exception) {
                object2 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ZKTestHosts", variant.getString(), "<HOST:PORT>(,<HOST:PORT>)?(|(<HOST:PORT>(,<HOST:PORT>)?))?"});
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
        }
        zookeeperSettings.m_zkTestingCallIdxToHostIdx = new HashMap();
        variant = connSettingRequestMap.getProperty("ZKTestIndices");
        if (null != variant) {
            try {
                String string = variant.getString();
                object2 = string.split(",");
                for (n = 0; n < ((String[])object2).length; ++n) {
                    try {
                        int n3 = Integer.parseInt((String)object2[n]);
                        zookeeperSettings.m_zkTestingCallIdxToHostIdx.put(n, n3);
                        continue;
                    }
                    catch (Exception exception) {
                        object = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ZKTestIndices", object2[n], "Integers"});
                        ((Throwable)object).initCause(exception);
                        throw object;
                    }
                }
            }
            catch (Exception exception) {
                object2 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ZKTestIndices", variant.getString(), "<INTEGER>(,<INTEGER>)?"});
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
        }
        if (null != (variant = connSettingRequestMap.getProperty("ZKTestSetCallIndex"))) {
            try {
                zookeeperSettings.m_zkTestingCallIdx = variant.getInt();
            }
            catch (Exception exception) {
                object2 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"ZKTestSetCallIndex", variant.getString(), "Integers"});
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
        }
        if (null != (variant = connSettingRequestMap.getProperty("MaxNumServerLists"))) {
            try {
                zookeeperSettings.m_maxNumServers = variant.getInt();
                if (0 == zookeeperSettings.m_maxNumServers) {
                    zookeeperSettings.m_maxNumServers = 65536;
                }
            }
            catch (Exception exception) {
                object2 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"MaxNumServerLists", variant.getString(), "Integers"});
                ((Throwable)object2).initCause(exception);
                throw object2;
            }
        }
    }

    public static void readSSOSAMLSettings(ConnSettingRequestMap connSettingRequestMap, HiveJDBCSettings hiveJDBCSettings, Map<String, Boolean> map, ILogger iLogger, int n) throws ErrorException {
        ErrorException errorException;
        Object object;
        map.put("Auth_Flow", true);
        Variant variant = connSettingRequestMap.getProperty("Auth_Flow");
        if (null != variant) {
            object = variant.getString();
            if (((String)object).equalsIgnoreCase(SSOSettings.SSO_AUTH_FLOW.BROWSER.name())) {
                hiveJDBCSettings.m_ssoSettings.m_authFlow = SSOSettings.SSO_AUTH_FLOW.BROWSER;
            } else if (((String)object).equalsIgnoreCase(SSOSettings.SSO_AUTH_FLOW.TOKEN.name())) {
                hiveJDBCSettings.m_ssoSettings.m_authFlow = SSOSettings.SSO_AUTH_FLOW.TOKEN;
            } else {
                ErrorException errorException2 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"Auth_Flow", variant.getString(), "Browser or Token"});
                throw errorException2;
            }
        }
        map.put("SSOWebServerPort", true);
        object = connSettingRequestMap.getProperty("SSOWebServerPort");
        if (null != object) {
            int n2;
            try {
                n2 = ((Variant)object).getInt();
            }
            catch (Exception exception) {
                ErrorException errorException3 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"SSOWebServerPort", ((Variant)object).getString(), "Integer between 0 to 65535"});
                errorException3.initCause(exception);
                throw errorException3;
            }
            if (0 > n2 || 65535 < n2) {
                ErrorException errorException4 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"SSOWebServerPort", ((Variant)object).getString(), "Integers between 0 to 65535"});
                throw errorException4;
            }
            hiveJDBCSettings.m_ssoSettings.m_ssoLocalPort = n2;
        }
        map.put("SSOWebServerTimeout", true);
        Variant variant2 = connSettingRequestMap.getProperty("SSOWebServerTimeout");
        if (null != variant2) {
            try {
                hiveJDBCSettings.m_ssoSettings.m_ssoBrowserTimeout = variant2.getInt() * 1000;
            }
            catch (Exception exception) {
                ErrorException errorException5 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"SSOWebServerTimeout", variant2.getString(), "Integers"});
                errorException5.initCause(exception);
                throw errorException5;
            }
        }
        map.put("SSOWebServerTimeoutTakesPrecedence", true);
        hiveJDBCSettings.m_ssoSettings.m_ssoBrowserTimeoutPrecedence = HiveCommonConnectionUtils.ParseBoolean(connSettingRequestMap, "SSOWebServerTimeoutTakesPrecedence", false);
        if (0 != n && !hiveJDBCSettings.m_ssoSettings.m_ssoBrowserTimeoutPrecedence) {
            LogUtilities.logDebug("Overriding SSO Browser Timeout " + hiveJDBCSettings.m_ssoSettings.m_ssoBrowserTimeout + " with Login Time " + n * 1000 + " .", iLogger);
            hiveJDBCSettings.m_ssoSettings.m_ssoBrowserTimeout = n * 1000;
        }
        hiveJDBCSettings.m_ssoSettings.m_ssoLogSensitiveInfoForDebug = HiveCommonConnectionUtils.ParseBoolean(connSettingRequestMap, "SSOLogSensitiveInfo", false);
        map.put("SSOMaxNumConsecutiveAuthTries", true);
        Variant variant3 = connSettingRequestMap.getProperty("SSOMaxNumConsecutiveAuthTries");
        if (null != variant3) {
            try {
                hiveJDBCSettings.m_ssoSettings.m_ssoMaxConsecutiveAuthTries = variant3.getInt();
            }
            catch (Exception exception) {
                ErrorException errorException6 = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{"SSOMaxNumConsecutiveAuthTries", variant3.getString(), "Integers"});
                errorException6.initCause(exception);
                throw errorException6;
            }
        }
        map.put("SSOEnableNonIdempotentApiCallRetryOnTokenExpired", true);
        hiveJDBCSettings.m_ssoSettings.m_ssoReauthUnsafeApiCalls = HiveCommonConnectionUtils.ParseBoolean(connSettingRequestMap, "SSOEnableNonIdempotentApiCallRetryOnTokenExpired", true);
        if (hiveJDBCSettings.m_ssoSettings.m_ssoReauthUnsafeApiCalls) {
            hiveJDBCSettings.m_thriftHTTPSettings.m_httpRetrySettingsList.add(HiveCommonConnectionUtils.getNonIdempotentRetrySettings(hiveJDBCSettings));
        }
        map.put("SSOTestingUseDevHeaders", true);
        hiveJDBCSettings.m_ssoSettings.m_ssoTestingUseDevHeaders = HiveCommonConnectionUtils.ParseBoolean(connSettingRequestMap, "SSOTestingUseDevHeaders", false);
        if (hiveJDBCSettings.m_ssoSettings.m_ssoTestingUseDevHeaders) {
            errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.TESTING_SETTING_ENABLED.name(), "SSO SAML Use Dev Headers");
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            LogUtilities.logWarning(errorException.getMessage(), iLogger);
        }
        map.put("SSOTestingAllowNonSSL", true);
        hiveJDBCSettings.m_ssoSettings.m_ssoTestingAllowNonSSL = HiveCommonConnectionUtils.ParseBoolean(connSettingRequestMap, "SSOTestingAllowNonSSL", false);
        if (hiveJDBCSettings.m_ssoSettings.m_ssoTestingAllowNonSSL) {
            errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.TESTING_SETTING_ENABLED.name(), "SSO SAML Allow Non-SSL");
            errorException.loadMessage(DSIDriverSingleton.getInstance().getMessageSource(), DSIDriverSingleton.getInstance().getLocale());
            LogUtilities.logWarning(errorException.getMessage(), iLogger);
        } else if (hiveJDBCSettings.m_serverSSLSettings == null || !hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
            errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.SSL_NOT_ENABLED.name(), hiveJDBCSettings.m_authMech.getDisplayName());
            throw errorException;
        }
    }

    private static HttpRetrySettings getNonIdempotentRetrySettings(HiveJDBCSettings hiveJDBCSettings) {
        HttpRetryType httpRetryType;
        WholeNumberIntervalList wholeNumberIntervalList = new WholeNumberIntervalList();
        wholeNumberIntervalList.AddInterval(401, 401);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = DEFAULT_MAX_HTTP_RETRY_TIME;
        int n2 = DEFAULT_MIN_HTTP_RETRY_TIME_INTERVAL;
        int n3 = DEFAULT_HTTP_RETRY_TIMEOUT;
        boolean bl = DEFAULT_HTTP_RETRY_OVERRIDE_RETRY_AFTER_TIME;
        boolean bl2 = DEFAULT_HTTP_INCREASE_RETRY_INTERVAL_AFTER_EACH_RETRY;
        if (0 < hiveJDBCSettings.m_supportedHttpRetryType.size()) {
            httpRetryType = hiveJDBCSettings.m_supportedHttpRetryType.get(0);
            n = httpRetryType.m_defaultMaxRetryTime;
            n2 = httpRetryType.m_defaultMinRetryInterval;
            n3 = httpRetryType.m_defaultTimeout;
            bl2 = httpRetryType.m_defaultIncreaseRetryIntervalAfterEachRetry;
            bl = httpRetryType.m_defaultOverrideRetryAfterTime;
        }
        httpRetryType = new HttpRetryType("HTTPRetry", n, n2, n3, bl2, bl, wholeNumberIntervalList, arrayList, arrayList2);
        return new HttpRetrySettings(httpRetryType);
    }

    public static boolean ParseBoolean(ConnSettingRequestMap connSettingRequestMap, String string, boolean bl) throws ErrorException {
        Variant variant = connSettingRequestMap.getProperty(string);
        if (null != variant) {
            try {
                int n = variant.getInt();
                return 0 != n;
            }
            catch (Exception exception) {
                ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_BAD_PROPERTY.name(), new String[]{string, variant.getString(), "0 , 1"});
                errorException.initCause(exception);
                throw errorException;
            }
        }
        return bl;
    }

    public static int readOptionalIntegerSetting(ConnSettingRequestMap connSettingRequestMap, String string, int n, ILogger iLogger, IWarningListener iWarningListener) {
        int n2;
        block3: {
            LogUtilities.logFunctionEntrance(iLogger, string, n);
            n2 = n;
            Variant variant = connSettingRequestMap.getProperty(string);
            if (null != variant) {
                try {
                    return variant.getInt();
                }
                catch (Exception exception) {
                    if (null == iWarningListener) break block3;
                    iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant.getString(), string, "Value must be a valid integer value"}));
                }
            }
        }
        return n2;
    }

    public static int readOptionalPositiveIntegerSetting(ConnSettingRequestMap connSettingRequestMap, String string, int n, ILogger iLogger, IWarningListener iWarningListener) {
        LogUtilities.logFunctionEntrance(iLogger, string, n);
        int n2 = n;
        Variant variant = connSettingRequestMap.getProperty(string);
        if (null != variant) {
            try {
                int n3 = variant.getInt();
                if (n3 > 0) {
                    return n3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant.getString(), string, "Value must be a positive integer value"}));
            }
        }
        return n2;
    }

    public static long readOptionalPositiveLongSetting(ConnSettingRequestMap connSettingRequestMap, String string, long l, ILogger iLogger, IWarningListener iWarningListener) {
        LogUtilities.logFunctionEntrance(iLogger, string, l);
        long l2 = l;
        Variant variant = connSettingRequestMap.getProperty(string);
        if (null != variant) {
            try {
                long l3 = variant.getLong();
                if (l3 > 0L) {
                    return l3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant.getString(), string, "Value must be a positive long value"}));
            }
        }
        return l2;
    }
}

