/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.jdbc.jdbc42.future;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.future.IResultSet;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.OrderType;
import com.cloudera.hiveserver2.exceptions.ExceptionConverter;
import com.cloudera.hiveserver2.jdbc.common.SConnection;
import com.cloudera.hiveserver2.jdbc.jdbc41.future.S41DatabaseMetaData;
import com.cloudera.hiveserver2.jdbc.jdbc42.future.S42ForwardResultSet;
import com.cloudera.hiveserver2.jdbc.jdbc42.future.S42MetaDataProxy;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;

public class S42DatabaseMetaData
extends S41DatabaseMetaData {
    public S42DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 2;
    }

    @Override
    protected OrderType getJDBCOrderType() {
        return OrderType.JDBC_42;
    }

    @Override
    protected ResultSet wrapDSIMetadataResultSet(IResultSet iResultSet, MetadataSourceID metadataSourceID) throws SQLException {
        return new S42MetaDataProxy(this, iResultSet, metadataSourceID, this.m_logger);
    }

    @Override
    protected ResultSet wrapDSIResultSet(IResultSet iResultSet) throws SQLException {
        S42ForwardResultSet s42ForwardResultSet = new S42ForwardResultSet(this, iResultSet, this.m_logger);
        s42ForwardResultSet.initializeColumnsIfNeeded();
        return s42ForwardResultSet;
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }
}

