/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.jdbc.utils;

import com.cloudera.hiveserver2.jdbc.core.DSDriver;
import com.cloudera.hiveserver2.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.hiveserver2.jdbc.utils.DSEncryptionProperties;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public final class DSEncryptionUtils {
    public static String DecryptFromHex(String string, DSEncryptionProperties dSEncryptionProperties, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        try {
            return new String(dSEncryptionProperties.m_aesCipher_decrypt.doFinal(Base64.getDecoder().decode(string)));
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CACHE_ENCRYPTION_OPERATION_ERROR.name(), generalSecurityException.getMessage(), generalSecurityException.getCause());
            throw errorException;
        }
    }

    public static String EncryptFromHex(String string, DSEncryptionProperties dSEncryptionProperties, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        try {
            return Base64.getEncoder().encodeToString(dSEncryptionProperties.m_aesCipher_encrypt.doFinal(string.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException | BadPaddingException | IllegalBlockSizeException exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CACHE_ENCRYPTION_OPERATION_ERROR.name(), exception.getMessage(), exception.getCause());
            throw errorException;
        }
    }
}

