/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor.aemanipulator;

import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool.AENot;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;

public final class AEDeMorgansProcessor {
    private AEDeMorgansProcessor() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static void apply(final SqlDataEngineContext sqlDataEngineContext, IAENode iAENode) throws ErrorException {
        AETreeWalker.walk(iAENode, new AETreeWalker.Action<Void>(){
            private final AEDeMorgansVisitor m_deMorgans;
            {
                this.m_deMorgans = new AEDeMorgansVisitor(sqlDataEngineContext);
            }

            @Override
            public void act(IAENode iAENode) throws ErrorException {
                if (iAENode instanceof AEBooleanExpr) {
                    this.skipChildren();
                } else if (iAENode instanceof AEJoin) {
                    AEJoin aEJoin = (AEJoin)iAENode;
                    aEJoin.setJoinCondition(aEJoin.getJoinCondition().acceptVisitor(this.m_deMorgans));
                } else if (iAENode instanceof AESelect) {
                    AESelect aESelect = (AESelect)iAENode;
                    aESelect.setSelectCond(aESelect.getCondition().acceptVisitor(this.m_deMorgans));
                } else if (iAENode instanceof AEDelete) {
                    AEDelete aEDelete = (AEDelete)iAENode;
                    aEDelete.setCondition(aEDelete.getCondition().acceptVisitor(this.m_deMorgans));
                }
            }
        });
    }

    static final class AENegateVisitor
    extends AEDefaultVisitor<AEBooleanExpr> {
        private SqlDataEngineContext m_context;
        private AEDeMorgansVisitor m_deMorgans;

        public AENegateVisitor(AEDeMorgansVisitor aEDeMorgansVisitor, SqlDataEngineContext sqlDataEngineContext) {
            this.m_deMorgans = aEDeMorgansVisitor;
            this.m_context = sqlDataEngineContext;
        }

        @Override
        public AEBooleanExpr defaultVisit(IAENode iAENode) throws ErrorException {
            if (iAENode.getParent() instanceof AENot) {
                return (AENot)iAENode.getParent();
            }
            if (iAENode instanceof AEBooleanExpr) {
                return new AENot((AEBooleanExpr)iAENode);
            }
            throw new IllegalArgumentException(iAENode.toString());
        }

        @Override
        public AEBooleanExpr visit(AENot aENot) throws ErrorException {
            AEBooleanExpr aEBooleanExpr = aENot.getOperand();
            if (aEBooleanExpr instanceof AENot) {
                return this.negate(((AENot)aEBooleanExpr).getOperand());
            }
            return aEBooleanExpr.acceptVisitor(this.m_deMorgans);
        }

        @Override
        public AEBooleanExpr visit(AEAnd aEAnd) throws ErrorException {
            return new AEOr(this.negate(aEAnd.getLeftOperand()), this.negate(aEAnd.getRightOperand()));
        }

        @Override
        public AEBooleanExpr visit(AEOr aEOr) throws ErrorException {
            return new AEAnd(this.negate(aEOr.getLeftOperand()), this.negate(aEOr.getRightOperand()));
        }

        @Override
        public AEBooleanExpr visit(AEComparison aEComparison) throws ErrorException {
            if (aEComparison.getCoercedColumnMetadata().getTypeMetadata().isApproximateNumericType()) {
                return null;
            }
            return new AEComparison(this.m_context, aEComparison.getComparisonOp().complement(), aEComparison.getLeftOperand(), aEComparison.getRightOperand());
        }

        public AEBooleanExpr negate(AEBooleanExpr aEBooleanExpr) throws ErrorException {
            AEBooleanExpr aEBooleanExpr2 = aEBooleanExpr.acceptVisitor(this);
            if (aEBooleanExpr2 == null) {
                aEBooleanExpr2 = new AENot(aEBooleanExpr);
            }
            return aEBooleanExpr2;
        }
    }

    static final class AEDeMorgansVisitor
    extends AEDefaultVisitor<AEBooleanExpr> {
        private final AENegateVisitor m_negateVisitor;

        public AEDeMorgansVisitor(SqlDataEngineContext sqlDataEngineContext) {
            this.m_negateVisitor = new AENegateVisitor(this, sqlDataEngineContext);
        }

        @Override
        public AEBooleanExpr visit(AEAnd aEAnd) throws ErrorException {
            AEBooleanExpr aEBooleanExpr = aEAnd.getLeftOperand().acceptVisitor(this);
            AEBooleanExpr aEBooleanExpr2 = aEAnd.getRightOperand().acceptVisitor(this);
            if (aEAnd.getLeftOperand() != aEBooleanExpr) {
                aEAnd.setLeftOperand(aEBooleanExpr);
            }
            if (aEAnd.getRightOperand() != aEBooleanExpr2) {
                aEAnd.setRightOperand(aEBooleanExpr2);
            }
            return aEAnd;
        }

        @Override
        public AEBooleanExpr visit(AEOr aEOr) throws ErrorException {
            AEBooleanExpr aEBooleanExpr = aEOr.getLeftOperand().acceptVisitor(this);
            AEBooleanExpr aEBooleanExpr2 = aEOr.getRightOperand().acceptVisitor(this);
            if (aEOr.getLeftOperand() != aEBooleanExpr) {
                aEOr.setLeftOperand(aEBooleanExpr);
            }
            if (aEOr.getRightOperand() != aEBooleanExpr2) {
                aEOr.setRightOperand(aEBooleanExpr2);
            }
            return aEOr;
        }

        @Override
        public AEBooleanExpr visit(AENot aENot) throws ErrorException {
            AEBooleanExpr aEBooleanExpr = aENot.getOperand().acceptVisitor(this.m_negateVisitor);
            if (aEBooleanExpr == null) {
                return aENot;
            }
            return aEBooleanExpr;
        }

        @Override
        protected AEBooleanExpr defaultVisit(IAENode iAENode) throws ErrorException {
            if (iAENode instanceof AEBooleanExpr) {
                return (AEBooleanExpr)iAENode;
            }
            throw new IllegalArgumentException(iAENode.toString());
        }
    }
}

