/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAEBinaryNode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.metadatautil.AEAbstractColumnInfo;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.metadatautil.MetadataColumnInfo;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AEInPredicate
extends AEBooleanExpr
implements IAEBinaryNode<AEValueExprList, IAENode> {
    private static final int NUM_CHILDREN = 2;
    private final ICoercionHandler m_coercionHandler;
    private AEValueExprList m_leftOperand;
    private IAENode m_rightOperand;
    private IColumn m_coercionColumnMeta;
    private IAENode m_parent = null;

    public AEInPredicate(SqlDataEngineContext sqlDataEngineContext, AEValueExprList aEValueExprList, AEValueExprList aEValueExprList2) throws ErrorException {
        if (null == sqlDataEngineContext || null == aEValueExprList || null == aEValueExprList2 || 0 == aEValueExprList.getNumChildren() || 0 == aEValueExprList2.getNumChildren()) {
            throw new IllegalArgumentException("Illegal parameters for AEInPredicate. Null parameter or invalid operand");
        }
        if (1 < aEValueExprList.getNumChildren()) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Multiple expresions for left operand of In predicate is not supported.");
        }
        this.m_coercionHandler = sqlDataEngineContext.getCoercionHandler();
        this.m_leftOperand = aEValueExprList;
        this.m_leftOperand.setParent(this);
        this.m_rightOperand = aEValueExprList2;
        this.m_rightOperand.setParent(this);
        this.initalizeMetadata(this.m_coercionHandler);
    }

    public AEInPredicate(SqlDataEngineContext sqlDataEngineContext, AEValueExprList aEValueExprList, AERelationalExpr aERelationalExpr) throws ErrorException {
        if (null == sqlDataEngineContext || null == aEValueExprList || null == aERelationalExpr || 0 == aEValueExprList.getNumChildren() || 0 == aERelationalExpr.getColumnCount()) {
            throw new IllegalArgumentException("Illegal parameters for AEInPredicate. Null parameter or invalid operand");
        }
        if (1 != aEValueExprList.getNumChildren() || aERelationalExpr.getColumnCount() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Multiple expresions for operands of In predicate is not supported.");
        }
        this.m_coercionHandler = sqlDataEngineContext.getCoercionHandler();
        this.m_leftOperand = aEValueExprList;
        this.m_leftOperand.setParent(this);
        this.m_rightOperand = aERelationalExpr;
        this.m_rightOperand.setParent(this);
        this.initalizeMetadata(this.m_coercionHandler);
    }

    private AEInPredicate(AEInPredicate aEInPredicate) {
        this.setIsOptimized(aEInPredicate.isOptimized());
        this.m_coercionHandler = aEInPredicate.m_coercionHandler;
        this.m_leftOperand = aEInPredicate.m_leftOperand.copy();
        this.m_leftOperand.setParent(this);
        this.m_rightOperand = aEInPredicate.m_rightOperand.copy();
        this.m_rightOperand.setParent(this);
        this.m_coercionColumnMeta = ColumnMetadata.copyOf(aEInPredicate.m_coercionColumnMeta);
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public IAENode getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IAENode iAENode) {
        this.m_parent = iAENode;
    }

    @Override
    public AEBooleanExpr.AEBooleanType getType() {
        return AEBooleanExpr.AEBooleanType.IN_PRED;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEInPredicate)) {
            return false;
        }
        AEInPredicate aEInPredicate = (AEInPredicate)iAENode;
        return this.m_leftOperand.isEquivalent(aEInPredicate.m_leftOperand) && this.m_rightOperand.isEquivalent(aEInPredicate.m_rightOperand);
    }

    @Override
    public AEInPredicate copy() {
        return new AEInPredicate(this);
    }

    @Override
    public AEValueExprList getLeftOperand() {
        return this.m_leftOperand;
    }

    @Override
    public IAENode getRightOperand() {
        return this.m_rightOperand;
    }

    public void setRightOperand(AERelationalExpr aERelationalExpr) {
        this.m_rightOperand = aERelationalExpr;
        this.m_rightOperand.setParent(this);
    }

    public IColumn getCoercedColumnMetadata() {
        return this.m_coercionColumnMeta;
    }

    @Override
    public void updateCoercion() throws ErrorException {
        this.initalizeMetadata(this.m_coercionHandler);
    }

    private void initalizeMetadata(ICoercionHandler iCoercionHandler) throws ErrorException {
        if (this.m_leftOperand.getNumChildren() != 1) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("In Predicate only supports one value as the left operand.");
        }
        AECoercionColumnInfo aECoercionColumnInfo = new AECoercionColumnInfo((AEValueExpr)this.m_leftOperand.getChild(0));
        ArrayList<AEAbstractColumnInfo> arrayList = new ArrayList<AEAbstractColumnInfo>();
        if (this.m_rightOperand instanceof AERelationalExpr) {
            AERelationalExpr aERelationalExpr = (AERelationalExpr)this.m_rightOperand;
            arrayList.add(new MetadataColumnInfo(aERelationalExpr.getColumn(0), IColumnInfo.ColumnType.COLUMN));
        } else {
            AEValueExprList aEValueExprList = (AEValueExprList)this.m_rightOperand;
            Iterator iterator = aEValueExprList.getChildItr();
            while (iterator.hasNext()) {
                arrayList.add(new AECoercionColumnInfo((AEValueExpr)iterator.next()));
            }
        }
        this.m_coercionColumnMeta = iCoercionHandler.coerceInColumns(aECoercionColumnInfo, arrayList);
    }

    @Override
    protected List<IAENode> asList() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                switch (n) {
                    case 0: {
                        return AEInPredicate.this.m_leftOperand;
                    }
                    case 1: {
                        return AEInPredicate.this.m_rightOperand;
                    }
                }
                throw new IndexOutOfBoundsException("Index: " + n);
            }

            @Override
            public int size() {
                return 2;
            }
        };
    }
}

