/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.AEComparisonType;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAEBinaryNode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.metadatautil.MetadataColumnInfo;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.IColumnInfo;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.List;

public class AEQuantifiedComparison
extends AEBooleanExpr
implements IAEBinaryNode<AEValueExprList, IAENode> {
    private static final int NUM_CHILDREN = 2;
    private final ICoercionHandler m_coercionHandler;
    private AEValueExprList m_leftOperand;
    private AERelationalExpr m_rightOperand;
    private IColumn m_coercionColumnMeta;
    private IAENode m_parent = null;
    private AEComparisonType m_compType;
    private QuantifierType m_qtyType;

    public AEQuantifiedComparison(SqlDataEngineContext sqlDataEngineContext, AEValueExprList aEValueExprList, AERelationalExpr aERelationalExpr, AEComparisonType aEComparisonType, QuantifierType quantifierType) throws ErrorException {
        if (null == sqlDataEngineContext || null == aEValueExprList || null == aERelationalExpr || 0 == aEValueExprList.getNumChildren() || 0 == aERelationalExpr.getNumChildren()) {
            throw new IllegalArgumentException("Illegal parameters for AEInPredicate. Null parameter or invalid operand");
        }
        if (1 != aEValueExprList.getNumChildren() || 1 != aERelationalExpr.getColumnCount()) {
            throw SQLEngineExceptionFactory.featureNotImplementedException("Multiple expresions for quantified comparison is not supported.");
        }
        this.m_coercionHandler = sqlDataEngineContext.getCoercionHandler();
        this.m_leftOperand = aEValueExprList;
        this.m_leftOperand.setParent(this);
        this.m_rightOperand = aERelationalExpr;
        this.m_rightOperand.setParent(this);
        this.m_compType = aEComparisonType;
        this.m_qtyType = quantifierType;
        this.initalizeMetadata(this.m_coercionHandler);
    }

    private AEQuantifiedComparison(AEQuantifiedComparison aEQuantifiedComparison) {
        this.setIsOptimized(aEQuantifiedComparison.isOptimized());
        this.m_coercionHandler = aEQuantifiedComparison.m_coercionHandler;
        this.m_leftOperand = aEQuantifiedComparison.m_leftOperand.copy();
        this.m_leftOperand.setParent(this);
        this.m_rightOperand = aEQuantifiedComparison.m_rightOperand.copy();
        this.m_rightOperand.setParent(this);
        this.m_coercionColumnMeta = ColumnMetadata.copyOf(aEQuantifiedComparison.m_coercionColumnMeta);
        this.m_qtyType = aEQuantifiedComparison.m_qtyType;
        this.m_compType = aEQuantifiedComparison.m_compType;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    public QuantifierType getQuantifierType() {
        return this.m_qtyType;
    }

    public AEComparisonType getComparisonOp() {
        return this.m_compType;
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName() + " : " + this.m_compType.name() + " " + this.m_qtyType.name();
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public IAENode getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IAENode iAENode) {
        this.m_parent = iAENode;
    }

    @Override
    public AEBooleanExpr.AEBooleanType getType() {
        return AEBooleanExpr.AEBooleanType.QUANITIFIED_COMPARISON;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEQuantifiedComparison)) {
            return false;
        }
        AEQuantifiedComparison aEQuantifiedComparison = (AEQuantifiedComparison)iAENode;
        return this.m_leftOperand.isEquivalent(aEQuantifiedComparison.m_leftOperand) && this.m_rightOperand.isEquivalent(aEQuantifiedComparison.m_rightOperand) && this.m_compType == aEQuantifiedComparison.m_compType && this.m_qtyType == aEQuantifiedComparison.m_qtyType;
    }

    @Override
    public AEQuantifiedComparison copy() {
        return new AEQuantifiedComparison(this);
    }

    @Override
    public AEValueExprList getLeftOperand() {
        return this.m_leftOperand;
    }

    @Override
    public AERelationalExpr getRightOperand() {
        return this.m_rightOperand;
    }

    public void setRightOperand(AERelationalExpr aERelationalExpr) {
        this.m_rightOperand = aERelationalExpr;
        this.m_rightOperand.setParent(this);
    }

    public IColumn getCoercedColumnMetadata() {
        return this.m_coercionColumnMeta;
    }

    @Override
    public void updateCoercion() throws ErrorException {
        this.initalizeMetadata(this.m_coercionHandler);
    }

    private void initalizeMetadata(ICoercionHandler iCoercionHandler) throws ErrorException {
        assert (this.m_leftOperand.getNumChildren() == 1);
        AECoercionColumnInfo aECoercionColumnInfo = new AECoercionColumnInfo((AEValueExpr)this.m_leftOperand.getChild(0));
        MetadataColumnInfo metadataColumnInfo = new MetadataColumnInfo(this.m_rightOperand.getColumn(0), IColumnInfo.ColumnType.COLUMN);
        this.m_coercionColumnMeta = iCoercionHandler.coerceComparisonColumns(aECoercionColumnInfo, metadataColumnInfo);
    }

    @Override
    protected List<IAENode> asList() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                switch (n) {
                    case 0: {
                        return AEQuantifiedComparison.this.m_leftOperand;
                    }
                    case 1: {
                        return AEQuantifiedComparison.this.m_rightOperand;
                    }
                }
                throw new IndexOutOfBoundsException("Index: " + n);
            }

            @Override
            public int size() {
                return 2;
            }
        };
    }

    public static enum QuantifierType {
        ANY,
        ALL;

    }
}

