/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.metadata;

import com.cloudera.hiveserver2.dsi.dataengine.filters.IFilter;
import com.cloudera.hiveserver2.dsi.dataengine.filters.StringFilter;
import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IMetadataSourceExt;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.cloudera.hiveserver2.sqlengine.dsiext.dataengine.Identifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class DSIExtPartiallyFilteredMetadataSource
implements IMetadataSourceExt {
    private IFilter m_catalogFilter;
    private IFilter m_schemaFilter;
    private IFilter m_procedureOrTableFilter;
    private final MetadataSourceColumnTag m_procedureOrTableColumnTag;
    private final IMetadataHelper m_metadataHelper;
    private Identifier m_nextIdentifier;
    private final boolean m_isODBC2;

    @Deprecated
    protected DSIExtPartiallyFilteredMetadataSource(Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, MetadataSourceColumnTag metadataSourceColumnTag, boolean bl) {
        this(iMetadataHelper, metadataSourceColumnTag, bl, DSIExtPartiallyFilteredMetadataSource.createFilters(map));
    }

    protected DSIExtPartiallyFilteredMetadataSource(IMetadataHelper iMetadataHelper, MetadataSourceColumnTag metadataSourceColumnTag, boolean bl, List<IFilter> list) {
        if (metadataSourceColumnTag != MetadataSourceColumnTag.TABLE_NAME && metadataSourceColumnTag != MetadataSourceColumnTag.PROCEDURE_NAME) {
            throw new IllegalArgumentException("Invalid procedure or table tag : " + metadataSourceColumnTag.name());
        }
        for (IFilter iFilter : list) {
            switch (iFilter.getColumnTag()) {
                case CATALOG_NAME: {
                    this.m_catalogFilter = iFilter;
                    break;
                }
                case SCHEMA_NAME: {
                    this.m_schemaFilter = iFilter;
                    break;
                }
                case TABLE_NAME: 
                case PROCEDURE_NAME: {
                    this.m_procedureOrTableFilter = iFilter;
                    break;
                }
            }
        }
        this.m_procedureOrTableColumnTag = metadataSourceColumnTag;
        this.m_metadataHelper = iMetadataHelper;
        this.m_isODBC2 = bl;
    }

    protected boolean hasNextProcedureOrTable() {
        if (this.m_nextIdentifier == null) {
            this.m_nextIdentifier = this.findNextProcedureOrTable();
        }
        return this.m_nextIdentifier != null;
    }

    protected Identifier getNextProcedureOrTable() {
        if (this.m_nextIdentifier == null) {
            return this.findNextProcedureOrTable();
        }
        Identifier identifier = this.m_nextIdentifier;
        this.m_nextIdentifier = null;
        return identifier;
    }

    private Identifier findNextProcedureOrTable() {
        Identifier identifier;
        while ((identifier = this.getNextIdentifier()) != null) {
            if (!this.filter(this.m_catalogFilter, identifier.getCatalog()) || !this.filter(this.m_schemaFilter, identifier.getSchema()) || !this.filter(this.m_procedureOrTableFilter, identifier.getName())) continue;
            return identifier;
        }
        return null;
    }

    private boolean filter(IFilter iFilter, String string) {
        if (null == iFilter) {
            return true;
        }
        DataWrapper dataWrapper = new DataWrapper();
        dataWrapper.setChar(string);
        return iFilter.filter(dataWrapper);
    }

    protected final int NormalizeDateTimeTypeForODBC2(int n) {
        return TypeUtilities.NormalizeDateTimeTypeForODBC2(n, this.m_isODBC2);
    }

    private Identifier getNextIdentifier() {
        Identifier identifier = new Identifier();
        if (this.m_procedureOrTableColumnTag == MetadataSourceColumnTag.TABLE_NAME) {
            return this.m_metadataHelper.getNextTable(identifier) ? identifier : null;
        }
        return this.m_metadataHelper.getNextProcedure(identifier) ? identifier : null;
    }

    @Override
    public void passdownFilters(List<IFilter> list) {
        Iterator<IFilter> iterator = list.iterator();
        while (iterator.hasNext()) {
            IFilter iFilter = iterator.next();
            MetadataSourceColumnTag metadataSourceColumnTag = iFilter.getColumnTag();
            if (metadataSourceColumnTag == MetadataSourceColumnTag.CATALOG_NAME) {
                this.m_catalogFilter = iFilter;
            } else if (metadataSourceColumnTag == MetadataSourceColumnTag.SCHEMA_NAME) {
                this.m_schemaFilter = iFilter;
            } else {
                if (metadataSourceColumnTag != this.m_procedureOrTableColumnTag) continue;
                this.m_procedureOrTableFilter = iFilter;
            }
            iterator.remove();
        }
    }

    private static List<IFilter> createFilters(Map<MetadataSourceColumnTag, String> map) {
        ArrayList<IFilter> arrayList = new ArrayList<IFilter>(map.size());
        for (MetadataSourceColumnTag metadataSourceColumnTag : map.keySet()) {
            arrayList.add(new StringFilter(metadataSourceColumnTag, map.get((Object)metadataSourceColumnTag), true));
        }
        return arrayList;
    }
}

