/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.relation;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.CursorType;
import com.cloudera.hiveserver2.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IMemManagerAgent;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IMemoryConsumer;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETUnaryRelationalExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.ITemporaryTable;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;

public class ETRelationalCache
extends ETUnaryRelationalExpr
implements IMemoryConsumer {
    private boolean m_isCursorOpened;
    private final ITemporaryTable m_cache;

    public ETRelationalCache(ETRelationalExpr eTRelationalExpr, ITemporaryTable iTemporaryTable) {
        super(eTRelationalExpr, ETRelationalCache.extractDataNeeded(eTRelationalExpr));
        this.m_cache = iTemporaryTable;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.getOperand().getColumn(n);
    }

    @Override
    public int getColumnCount() {
        return this.getOperand().getColumnCount();
    }

    @Override
    public String getLogString() {
        return "ETRelationalCache";
    }

    @Override
    public long getRowCount() throws ErrorException {
        if (this.isOpen()) {
            return this.m_cache.getRowCount();
        }
        return this.getOperand().getRowCount();
    }

    @Override
    public boolean isOpen() {
        return this.m_isCursorOpened;
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        super.open(cursorType);
        this.m_cache.open();
        this.m_cache.writeFromRelation(this.getOperand());
        this.getOperand().close(this.getOperand().canReopenAfterClosed());
        this.m_cache.reset();
        this.m_isCursorOpened = true;
    }

    @Override
    public void close(boolean bl) {
        super.close(bl);
        this.m_cache.close(bl);
        this.m_isCursorOpened = false;
    }

    @Override
    public void reset() throws ErrorException {
        assert (this.isOpen());
        this.m_cache.reset();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_cache.retrieveData(n, eTDataRequest);
    }

    @Override
    protected boolean doMove() throws ErrorException {
        assert (this.isOpen());
        return this.m_cache.moveToNextRow();
    }

    private static boolean[] extractDataNeeded(ETRelationalExpr eTRelationalExpr) {
        boolean[] blArray = new boolean[eTRelationalExpr.getColumnCount()];
        for (int i = 0; i < eTRelationalExpr.getColumnCount(); ++i) {
            if (!eTRelationalExpr.getDataNeeded(i)) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_cache.registerManagerAgent(iMemManagerAgent);
    }

    @Override
    public long assign(long l) {
        return this.m_cache.assign(l);
    }

    @Override
    public long getRequiredMemory() {
        return this.m_cache.getRequiredMemory();
    }
}

