/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.relation;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.dsi.dataengine.utilities.CursorType;
import com.cloudera.hiveserver2.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IETNode;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.hiveserver2.sqlengine.executor.etree.IETUnaryNode;
import com.cloudera.hiveserver2.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExprList;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.List;

public class ETTableConstructor
extends ETRelationalExpr
implements IETUnaryNode<ETValueExprList> {
    private ETValueExprList m_operand;
    private boolean m_hasStartedFetch = false;
    private List<IColumn> m_columns;

    public ETTableConstructor(ETValueExprList eTValueExprList, List<IColumn> list, boolean[] blArray) {
        super(blArray);
        this.m_operand = eTValueExprList;
        this.m_columns = list;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close(boolean bl) {
        this.m_operand.close(bl);
        this.m_hasStartedFetch = false;
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_columns.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_operand.getNumChildren();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return 1L;
    }

    @Override
    public boolean isOpen() {
        Iterator iterator = this.m_operand.getChildItr();
        while (iterator.hasNext()) {
            if (((ETValueExpr)iterator.next()).isOpen()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        this.m_operand.open();
    }

    @Override
    public void reset() throws ErrorException {
        this.m_operand.reset();
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_operand.retrieveData(n, eTDataRequest);
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (0 == n) {
            return this.m_operand;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    protected boolean doMove() throws ErrorException {
        if (this.m_hasStartedFetch) {
            return false;
        }
        this.m_hasStartedFetch = true;
        return true;
    }

    @Override
    public ETValueExprList getOperand() {
        return this.m_operand;
    }
}

