/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.etree.temptable;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.BlockConverter;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.DataStore;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.InMemTable;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.IndexRowView;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.RowComparator;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.TemporaryFile;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.cloudera.hiveserver2.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.hiveserver2.support.ILogger;
import com.cloudera.hiveserver2.support.LogUtilities;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.UUID;

public class OnePassSorter {
    private BlockConverter m_block;
    private InMemTable m_table;
    private PriorityQueue<Integer> m_curHeap;
    private PriorityQueue<Integer> m_backupHeap;
    private DataStore m_curDataStore;
    private List<DataStore> m_sorted;
    private int m_curRow = -1;
    private ILogger m_logger;
    private boolean m_pollStarted;
    private TemporaryTableBuilder.TemporaryTableProperties m_properties;
    private IColumn[] m_columnMetadata;
    private long m_memLimitForSorting;
    private final IndexComparator m_idxCmp;

    public OnePassSorter(IColumn[] iColumnArray, TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties, RowComparator rowComparator, boolean[] blArray) throws ErrorException {
        IndexComparator indexComparator;
        this.m_columnMetadata = (IColumn[])iColumnArray.clone();
        this.m_properties = temporaryTableProperties;
        this.m_logger = temporaryTableProperties.m_logger;
        this.m_block = new BlockConverter(iColumnArray, temporaryTableProperties, this.m_logger, blArray);
        int n = (int)(temporaryTableProperties.m_blockSize / temporaryTableProperties.m_rowSize / 10L) + 1;
        this.m_table = new InMemTable(iColumnArray, temporaryTableProperties.m_maxDataLen, n, blArray, this.m_logger);
        this.m_idxCmp = indexComparator = new IndexComparator(rowComparator, this.m_table);
        this.m_memLimitForSorting = -1 * (this.m_table.getMemOverhead() + this.m_block.getMemOverhead());
        this.m_curHeap = new PriorityQueue<Integer>(100, this.m_idxCmp);
        this.m_backupHeap = new PriorityQueue<Integer>(100, this.m_idxCmp);
        this.m_sorted = new ArrayList<DataStore>();
        this.m_curDataStore = new DataStore(this.m_properties, this.m_columnMetadata);
        if (null != temporaryTableProperties.m_logger) {
            long l = this.m_properties.m_blockSize;
            String string = l >= 0x100000L ? String.format("%.1fM", (double)l * 1.0 / 1048576.0) : (l >= 1024L ? String.format("%.1fK", (double)l * 1.0 / 1024.0) : l + "B");
            LogUtilities.logDebug("Block size: " + string, temporaryTableProperties.m_logger);
        }
    }

    public void appendRow() throws ErrorException {
        int n;
        this.m_curRow = this.tryAppend();
        while (this.m_curRow < 0 && this.m_curHeap.size() > 0) {
            this.m_pollStarted = true;
            n = this.m_curHeap.poll();
            this.copyAndRemoveRow(n);
            this.m_curRow = this.tryAppend();
        }
        if (this.m_curRow < 0) {
            this.flushCurrentHeap();
        }
        while (this.m_curRow < 0 && this.m_curHeap.size() > 0) {
            this.m_pollStarted = true;
            n = this.m_curHeap.poll();
            this.copyAndRemoveRow(n);
            this.m_curRow = this.tryAppend();
        }
        assert (this.m_curRow >= 0);
    }

    public void destroy() {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        this.m_block = null;
        this.m_table.clear();
        this.m_table = null;
        this.m_curDataStore.destroy();
        this.m_curDataStore = null;
        if (this.m_sorted != null) {
            for (DataStore dataStore : this.m_sorted) {
                dataStore.destroy();
            }
        }
    }

    private int tryAppend() {
        if ((long)(this.m_table.getMemUsage() + this.getIndexOverhead(this.m_table.getNumRows())) > this.m_memLimitForSorting) {
            return -1;
        }
        return this.m_table.appendRow();
    }

    public void finishAppending() {
        assert (this.m_curRow >= 0);
        if (this.m_pollStarted && (this.m_curHeap.isEmpty() || this.m_idxCmp.compare(this.m_curRow, this.m_curHeap.peek()) < 0)) {
            this.m_backupHeap.offer(this.m_curRow);
        } else {
            this.m_curHeap.offer(this.m_curRow);
        }
        this.m_curRow = -1;
    }

    public List<DataStore> getSorted() throws ErrorException {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        this.flushCurrentHeap();
        this.flushCurrentHeap();
        List<DataStore> list = this.m_sorted;
        this.m_sorted = null;
        return list;
    }

    private void flushCurrentHeap() throws ErrorException {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        boolean bl = this.m_curHeap.size() > 0 || this.m_block.getNumRows() > 0 || this.m_curDataStore.getNumberBlocks() > 0;
        for (int i = this.m_curHeap.size(); i > 0; --i) {
            int n = this.m_curHeap.poll();
            this.copyAndRemoveRow(n);
        }
        if (this.m_block.getNumRows() != 0) {
            this.m_curDataStore.put(this.m_block.toRowBlock());
        }
        if (bl) {
            this.m_sorted.add(this.m_curDataStore);
            this.m_curDataStore = new DataStore(this.m_properties, this.m_columnMetadata);
        }
        this.swapHeap();
    }

    private void copyAndRemoveRow(int n) throws ErrorException {
        boolean bl = this.m_block.appendRow();
        if (!bl) {
            this.m_curDataStore.put(this.m_block.toRowBlock());
            this.m_block.appendRow();
        }
        block16: for (int i = 0; i < this.m_columnMetadata.length; ++i) {
            if (this.m_table.isNull(n, i)) {
                this.m_block.setNull(i);
                continue;
            }
            if (ColumnSizeCalculator.isLongData(this.m_columnMetadata[i], this.m_properties.m_maxDataLen)) {
                this.m_block.setFileMarker(i, this.m_table.getFileMarker(n, i));
                continue;
            }
            switch (this.m_columnMetadata[i].getTypeMetadata().getType()) {
                case -4: 
                case -3: 
                case -2: {
                    this.m_block.setBytes(i, this.m_table.getBytes(n, i));
                    continue block16;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    this.m_block.setString(i, this.m_table.getString(n, i));
                    continue block16;
                }
                case -7: 
                case 16: {
                    this.m_block.setBoolean(i, this.m_table.getBoolean(n, i));
                    continue block16;
                }
                case -6: {
                    this.m_block.setTinyInt(i, this.m_table.getTinyInt(n, i));
                    continue block16;
                }
                case 5: {
                    this.m_block.setSmallInt(i, this.m_table.getSmallInt(n, i));
                    continue block16;
                }
                case 4: {
                    this.m_block.setInteger(i, this.m_table.getInteger(n, i));
                    continue block16;
                }
                case -5: {
                    this.m_block.setBigInt(i, this.m_table.getBigInt(n, i));
                    continue block16;
                }
                case 7: {
                    this.m_block.setReal(i, this.m_table.getReal(n, i));
                    continue block16;
                }
                case 6: 
                case 8: {
                    this.m_block.setDouble(i, this.m_table.getDouble(n, i));
                    continue block16;
                }
                case 2: 
                case 3: {
                    this.m_block.setExactNum(i, this.m_table.getExactNum(n, i));
                    continue block16;
                }
                case 91: {
                    this.m_block.setDate(i, this.m_table.getDate(n, i));
                    continue block16;
                }
                case 92: {
                    this.m_block.setTime(i, this.m_table.getTime(n, i));
                    continue block16;
                }
                case 93: {
                    this.m_block.setTimestamp(i, this.m_table.getTimestamp(n, i));
                    continue block16;
                }
                case -11: {
                    this.m_block.setGuid(i, this.m_table.getGuid(n, i));
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Unknown column type");
                }
            }
        }
        this.m_table.removeRow(n);
    }

    public void swapHeap() {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        PriorityQueue<Integer> priorityQueue = this.m_curHeap;
        this.m_curHeap = this.m_backupHeap;
        this.m_backupHeap = priorityQueue;
        this.m_pollStarted = false;
    }

    public void setNull(int n) {
        this.m_table.setNull(this.m_curRow, n);
    }

    public void setBigInt(int n, long l) {
        this.m_table.setBigInt(this.m_curRow, n, l);
    }

    public void setExactNum(int n, BigDecimal bigDecimal) {
        this.m_table.setExactNum(this.m_curRow, n, bigDecimal);
    }

    public void setDouble(int n, double d) {
        this.m_table.setDouble(this.m_curRow, n, d);
    }

    public void setReal(int n, float f) {
        this.m_table.setReal(this.m_curRow, n, f);
    }

    public void setBoolean(int n, boolean bl) {
        this.m_table.setBoolean(this.m_curRow, n, bl);
    }

    public void setString(int n, String string) {
        this.m_table.setString(this.m_curRow, n, string);
    }

    public void setDate(int n, Date date) {
        this.m_table.setDate(this.m_curRow, n, date);
    }

    public void setTime(int n, Time time) {
        this.m_table.setTime(this.m_curRow, n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        this.m_table.setTimestamp(this.m_curRow, n, timestamp);
    }

    public void setFileMarker(int n, TemporaryFile.FileMarker fileMarker) {
        this.m_table.setFileMarker(this.m_curRow, n, fileMarker);
    }

    public void setGuid(int n, UUID uUID) {
        this.m_table.setGuid(this.m_curRow, n, uUID);
    }

    public void setInteger(int n, int n2) {
        this.m_table.setInteger(this.m_curRow, n, n2);
    }

    public void setSmallInt(int n, short s) {
        this.m_table.setSmallInt(this.m_curRow, n, s);
    }

    public void setTinyInt(int n, byte by) {
        this.m_table.setTinyInt(this.m_curRow, n, by);
    }

    public void setBytes(int n, byte[] byArray) {
        this.m_table.setBytes(this.m_curRow, n, byArray);
    }

    private int getIndexOverhead(int n) {
        return n * (ColumnSizeCalculator.JAVA_SIZE.getIntSize() + ColumnSizeCalculator.JAVA_SIZE.getObjectShellSize() + ColumnSizeCalculator.JAVA_SIZE.getObjectRefSize());
    }

    public void increaseMemoryUsage(long l) {
        if (this.m_memLimitForSorting < 0L) {
            this.m_memLimitForSorting += l;
            if (this.m_memLimitForSorting > 0L) {
                this.m_table.increaseMemLimit(this.m_memLimitForSorting);
            }
        } else {
            this.m_table.increaseMemLimit(l);
        }
    }

    private static final class IndexComparator
    implements Comparator<Integer> {
        private final InMemTable m_table;
        private final RowComparator m_cmp;

        public IndexComparator(RowComparator rowComparator, InMemTable inMemTable) {
            this.m_table = inMemTable;
            this.m_cmp = rowComparator;
        }

        @Override
        public int compare(Integer n, Integer n2) {
            IndexRowView indexRowView = new IndexRowView(this.m_table);
            indexRowView.setRowNum(n);
            IndexRowView indexRowView2 = new IndexRowView(this.m_table);
            indexRowView2.setRowNum(n2);
            return this.m_cmp.compare(indexRowView, indexRowView2);
        }
    }
}

