/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hiveserver2.sqlengine.executor.materializer;

import com.cloudera.hiveserver2.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hiveserver2.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.cloudera.hiveserver2.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlCharDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.datawrapper.SqlDoubleDataWrapper;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETConstant;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETACosFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETASinFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETATan2Fn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETATanFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETAbsFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETAsciiFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETCeilingFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETCharFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETConcatFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETCosFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETCotFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETCurDateFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETCurTimeFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETCurTimestampFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETCurrentTime1Fn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETDatabaseFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETDayNameFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETDayOfMonthFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETDayOfWeekFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETDayOfYearFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETDegreesFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETExpFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETExtractFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETFloorFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETHourFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETIfNullFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETInsertFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETLTrim;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETLeftFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETLengthFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETLocateFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETLog10Fn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETLogFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETLowerFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETMinuteFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETModFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETMonthFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETMonthNameFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETPowerFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETQuarterFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETRTrim;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETRadiansFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETRandFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETRepeatFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETReplaceFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETRightFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETRoundFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETSecondFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETSignFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETSinFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETSoundexFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETSpaceFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETSqrtFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETSubstringFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETTanFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETTimestampAddFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETTimestampDiffFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETTruncateFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETUCaseFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETUserFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETWeekFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETWeekIsoFn;
import com.cloudera.hiveserver2.sqlengine.executor.etree.value.scalar.ETYearFn;
import com.cloudera.hiveserver2.sqlengine.executor.materializer.MaterializerContext;
import com.cloudera.hiveserver2.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ETScalarFnFactory {
    public static ETValueExpr makeNewScalarFn(AEScalarFn aEScalarFn, List<IColumn> list, ArrayList<ETValueExpr> arrayList, MaterializerContext materializerContext) throws ErrorException {
        assert (arrayList.size() == list.size());
        switch (aEScalarFn.getScalarFnId()) {
            case ABS: {
                return new ETAbsFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ACOS: {
                return new ETACosFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ASCII: {
                return new ETAsciiFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ASIN: {
                return new ETASinFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ATAN: {
                return new ETATanFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ATAN2: {
                return new ETATan2Fn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CEILING: {
                return new ETCeilingFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CHAR: {
                return new ETCharFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CONCAT: {
                return new ETConcatFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case COS: {
                return new ETCosFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case COT: {
                return new ETCotFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CURDATE: 
            case CURRENT_DATE: {
                return new ETCurDateFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CURTIME: 
            case CURRENT_TIME: {
                return new ETCurTimeFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CURRENT_TIME1: {
                return new ETCurrentTime1Fn(aEScalarFn.getColumn(), arrayList, list);
            }
            case CURRENT_TIMESTAMP: 
            case NOW: {
                assert (arrayList.isEmpty());
            }
            case CURRENT_TIMESTAMP1: {
                return new ETCurTimestampFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DATABASE: {
                return new ETDatabaseFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DAYNAME: {
                return new ETDayNameFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DAYOFMONTH: {
                return new ETDayOfMonthFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DAYOFWEEK: {
                return new ETDayOfWeekFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DAYOFYEAR: {
                return new ETDayOfYearFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case DEGREES: {
                return new ETDegreesFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case EXP: {
                return new ETExpFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case FLOOR: {
                return new ETFloorFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case HOUR: {
                return new ETHourFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case IFNULL: {
                return new ETIfNullFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case INSERT: {
                return new ETInsertFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LCASE: 
            case LOWER: {
                return new ETLowerFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LEFT: {
                return new ETLeftFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LENGTH: {
                return new ETLengthFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LOG: {
                return new ETLogFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LOG10: {
                return new ETLog10Fn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LOCATE2: 
            case LOCATE3: {
                return new ETLocateFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case LTRIM: {
                return new ETLTrim(aEScalarFn.getColumn(), arrayList, list);
            }
            case MINUTE: {
                return new ETMinuteFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case MOD: {
                return new ETModFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case MONTH: {
                return new ETMonthFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case MONTHNAME: {
                return new ETMonthNameFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case NULL: {
                SqlCharDataWrapper sqlCharDataWrapper = new SqlCharDataWrapper(1);
                sqlCharDataWrapper.setNull();
                return new ETConstant(sqlCharDataWrapper);
            }
            case PI: {
                SqlDoubleDataWrapper sqlDoubleDataWrapper = new SqlDoubleDataWrapper(8);
                sqlDoubleDataWrapper.setDouble(Math.PI);
                return new ETConstant(sqlDoubleDataWrapper);
            }
            case POWER: {
                return new ETPowerFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case QUARTER: {
                return new ETQuarterFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case RADIANS: {
                return new ETRadiansFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case RAND0: {
                SqlDoubleDataWrapper sqlDoubleDataWrapper = new SqlDoubleDataWrapper(8);
                sqlDoubleDataWrapper.setDouble(new Random().nextDouble());
                return new ETConstant(sqlDoubleDataWrapper);
            }
            case RAND1: {
                return new ETRandFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case REPEAT: {
                return new ETRepeatFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case REPLACE: {
                return new ETReplaceFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case RIGHT: {
                return new ETRightFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case ROUND: {
                return new ETRoundFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case RTRIM: {
                return new ETRTrim(aEScalarFn.getColumn(), arrayList, list);
            }
            case SECOND: {
                return new ETSecondFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SIGN: {
                return new ETSignFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SIN: {
                return new ETSinFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SOUNDEX: {
                return new ETSoundexFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SPACE: {
                return new ETSpaceFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SQRT: {
                return new ETSqrtFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case SUBSTRING2: 
            case SUBSTRING3: {
                return new ETSubstringFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case TAN: {
                return new ETTanFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case TIMESTAMPADD: {
                return new ETTimestampAddFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case TIMESTAMPDIFF: {
                return new ETTimestampDiffFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case TRUNCATE: {
                return new ETTruncateFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case UCASE: 
            case UPPER: {
                return new ETUCaseFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case USER: {
                return new ETUserFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case WEEK: {
                return new ETWeekFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case WEEK_ISO: {
                return new ETWeekIsoFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case YEAR: {
                return new ETYearFn(aEScalarFn.getColumn(), arrayList, list);
            }
            case EXTRACT: {
                return new ETExtractFn(aEScalarFn.getColumn(), arrayList, list);
            }
        }
        throw SQLEngineExceptionFactory.featureNotImplementedException("scalar function not supported");
    }
}

