/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.HS2ClientWrapper;
import com.cloudera.impala.hivecommon.api.HiveMultiSocketFetchClientContext;
import com.cloudera.impala.hivecommon.api.HiveMultiSocketFetchContext;
import com.cloudera.impala.hivecommon.api.HiveOperationContext;
import com.cloudera.impala.hivecommon.api.HiveServer2BaseBuffer;
import com.cloudera.impala.hivecommon.api.IHiveHS2BufferFactory;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.utils.HiveHS2ClientUtils;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TRowSet;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkArrowResultLink;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TStatus;
import com.cloudera.impala.jdbc42.internal.apache.hive.service.rpc.thrift.TStatusCode;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class HiveMultiSocketFetchHandler
implements Runnable {
    private HiveJDBCSettings m_settings;
    private HiveMultiSocketFetchClientContext m_clientCtx;
    private HS2ClientWrapper m_clientWrapper;
    private IHiveHS2BufferFactory m_hs2BufferFactory;
    private AtomicBoolean m_isStopSignaled = new AtomicBoolean(false);
    private ILogger m_logger;

    public HiveMultiSocketFetchHandler(HiveJDBCSettings hiveJDBCSettings, HiveMultiSocketFetchClientContext hiveMultiSocketFetchClientContext, HS2ClientWrapper hS2ClientWrapper, IHiveHS2BufferFactory iHiveHS2BufferFactory, ILogger iLogger) {
        if (hiveJDBCSettings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        }
        this.m_settings = hiveJDBCSettings;
        this.m_logger = iLogger;
        this.m_clientCtx = hiveMultiSocketFetchClientContext;
        this.m_clientWrapper = hS2ClientWrapper;
        this.m_hs2BufferFactory = iHiveHS2BufferFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block77: {
            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
                LogUtilities.logDebug("Fetch handler has started to run. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
            }
            HiveOperationContext hiveOperationContext = null;
            try {
                boolean bl = true;
                boolean bl2 = false;
                long l = this.m_settings.m_multiSocketFetchHandlerIdleTimeout;
                while (bl) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.stop();
                    }
                    if (this.isStopSignaled()) {
                        if (null != hiveOperationContext) {
                            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                LogUtilities.logDebug("Fetch handler has been signalled to stop and there is an unhandled fetch request which would be put back to the queue of submitted tasks. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                                HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                            }
                            HiveMultiSocketFetchClientContext hiveMultiSocketFetchClientContext = this.m_clientCtx;
                            synchronized (hiveMultiSocketFetchClientContext) {
                                this.m_clientCtx.m_fetchTasks.add(0, hiveOperationContext);
                                hiveOperationContext = null;
                                break;
                            }
                        }
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logDebug("Fetch handler has been signalled to stop. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                        }
                        break;
                    }
                    Object object = this.m_clientCtx;
                    synchronized (object) {
                        if (this.m_clientCtx.m_fetchTasks.isEmpty()) {
                            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                LogUtilities.logDebug("Fetch task queue is empty and the fetch handler will sleep. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                            }
                            bl2 = true;
                        } else {
                            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                LogUtilities.logDebug("Fetch handler is taking a task from the top of the task queue to process. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                            }
                            hiveOperationContext = this.m_clientCtx.m_fetchTasks.remove(0);
                            l = this.m_settings.m_multiSocketFetchHandlerIdleTimeout;
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                    }
                    if (null != hiveOperationContext) {
                        Object object2;
                        HiveMultiSocketFetchClientContext hiveMultiSocketFetchClientContext;
                        Object object3;
                        object = hiveOperationContext.m_multiSocketFetchCtx;
                        Object object4 = this.m_clientCtx;
                        synchronized (object4) {
                            object3 = object;
                            synchronized (object3) {
                                if (null != ((HiveMultiSocketFetchContext)object).m_lastRowset) {
                                    if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                        LogUtilities.logDebug("The last row set has been retrieved. No need for any more fetch requests. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                                        HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                                    }
                                    this.m_clientCtx.removeAllTasks(hiveOperationContext);
                                    --((HiveMultiSocketFetchContext)object).m_numPendingFetchRequests;
                                    hiveOperationContext = null;
                                    continue;
                                }
                                if (null != ((HiveMultiSocketFetchContext)object).m_hs2BufferWithError || null != ((HiveMultiSocketFetchContext)object).m_fetchException) {
                                    if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                        LogUtilities.logDebug("An error occurred while processing a previous fetch request. No need for any more fetch requests. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                                        HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                                    }
                                    --((HiveMultiSocketFetchContext)object).m_numPendingFetchRequests;
                                    hiveOperationContext = null;
                                    continue;
                                }
                            }
                        }
                        object4 = this.m_hs2BufferFactory.makeHS2Buffer(hiveOperationContext);
                        ((HiveServer2BaseBuffer)object4).setHiveServer2Buffer(this.m_clientWrapper.FetchResults(hiveOperationContext.m_fetchResultsReq));
                        object3 = ((HiveServer2BaseBuffer)object4).getHiveServer2Buffer().getStatus();
                        if (TStatusCode.ERROR_STATUS == ((TStatus)object3).getStatusCode() || TStatusCode.STILL_EXECUTING_STATUS == ((TStatus)object3).getStatusCode() || TStatusCode.INVALID_HANDLE_STATUS == ((TStatus)object3).getStatusCode()) {
                            if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                LogUtilities.logError("An server error occurred when processing a fetch request. Error message: " + ((HiveServer2BaseBuffer)object4).getHiveServer2Buffer().getStatus().getErrorMessage() + " Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                                HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                            }
                            hiveMultiSocketFetchClientContext = this.m_clientCtx;
                            synchronized (hiveMultiSocketFetchClientContext) {
                                object2 = object;
                                synchronized (object2) {
                                    if (null != ((HiveMultiSocketFetchContext)object).m_hs2BufferWithError) {
                                        ((HiveMultiSocketFetchContext)object).m_hs2BufferWithError = object4;
                                    }
                                    this.m_clientCtx.removeAllTasks(hiveOperationContext);
                                    --((HiveMultiSocketFetchContext)object).m_numPendingFetchRequests;
                                    hiveOperationContext = null;
                                    continue;
                                }
                            }
                        }
                        ((HiveServer2BaseBuffer)object4).initializeBuffer();
                        hiveMultiSocketFetchClientContext = this.m_clientCtx;
                        synchronized (hiveMultiSocketFetchClientContext) {
                            object2 = object;
                            synchronized (object2) {
                                List<HiveServer2BaseBuffer> list = ((HiveMultiSocketFetchContext)object).m_orderedRowset;
                                boolean bl3 = false;
                                int n = HiveHS2ClientUtils.getNumRows(((HiveServer2BaseBuffer)object4).getHiveServer2Buffer().getResults(), this.m_logger);
                                if (((HiveServer2BaseBuffer)object4).getHiveServer2Buffer().getResults().isSetResultLinks()) {
                                    TSparkArrowResultLink tSparkArrowResultLink;
                                    int n2 = 0;
                                    Iterator<TSparkArrowResultLink> iterator = ((HiveServer2BaseBuffer)object4).getHiveServer2Buffer().getResults().getResultLinks().iterator();
                                    while (iterator.hasNext() && (n2 = (int)((long)n2 + (tSparkArrowResultLink = iterator.next()).getRowCount())) <= 0) {
                                    }
                                    bl3 = 0 < n2;
                                } else {
                                    boolean bl4 = bl3 = 0 < n;
                                }
                                if (HiveHS2ClientUtils.correctHasMoreRowsResult(this.m_settings, this.m_logger)) {
                                    bl3 = ((HiveServer2BaseBuffer)object4).getHiveServer2Buffer().isHasMoreRows();
                                }
                                if (!bl3) {
                                    if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                        LogUtilities.logDebug("There are no more rows to retrieve, setting the fetched response as the last rowset.  Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                                        HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                                    }
                                    if (null == ((HiveMultiSocketFetchContext)object).m_lastRowset) {
                                        ((HiveMultiSocketFetchContext)object).m_lastRowset = object4;
                                        this.m_clientCtx.removeAllTasks(hiveOperationContext);
                                        --((HiveMultiSocketFetchContext)object).m_numPendingFetchRequests;
                                        hiveOperationContext = null;
                                        continue;
                                    }
                                    if (((HiveMultiSocketFetchContext)object).m_lastRowset.getHiveServer2Buffer().getResults().getStartRowOffset() <= ((HiveServer2BaseBuffer)object4).getHiveServer2Buffer().getResults().getStartRowOffset()) {
                                        this.m_clientCtx.removeAllTasks(hiveOperationContext);
                                        --((HiveMultiSocketFetchContext)object).m_numPendingFetchRequests;
                                        hiveOperationContext = null;
                                        continue;
                                    }
                                }
                                long l2 = ((HiveServer2BaseBuffer)object4).getHiveServer2Buffer().getResults().getStartRowOffset();
                                int n3 = list.size();
                                int n4 = 0;
                                int n5 = 0;
                                while (n5 < n3) {
                                    TRowSet tRowSet = list.get(n5).getHiveServer2Buffer().getResults();
                                    int n6 = HiveHS2ClientUtils.getNumRows(tRowSet, this.m_logger);
                                    long l3 = tRowSet.getStartRowOffset();
                                    long l4 = l3 + (long)n6;
                                    if (l2 >= l3 && l2 < l4) {
                                        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "A processed fetch request row set intersects with an existing row set in the cache.");
                                        throw errorException;
                                    }
                                    ++n5;
                                    if (l2 >= l3) {
                                        ++n4;
                                    }
                                    if (n5 != n4 + 1) continue;
                                    break;
                                }
                                if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                                    LogUtilities.logDebug("A fetched response has been added to the rowset at row offset: " + String.valueOf(l2) + " Num rows: " + String.valueOf(n) + " Pos: " + String.valueOf(n4) + " Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                                    HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                                }
                                list.add(n4, (HiveServer2BaseBuffer)object4);
                                --((HiveMultiSocketFetchContext)object).m_numPendingFetchRequests;
                                hiveOperationContext = null;
                                continue;
                            }
                        }
                    }
                    if (!bl2) continue;
                    bl2 = false;
                    long l5 = System.currentTimeMillis();
                    long l6 = this.m_settings.m_multiSocketFetchIdleHandlerSemaphoreTimeout;
                    if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                        LogUtilities.logDebug("Fetch handler attempting to acquire m_idleHandlerSemaphore. idleStartTime: " + String.valueOf(l5) + " Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                        HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                    }
                    if (!this.m_clientCtx.m_idleHandlerSemaphore.tryAcquire(l6, TimeUnit.MILLISECONDS)) {
                        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                            LogUtilities.logDebug("Timed out before the m_idleHandlerSemaphore was acquired. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                            HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                        }
                    } else if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                        LogUtilities.logDebug("Sucessfully acquired the m_idleHandlerSemaphore. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                        HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                    }
                    if (0L == l6 || 0L < (l -= System.currentTimeMillis() - l5)) continue;
                    if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                        LogUtilities.logDebug("Fetch thread has exceeded the idle time limit. Shutting down. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                        HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                    }
                    this.stop();
                }
            }
            catch (InterruptedException interruptedException) {
                if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                    LogUtilities.logDebug("Thread has been interrupted. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                }
            }
            catch (Throwable throwable) {
                if (null != hiveOperationContext) {
                    HiveMultiSocketFetchContext hiveMultiSocketFetchContext;
                    if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
                        LogUtilities.logError("Caught exception when processing the current fetch request. Error message: " + throwable.getMessage() + " Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
                        HiveHS2ClientUtils.logOperationHandle(hiveOperationContext, this.m_logger);
                    }
                    this.m_clientCtx.removeAllTasks(hiveOperationContext);
                    HiveMultiSocketFetchContext hiveMultiSocketFetchContext2 = hiveMultiSocketFetchContext = hiveOperationContext.m_multiSocketFetchCtx;
                    synchronized (hiveMultiSocketFetchContext2) {
                        if (null == hiveMultiSocketFetchContext.m_fetchException) {
                            hiveOperationContext.m_multiSocketFetchCtx.m_fetchException = throwable;
                        }
                        --hiveMultiSocketFetchContext.m_numPendingFetchRequests;
                        hiveOperationContext = null;
                    }
                }
                if (!this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) break block77;
                LogUtilities.logError("Caught exception when not processing a fetch request. Error message: " + throwable.getMessage() + " Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
            }
        }
        HiveMultiSocketFetchClientContext hiveMultiSocketFetchClientContext = this.m_clientCtx;
        synchronized (hiveMultiSocketFetchClientContext) {
            --this.m_clientCtx.m_numFetchers;
        }
        if (null != this.m_clientWrapper && null != this.m_clientWrapper.getInputProtocol() && null != this.m_clientWrapper.getInputProtocol().getTransport()) {
            this.m_clientWrapper.getInputProtocol().getTransport().close();
        }
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logDebug("Fetch handler is terminating its run. Thread ID: " + String.valueOf(Thread.currentThread().getId()), this.m_logger);
        }
    }

    public void stop() {
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        this.m_isStopSignaled.set(true);
    }

    public boolean isStopSignaled() {
        if (this.m_settings.m_isEnableLoggingInPerformanceCriticalPaths) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        return this.m_isStopSignaled.get();
    }
}

