/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.api.HiveJDBCBrowserServerResponse;
import com.cloudera.impala.hivecommon.api.HiveJDBCOAuthBrowserServerResponse;
import com.cloudera.impala.hivecommon.api.SSOSettings;
import com.cloudera.impala.hivecommon.api.WebConnection;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;

public class OAuthWebConnection
extends WebConnection {
    public OAuthWebConnection(Socket socket, WebConnection.SetValueFunction setValueFunction, ILogger iLogger, SSOSettings sSOSettings) {
        super(socket, setValueFunction, iLogger, sSOSettings);
    }

    @Override
    protected HiveJDBCBrowserServerResponse parseServerResponse(String string) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String[] stringArray = string.split("\r\n");
        if (this.m_settings.m_ssoLogSensitiveInfoForDebug) {
            LogUtilities.logTrace("Response received: " + string, this.m_logger);
        }
        for (String string2 : stringArray) {
            if (string2.contains("GET /?") && string2.contains(" HTTP/1.1")) {
                string2 = string2.substring("GET /?".length(), string2.length() - " HTTP/1.1".length());
            }
            if (string2.isEmpty() || !string2.contains("code=")) continue;
            LogUtilities.logTrace("Parsing code line from server response.", this.m_logger);
            HiveJDBCOAuthBrowserServerResponse hiveJDBCOAuthBrowserServerResponse = new HiveJDBCOAuthBrowserServerResponse(string2, this.m_logger);
            if (this.m_settings.m_ssoLogSensitiveInfoForDebug) {
                LogUtilities.logTrace("Dumping parsed server response: \ncode: " + hiveJDBCOAuthBrowserServerResponse.getCode() + "\nsuccess: " + hiveJDBCOAuthBrowserServerResponse.isSuccessful() + "\nstate: " + hiveJDBCOAuthBrowserServerResponse.getState() + "\n", this.m_logger);
            }
            return hiveJDBCOAuthBrowserServerResponse;
        }
        LogUtilities.logTrace("Response not containing token was parsed.", this.m_logger);
        return null;
    }

    @Override
    protected void sendBrowserMsg(Socket socket, HiveJDBCBrowserServerResponse hiveJDBCBrowserServerResponse) throws IOException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("HTTP/1.0 200 OK");
        arrayList.add("Content-Type: text/html");
        String string = null == hiveJDBCBrowserServerResponse ? "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><link rel=\"icon\" href=\"data:,\"><title>OAuth Response Received</title></head><body>Authentication failed:  Unexpected message format received  Please check server logs for more details. You may close this window.</body></html>" : (hiveJDBCBrowserServerResponse.isSuccessful() ? "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><link rel=\"icon\" href=\"data:,\"><title>OAuth Response Received</title></head><body onload=\"timeoutClose()\">Successfully authenticated. You may close this window.</body><script>function timeoutClose(){   setTimeout(function()   {       window.close()   }, " + this.m_settings.m_browserCloseWaitTime + " );}</script></html>" : "<!DOCTYPE html><html><head><meta charset=\"UTF-8\"/><link rel=\"icon\" href=\"data:,\"><title>OAuth Response Received</title></head><body>Authentication failed:  Please check server logs for more details. You may close this window.</body></html>");
        arrayList.add(String.format("Content-Length: %s", string.length()));
        arrayList.add("");
        arrayList.add(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                printWriter.print("\r\n");
            }
            printWriter.print((String)arrayList.get(i));
        }
        printWriter.flush();
    }
}

