/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.HttpRetrySettings;
import com.cloudera.impala.hivecommon.api.TEHTTPSettings;
import com.cloudera.impala.hivecommon.exceptions.TEHttpRetryException;
import com.cloudera.impala.hivecommon.exceptions.TETokenExpirationException;
import com.cloudera.impala.jdbc.http.extention.ExtendedHttpClient;
import com.cloudera.impala.jdbc42.internal.apache.http.Header;
import com.cloudera.impala.jdbc42.internal.apache.http.HeaderIterator;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpEntity;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpHost;
import com.cloudera.impala.jdbc42.internal.apache.http.HttpResponse;
import com.cloudera.impala.jdbc42.internal.apache.http.client.CookieStore;
import com.cloudera.impala.jdbc42.internal.apache.http.client.HttpClient;
import com.cloudera.impala.jdbc42.internal.apache.http.client.methods.AbstractExecutionAwareRequest;
import com.cloudera.impala.jdbc42.internal.apache.http.client.methods.HttpPost;
import com.cloudera.impala.jdbc42.internal.apache.http.client.methods.HttpRequestBase;
import com.cloudera.impala.jdbc42.internal.apache.http.cookie.Cookie;
import com.cloudera.impala.jdbc42.internal.apache.http.entity.ByteArrayEntity;
import com.cloudera.impala.jdbc42.internal.apache.http.impl.cookie.BasicClientCookie;
import com.cloudera.impala.jdbc42.internal.apache.http.util.EntityUtils;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.THttpClient;
import com.cloudera.impala.jdbc42.internal.apache.thrift.transport.TTransportException;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Map;

public class TETHttpClient
extends THttpClient {
    private static final int HTTP_THRIFT_ERR_CODE_UPPER_BOUND = 600;
    private static final String THRIFT_SERVER_ERROR_HEADER = "X-ThriftServer-Error-Message";
    private static final String TOKEN_ERR_STR = "token";
    private static final String TOKEN_EXP_HEADER_MISSING_MSG = "Authorization related error response returned, but no token expired message received";
    private static final String TOKEN_EXPIRE_ERR_STR = "expire";
    private static final String UNKNOWN_HEADER_ERR_MSG = "Unknown";
    private static final String JWT_ERR_STR = "JWT";
    private URL m_url = null;
    private final ByteArrayOutputStream m_requestBuffer = new ByteArrayOutputStream();
    private InputStream m_inputStream = null;
    private int m_connectTimeout = 0;
    private int m_readTimeout = 0;
    private final HttpHost m_host;
    private final HttpClient m_client;
    protected TEHTTPSettings m_settings;
    private ILogger m_logger;
    private CookieStore m_cookieStore;

    public TETHttpClient(String string) throws TTransportException {
        super(string);
        try {
            this.m_url = new URL(string);
            this.m_client = null;
            this.m_host = null;
            this.m_settings = new TEHTTPSettings();
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    public TETHttpClient(String string, HttpClient httpClient, TEHTTPSettings tEHTTPSettings, ILogger iLogger) throws TTransportException {
        super(string, httpClient);
        try {
            this.m_logger = iLogger;
            this.m_url = new URL(string);
            this.m_client = httpClient;
            this.m_host = new HttpHost(this.m_url.getHost(), -1 == this.m_url.getPort() ? this.m_url.getDefaultPort() : this.m_url.getPort(), this.m_url.getProtocol());
            this.m_settings = tEHTTPSettings;
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    public TETHttpClient(String string, HttpClient httpClient, TEHTTPSettings tEHTTPSettings, CookieStore cookieStore, ILogger iLogger) throws TTransportException {
        this(string, httpClient, tEHTTPSettings, iLogger);
        this.m_cookieStore = cookieStore;
    }

    @Override
    public void close() {
        try {
            if (null != this.m_inputStream) {
                this.m_inputStream.close();
                this.m_inputStream = null;
            }
            if (this.m_client instanceof ExtendedHttpClient) {
                ((ExtendedHttpClient)this.m_client).close();
            }
        }
        catch (IOException iOException) {
            LogUtilities.logWarning(iOException, this.m_logger);
        }
    }

    public String extractThriftHeaderError(HttpResponse httpResponse) {
        return this.extractThriftHeaderError(httpResponse, false);
    }

    public String extractThriftHeaderError(HttpResponse httpResponse, boolean bl) {
        Header header = httpResponse.getFirstHeader(THRIFT_SERVER_ERROR_HEADER);
        String string = null != header ? header.getValue() : (bl ? TOKEN_EXP_HEADER_MISSING_MSG : UNKNOWN_HEADER_ERR_MSG);
        return this.createResponseErrorMessage(httpResponse, string);
    }

    @Override
    public void flush() throws TTransportException {
        if (null != this.m_client) {
            this.flushUsingHttpClient();
            return;
        }
        byte[] byArray = this.m_requestBuffer.toByteArray();
        this.m_requestBuffer.reset();
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.m_url.openConnection();
            if (this.m_connectTimeout > 0) {
                httpURLConnection.setConnectTimeout(this.m_connectTimeout);
            }
            if (this.m_readTimeout > 0) {
                httpURLConnection.setReadTimeout(this.m_readTimeout);
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/x-thrift");
            httpURLConnection.setRequestProperty("Accept", "application/x-thrift");
            httpURLConnection.setRequestProperty("User-Agent", this.m_settings.m_userAgentEntry);
            if (null != this.m_settings.getCustomHeaders()) {
                for (Map.Entry<String, String> entry : this.m_settings.getCustomHeaders().entrySet()) {
                    httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            httpURLConnection.setDoOutput(true);
            httpURLConnection.connect();
            httpURLConnection.getOutputStream().write(byArray);
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                throw new TTransportException("HTTP Response code: " + n);
            }
            this.m_inputStream = httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    public Cookie getCookie(String string) {
        if (this.m_cookieStore != null) {
            for (Cookie cookie : this.m_cookieStore.getCookies()) {
                if (!string.equalsIgnoreCase(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public CookieStore getCookieStore() {
        return this.m_cookieStore;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws TTransportException {
        if (this.m_inputStream == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        try {
            int n3 = this.m_inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new TTransportException("No more data available.");
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new TTransportException(iOException);
        }
    }

    public void removeCookie(String string) {
        Cookie cookie = this.getCookie(string);
        if (null != cookie) {
            BasicClientCookie basicClientCookie = new BasicClientCookie(cookie.getName(), cookie.getName());
            Date date = new Date();
            basicClientCookie.setExpiryDate(date);
            this.m_cookieStore.addCookie(basicClientCookie);
            this.m_cookieStore.clearExpired(date);
        }
    }

    public String removeCustomHeader(String string) {
        return this.m_settings.removeCustomHeader(string);
    }

    @Override
    public void setConnectTimeout(int n) {
        this.m_connectTimeout = n;
        super.setConnectTimeout(n);
    }

    @Override
    public void setCustomHeaders(Map<String, String> map) {
        this.m_settings.setCustomHeaders(map);
    }

    @Override
    public void setCustomHeader(String string, String string2) {
        this.m_settings.addCustomHeader(string, string2);
    }

    @Override
    public void setReadTimeout(int n) {
        this.m_readTimeout = n;
        super.setReadTimeout(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        this.m_requestBuffer.write(byArray, n, n2);
    }

    private HttpPost buildPostRequest(byte[] byArray) {
        HttpPost httpPost = new HttpPost(this.m_url.getFile());
        httpPost.setHeader("Content-Type", "application/x-thrift");
        httpPost.setHeader("Accept", "application/x-thrift");
        httpPost.setHeader("User-Agent", this.m_settings.m_userAgentEntry);
        if (null != this.m_settings.getCustomHeaders()) {
            for (Map.Entry<String, String> entry : this.m_settings.getCustomHeaders().entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPost.setEntity(new ByteArrayEntity(byArray));
        return httpPost;
    }

    private static void consume(HttpEntity httpEntity) throws IOException {
        InputStream inputStream;
        if (httpEntity == null) {
            return;
        }
        if (httpEntity.isStreaming() && (inputStream = httpEntity.getContent()) != null) {
            inputStream.close();
        }
    }

    private String createResponseErrorMessage(HttpResponse httpResponse, String string) {
        String string2 = "";
        String string3 = string;
        if (this.m_settings.m_retrieveErrorFromBody) {
            try {
                string2 = EntityUtils.toString(httpResponse.getEntity(), "UTF-8");
                if (UNKNOWN_HEADER_ERR_MSG.equals(string3)) {
                    string3 = "";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!string2.isEmpty() && !string3.isEmpty()) {
            if (string2.endsWith(".")) {
                string2 = string2 + ".";
            }
            string2 = string2 + " ";
        }
        String string4 = "HTTP Response code: " + httpResponse.getStatusLine().getStatusCode() + ", Error message: " + string2 + string3;
        return string4;
    }

    private void flushUsingHttpClient() throws TTransportException {
        if (null == this.m_client) {
            throw new TTransportException("Null HttpClient, aborting.");
        }
        byte[] byArray = this.m_requestBuffer.toByteArray();
        this.m_requestBuffer.reset();
        AbstractExecutionAwareRequest abstractExecutionAwareRequest = null;
        InputStream inputStream = null;
        HttpResponse httpResponse = null;
        try {
            if (null != this.m_settings.m_currentHttpErrorEmulationSettings) {
                httpResponse = this.m_settings.m_currentHttpErrorEmulationSettings.populateEmulatedHttpResponse();
            } else {
                abstractExecutionAwareRequest = this.buildPostRequest(byArray);
                httpResponse = this.m_client.execute(this.m_host, abstractExecutionAwareRequest);
            }
            int n = httpResponse.getStatusLine().getStatusCode();
            inputStream = httpResponse.getEntity().getContent();
            if (n != 200) {
                this.handleErrorResponse(httpResponse);
            }
            byte[] byArray2 = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            do {
                if ((n2 = inputStream.read(byArray2)) <= 0) continue;
                byteArrayOutputStream.write(byArray2, 0, n2);
            } while (-1 != n2);
            try {
                TETHttpClient.consume(httpResponse.getEntity());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            if (null != abstractExecutionAwareRequest) {
                abstractExecutionAwareRequest.abort();
            }
            throw new TTransportException(iOException);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LogUtilities.logWarning(iOException, this.m_logger);
                }
            }
            if (null != abstractExecutionAwareRequest) {
                ((HttpRequestBase)abstractExecutionAwareRequest).releaseConnection();
            }
        }
    }

    protected void handleErrorResponse(HttpResponse httpResponse) throws TTransportException {
        int n = httpResponse.getStatusLine().getStatusCode();
        for (HttpRetrySettings httpRetrySettings : this.m_settings.m_httpRetrySettingsList) {
            if (!httpRetrySettings.shouldRetryWithHttpCode(this.m_settings.m_currentAPICall, this.m_settings.m_currentQuery, n)) continue;
            throw new TEHttpRetryException(httpResponse, this.extractThriftHeaderError(httpResponse));
        }
        if (n < 400 || n >= 600) {
            throw new TTransportException("HTTP Response code: " + n);
        }
        this.handleHeaderErrorMessage(httpResponse);
    }

    private void handleHeaderErrorMessage(HttpResponse httpResponse) throws TTransportException {
        boolean bl;
        boolean bl2 = bl = this.m_settings.m_isOAuth && this.isAuthenticationError(httpResponse.getStatusLine().getStatusCode());
        if (bl) {
            this.handleTokenExpirationError(httpResponse);
        }
        throw new TTransportException(this.extractThriftHeaderError(httpResponse, bl));
    }

    private void handleTokenExpirationError(HttpResponse httpResponse) throws TETokenExpirationException {
        HeaderIterator headerIterator = httpResponse.headerIterator();
        while (headerIterator.hasNext()) {
            Header header = headerIterator.nextHeader();
            if (!header.getValue().contains(TOKEN_ERR_STR) && !header.getValue().contains(JWT_ERR_STR) || !header.getValue().contains(TOKEN_EXPIRE_ERR_STR)) continue;
            throw new TETokenExpirationException(this.createResponseErrorMessage(httpResponse, header.getValue()));
        }
    }

    private boolean isAuthenticationError(int n) {
        switch (n) {
            case 400: 
            case 401: 
            case 403: {
                return true;
            }
        }
        return false;
    }
}

