/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.jdbc42;

import com.cloudera.impala.dsi.dataengine.interfaces.IDataEngine;
import com.cloudera.impala.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.impala.dsi.dataengine.utilities.OrderType;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.hivecommon.jdbc42.Hive42MetaDataProxy;
import com.cloudera.impala.jdbc.common.SConnection;
import com.cloudera.impala.jdbc.jdbc42.S42DatabaseMetaData;
import com.cloudera.impala.support.ILogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Hive42DatabaseMetaData
extends S42DatabaseMetaData {
    SConnection parent_Conn;

    public Hive42DatabaseMetaData(SConnection sConnection, ILogger iLogger) throws SQLException {
        super(sConnection, iLogger);
        this.parent_Conn = sConnection;
    }

    @Override
    protected synchronized ResultSet createMetaDataResult(MetadataSourceID metadataSourceID, List<String> list) throws SQLException {
        try {
            IResultSet iResultSet = ((IDataEngine)this.m_dataEngine).makeNewMetadataResult(metadataSourceID, (ArrayList)list, this.getSearchStringEscape(), this.getIdentifierQuoteString(), false, OrderType.JDBC_42);
            Hive42MetaDataProxy hive42MetaDataProxy = new Hive42MetaDataProxy(this, iResultSet, metadataSourceID, (HiveJDBCStatement)this.m_parentStatement, this.parent_Conn, this.m_logger);
            this.m_resultSets.add(hive42MetaDataProxy);
            return hive42MetaDataProxy;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }
}

