/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.impala.core;

import com.cloudera.impala.dsi.core.interfaces.IEnvironment;
import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.core.utilities.ConnSettingResponseMap;
import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.hivecommon.AuthMech;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.HiveServerType;
import com.cloudera.impala.hivecommon.HttpRetrySettings;
import com.cloudera.impala.hivecommon.HttpRetryType;
import com.cloudera.impala.hivecommon.TransportMode;
import com.cloudera.impala.hivecommon.WholeNumberIntervalList;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.dataengine.IHiveCustomScalarFnFactory;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.impala.core.ImpalaJDBCEnvironment;
import com.cloudera.impala.impala.core.ImpalaJDBCServerVersionUtils;
import com.cloudera.impala.impala.dataengine.ImpalaCustomScalarHelper;
import com.cloudera.impala.jdbc.common.OAuthFlow;
import com.cloudera.impala.jdbc.common.OAuthSettings;
import com.cloudera.impala.jdbc.common.ProductInfoHandler;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;

public class ImpalaJDBCDSIConnection
extends HiveJDBCCommonConnection {
    static final String CLOUDERA_HOSTSUFFIX = ".cloudera.site";
    private static int IMPALA_DEFAULT_MAX_HTTP_RETRY_TIME = 3;
    private static int IMPALA_DEFAULT_MIN_HTTP_RETRY_TIME_INTERVAL = 1;
    private static int IMPALA_DEFAULT_HTTP_RETRY_TIMEOUT = -1;
    private static boolean IMPALA_DEFAULT_HTTP_RETRY_OVERRIDE_RETRY_AFTER_TIME = true;
    private static boolean IMPALA_DEFAULT_HTTP_INCREASE_RETRY_INTERVAL_AFTER_EACH_RETRY = true;
    private static int HTTP_CODE_UNAUTHORIZED = 401;
    private static int HTTP_CODE_FORBIDDEN = 403;
    private static int IMPALA_DEFAULT_HTTP_RETRY_CODE_MIN = 300;
    private static int IMPALA_DEFAULT_HTTP_RETRY_CODE_MAX = 999;

    public ImpalaJDBCDSIConnection(IEnvironment iEnvironment) throws ErrorException {
        super(iEnvironment);
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), iEnvironment);
    }

    @Override
    public void establishConnection(ConnSettingRequestMap connSettingRequestMap, int n) throws ErrorException {
        super.establishConnection(connSettingRequestMap, n);
        this.m_settings.m_optimizedInsert = true;
        Variant variant = this.getOptionalSetting("OptimizedInsert", connSettingRequestMap);
        if (null != variant) {
            try {
                if (variant.getInt() == 1) {
                    this.m_settings.m_optimizedInsert = true;
                } else if (variant.getInt() == 0) {
                    this.m_settings.m_optimizedInsert = false;
                } else {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_OPTIMIZED_INSERT_ERROR.name()));
                }
            }
            catch (Exception exception) {
                this.m_settings.m_optimizedInsert = true;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_OPTIMIZED_INSERT_ERROR.name()));
            }
        }
        this.m_definedSettings.put("CastStringLiteralsForInsert", true);
        variant = this.getOptionalSetting("CastStringLiteralsForInsert", connSettingRequestMap);
        int n2 = -1;
        if (null != variant) {
            block24: {
                try {
                    n2 = variant.getInt();
                }
                catch (Exception exception) {
                    if (null == this.getWarningListener()) break block24;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant.getString(), "CastStringLiteralsForInsert"}));
                }
            }
            if (1 == n2) {
                this.m_settings.m_castStringLiteralForInsert = true;
            }
            if (0 == n2) {
                this.m_settings.m_castStringLiteralForInsert = false;
            }
        } else {
            this.m_settings.m_castStringLiteralForInsert = true;
        }
        this.m_definedSettings.put("CastStringParamsForInsert", true);
        variant = this.getOptionalSetting("CastStringParamsForInsert", connSettingRequestMap);
        n2 = -1;
        if (null != variant) {
            block25: {
                try {
                    n2 = variant.getInt();
                }
                catch (Exception exception) {
                    if (null == this.getWarningListener()) break block25;
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR.name(), new String[]{variant.getString(), "CastStringParamsForInsert"}));
                }
            }
            if (1 == n2) {
                this.m_settings.m_castStringParamsForInsert = true;
            }
            if (0 == n2) {
                this.m_settings.m_castStringParamsForInsert = false;
            }
        } else {
            this.m_settings.m_castStringParamsForInsert = true;
        }
        this.m_settings.m_supportTimeOnlyTimestamp = true;
        variant = this.getOptionalSetting("SupportTimeOnlyTimestamp", connSettingRequestMap);
        if (null != variant) {
            try {
                if (0 == variant.getInt()) {
                    this.m_settings.m_supportTimeOnlyTimestamp = false;
                } else {
                    this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SUPPORT_TIME_ONLY_TIMESTAMP_TYPE_ERR.name()));
                }
            }
            catch (Exception exception) {
                this.m_settings.m_optimizedInsert = true;
                this.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.CONN_SUPPORT_TIME_ONLY_TIMESTAMP_ERR.name()));
            }
        }
        this.m_definedSettings.put("CastEmptyStringsForInsert", true);
        this.m_settings.m_castEmptyStringsForInsert = this.readOptionalBooleanSetting(connSettingRequestMap, "CastEmptyStringsForInsert", false, HiveJDBCMessageKey.CONN_INVALID_CONN_PROP_VAL_ERR);
    }

    @Override
    protected boolean isPortRequired() {
        return false;
    }

    @Override
    protected void setImplementationDefaultSettings() {
        this.m_settings.m_platformVersionUtils = new ImpalaJDBCServerVersionUtils();
        this.m_settings.m_platformDefaultUID = "impala";
        this.m_settings.m_platformDelegationUIDPropertyKey = "impala.doas.user";
        this.m_settings.m_platformCatalog = "Impala";
        this.m_settings.m_dbmsName = "Impala";
        this.m_settings.m_enableDirectResults = false;
        this.m_settings.m_thriftHTTPSettings.m_enableSessionTag = false;
        this.m_settings.m_setKeyValueQueryResultSet = true;
        this.m_settings.m_cteQueryResultSet = false;
        this.m_settings.m_thriftHTTPSettings.m_retrieveErrorFromBody = true;
        this.m_settings.m_supportsNumRowsModified = false;
        this.m_settings.m_unrecognizedStmtReturnsQueryResult = false;
        this.m_settings.m_idleHttpConnectionExpiry = 15;
    }

    @Override
    protected void setSupportedHttpRetryType() {
        this.m_settings.m_supportedHttpRetryType = new ArrayList();
        WholeNumberIntervalList wholeNumberIntervalList = new WholeNumberIntervalList();
        wholeNumberIntervalList.AddInterval(IMPALA_DEFAULT_HTTP_RETRY_CODE_MIN, IMPALA_DEFAULT_HTTP_RETRY_CODE_MAX);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("FetchResults");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("INSERT");
        arrayList2.add("DELETE");
        arrayList2.add("CREATE");
        arrayList2.add("DROP");
        HttpRetryType httpRetryType = new HttpRetryType("HTTPRetry", IMPALA_DEFAULT_MAX_HTTP_RETRY_TIME, IMPALA_DEFAULT_MIN_HTTP_RETRY_TIME_INTERVAL, IMPALA_DEFAULT_HTTP_RETRY_TIMEOUT, IMPALA_DEFAULT_HTTP_INCREASE_RETRY_INTERVAL_AFTER_EACH_RETRY, IMPALA_DEFAULT_HTTP_RETRY_OVERRIDE_RETRY_AFTER_TIME, wholeNumberIntervalList, arrayList, arrayList2);
        this.m_settings.m_supportedHttpRetryType.add(httpRetryType);
        this.m_definedSettings.put("HTTPRetry", true);
        for (String string : httpRetryType.getAllKeyPostfixes()) {
            this.m_definedSettings.put("HTTPRetry" + string, true);
        }
    }

    @Override
    protected ProductInfoHandler getProductInfoHandler() {
        String string = null;
        try {
            Variant variant = this.getProperty(170);
            string = variant.getString();
        }
        catch (Exception exception) {
            string = "";
        }
        return new ProductInfoHandler("SimbaApacheImpalaJDBCDriver.lic", "Simba Apache Impala JDBC Driver", string, HiveJDBCCommonDriver.class);
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_log) {
            return ((ImpalaJDBCEnvironment)this.getParentEnvironment()).getLog();
        }
        return this.m_log;
    }

    @Override
    protected void setDriverSpecificSettings() {
        this.m_settings.m_stringColumnSize = Short.MAX_VALUE;
        this.m_settings.m_useCustomTimestampConverter = false;
        this.m_settings.m_isEnableDataWrapperMaterialization = true;
        this.m_settings.m_isStoreIntegerAsLong = false;
        this.m_settings.m_isAutoReconnect = true;
        if (this.m_settings.m_authMech == AuthMech.OAUTH_2) {
            for (HttpRetrySettings httpRetrySettings : this.m_settings.m_thriftHTTPSettings.m_httpRetrySettingsList) {
                httpRetrySettings.m_codeRanges = new WholeNumberIntervalList();
                httpRetrySettings.m_codeRanges.AddInterval(IMPALA_DEFAULT_HTTP_RETRY_CODE_MIN, HTTP_CODE_UNAUTHORIZED - 1);
                httpRetrySettings.m_codeRanges.AddInterval(HTTP_CODE_UNAUTHORIZED + 1, HTTP_CODE_UNAUTHORIZED + 1);
                httpRetrySettings.m_codeRanges.AddInterval(HTTP_CODE_FORBIDDEN + 1, IMPALA_DEFAULT_HTTP_RETRY_CODE_MAX);
            }
        }
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap, ConnSettingResponseMap connSettingResponseMap) {
        boolean bl = false;
        this.verifyOptionalSetting("LowerCaseResultSetColumnName", connSettingRequestMap, connSettingResponseMap);
        this.verifyRequiredSetting("HiveServerType", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("OptimizedInsert", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("UseSasl", connSettingRequestMap, connSettingResponseMap);
        this.verifyOptionalSetting("SupportTimeOnlyTimestamp", connSettingRequestMap, connSettingResponseMap);
        if (null == hiveJDBCSettings.m_authMech) {
            hiveJDBCSettings.m_authMech = AuthMech.NOAUTH;
        } else {
            bl = true;
        }
        if (HiveServerType.HiveServer2 == hiveJDBCSettings.m_hiveServerType) {
            if (AuthMech.NOAUTH_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = true;
            }
            if (AuthMech.SASL_PLAIN_UIDPWD_SSL == hiveJDBCSettings.m_authMech) {
                hiveJDBCSettings.m_serverSSLSettings.m_enableSSL = true;
                hiveJDBCSettings.m_authMech = AuthMech.UIDPWD;
            }
            if (AuthMech.UIDPWD == hiveJDBCSettings.m_authMech) {
                if (bl) {
                    this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    this.verifyRequiredSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                    this.verifyOptionalSetting("PWD", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_PLAIN_UID == hiveJDBCSettings.m_authMech) {
                if (bl) {
                    this.verifyRequiredSetting("UID", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("UID", connSettingRequestMap, connSettingResponseMap);
                }
            }
            if (AuthMech.SASL_KERBEROS == hiveJDBCSettings.m_authMech) {
                this.verifyOptionalSetting("KrbRealm", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbHostFQDN", connSettingRequestMap, connSettingResponseMap);
                this.verifyRequiredSetting("KrbServiceName", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("krbAuthType", connSettingRequestMap, connSettingResponseMap);
            }
            if (hiveJDBCSettings.m_serverSSLSettings.m_enableSSL) {
                this.verifyOptionalSetting("SSLKeyStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLKeyStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStore", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("SSLTrustStorePwd", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("AllowSelfSignedCerts", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("CAIssuedCertNamesMismatch", connSettingRequestMap, connSettingResponseMap);
            }
        }
        return connSettingResponseMap;
    }

    @Override
    protected String getConnectionLogFileName() {
        return "Impala_connection_";
    }

    @Override
    protected void doReset() throws ErrorException {
        this.setImplementationDefaultSettings();
    }

    @Override
    public IHiveCustomScalarFnFactory getScalarFnHelper() {
        return new ImpalaCustomScalarHelper();
    }

    @Override
    protected boolean setAuthSourceSpecificSettings(HiveJDBCSettings hiveJDBCSettings, ConnSettingRequestMap connSettingRequestMap) {
        int n = CLOUDERA_HOSTSUFFIX.length();
        if (this.checkHostConnectionMatch(hiveJDBCSettings.m_host, n, CLOUDERA_HOSTSUFFIX)) {
            hiveJDBCSettings.m_oAuthSettings.m_authSource = OAuthSettings.OAuthSource.STANDARD;
            if (hiveJDBCSettings.m_oAuthSettings.m_authFlow == OAuthFlow.CLIENT_CREDENTIALS) {
                hiveJDBCSettings.m_oAuthSettings.m_authScope = this.readOptionalStringSetting(connSettingRequestMap, "OAuth2ConnAuthAuthscopeKey", null);
            }
            return true;
        }
        return super.setAuthSourceSpecificSettings(hiveJDBCSettings, connSettingRequestMap);
    }

    @Override
    protected void setDefaultProperties() throws ErrorException {
        super.setDefaultProperties();
        try {
            this.setProperty(1012, new Variant(5, (short)1));
        }
        catch (Exception exception) {
            throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DEFAULT_PROP_SETTING_ERR.name(), exception.getMessage());
        }
    }

    @Override
    protected void setDefaultPort() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.m_settings.m_port = TransportMode.HTTP == this.m_settings.m_transportMode ? 28000 : 21050;
    }
}

