/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.common;

import com.cloudera.impala.dsi.core.impl.DSIDriver;
import com.cloudera.impala.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.impala.dsi.dataengine.utilities.CursorType;
import com.cloudera.impala.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.impala.dsi.utilities.DSIMessageKey;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.exceptions.ErrorException;

public abstract class CommonResultSet
implements IResultSet {
    private int m_fetchSize;
    private boolean m_hasStartedFetch = false;
    private int m_currentRow = 0;
    private IWarningListener m_warningListener = null;

    protected CommonResultSet() {
    }

    @Override
    public void appendRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public void close() {
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.m_hasStartedFetch = false;
        this.m_currentRow = 0;
        this.doCloseCursor();
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public int getFetchSize() throws ErrorException {
        return this.m_fetchSize;
    }

    public IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
            this.m_currentRow = 0;
        } else {
            ++this.m_currentRow;
        }
        return this.doMoveToNextRow();
    }

    @Override
    public void onFinishRowUpdate() {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void setCursorType(CursorType cursorType) throws ErrorException {
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
    }

    @Override
    public void setFetchSize(int n) throws ErrorException {
        this.m_fetchSize = n;
    }

    @Override
    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    protected abstract void doCloseCursor() throws ErrorException;

    protected abstract boolean doMoveToNextRow() throws ErrorException;

    protected int getCurrentRow() {
        return this.m_currentRow;
    }
}

