/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.common;

import com.cloudera.impala.dsi.core.interfaces.IConnection;
import com.cloudera.impala.dsi.dataengine.interfaces.future.IJDBCArray;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.exceptions.JDBCMessageKey;
import com.cloudera.impala.jdbc.interfaces.IConnectionHandle;
import com.cloudera.impala.jdbc.interfaces.IDatabaseMetaData;
import com.cloudera.impala.jdbc.interfaces.IJDBCConnection;
import com.cloudera.impala.jdbc.interfaces.IJDBCPreparedStatement;
import com.cloudera.impala.jdbc.interfaces.IJDBCStatement;
import com.cloudera.impala.jdbc.interfaces.IPooledConnection;
import com.cloudera.impala.support.exceptions.ExceptionType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class PooledConnObjectHandler<T>
implements InvocationHandler {
    private static final Class<?>[] s_interfacesToWrap = new Class[]{ResultSet.class, IJDBCArray.class, Blob.class, Clob.class, NClob.class, SQLXML.class, Struct.class};
    private final T m_wrapped;
    private final IPooledConnection m_pooledConn;
    private final IConnection m_dsiConn;
    private final ConnectionHandler m_parentConn;
    private final PreparedStatementHandler m_parentStmt;

    public static IConnectionHandle wrapConnection(IJDBCConnection iJDBCConnection, IPooledConnection iPooledConnection) {
        return (IConnectionHandle)Proxy.newProxyInstance(iJDBCConnection.getClass().getClassLoader(), PooledConnObjectHandler.getInterfaces(IConnectionHandle.class, iJDBCConnection, new Class[0]), (InvocationHandler)new ConnectionHandler(iJDBCConnection, iPooledConnection));
    }

    private static <S> Class<?>[] getInterfaces(Class<S> clazz, Object object, Class<?> ... classArray) {
        ArrayList arrayList = new ArrayList(Arrays.asList(object.getClass().getInterfaces()));
        arrayList.remove(clazz);
        arrayList.add(0, clazz);
        for (Class<?> clazz2 : classArray) {
            arrayList.remove(clazz2);
            arrayList.add(0, clazz2);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    protected PooledConnObjectHandler(T t, IPooledConnection iPooledConnection, IConnection iConnection, ConnectionHandler connectionHandler) {
        this(t, iPooledConnection, iConnection, connectionHandler, null);
    }

    protected PooledConnObjectHandler(T t, IPooledConnection iPooledConnection, IConnection iConnection, ConnectionHandler connectionHandler, PreparedStatementHandler preparedStatementHandler) {
        if (t == null || iPooledConnection == null || iConnection == null) {
            throw null;
        }
        if (this instanceof ConnectionHandler) {
            assert (connectionHandler == null);
            connectionHandler = (ConnectionHandler)this;
        } else if (this instanceof PreparedStatementHandler) {
            assert (preparedStatementHandler == null);
            preparedStatementHandler = (PreparedStatementHandler)this;
        }
        this.m_wrapped = t;
        this.m_pooledConn = iPooledConnection;
        this.m_dsiConn = iConnection;
        this.m_parentConn = connectionHandler;
        this.m_parentStmt = preparedStatementHandler;
    }

    protected final T getWrapped() {
        return this.m_wrapped;
    }

    protected final IPooledConnection getPooledConnection() {
        return this.m_pooledConn;
    }

    protected final IConnection getDSIConnection() {
        return this.m_dsiConn;
    }

    protected final ConnectionHandler getParentConn() {
        return this.m_parentConn;
    }

    protected final PreparedStatementHandler getParentStmt() {
        return this.m_parentStmt;
    }

    protected final boolean isCloseMethod(Method method, Object[] objectArray) {
        return method.getName() == "close" && (objectArray == null || objectArray.length == 0);
    }

    protected final boolean isIsClosedMethod(Method method, Object[] objectArray) {
        return method.getName() == "isClosed" && (objectArray == null || objectArray.length == 0);
    }

    protected void invokeCloseMethod(Method method, Object[] objectArray) throws Throwable {
        assert (this.isCloseMethod(method, objectArray));
        this.invokeOnWrapped(method, objectArray);
    }

    protected final Object invokeOnWrapped(Method method, Object[] objectArray) throws Throwable {
        try {
            return method.invoke(this.m_wrapped, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.onWrappedException(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private Throwable onWrappedException(Throwable throwable) throws SQLException {
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            try {
                if (this.getParentStmt() != null) {
                    this.getParentStmt().handleException(sQLException);
                }
            }
            finally {
                this.getParentConn().handleException(sQLException);
            }
        }
        return throwable;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (this.isCloseMethod(method, objectArray)) {
            this.invokeCloseMethod(method, objectArray);
            return null;
        }
        return this.wrapCommon(this.invokeOnWrapped(method, objectArray));
    }

    protected <S> S wrap(Class<S> clazz, Object object) {
        if (object == null) {
            throw null;
        }
        return clazz.cast(Proxy.newProxyInstance(object.getClass().getClassLoader(), PooledConnObjectHandler.getInterfaces(clazz, object, new Class[0]), new PooledConnObjectHandler<S>(clazz.cast(object), this.getPooledConnection(), this.getDSIConnection(), this.getParentConn(), this.getParentStmt())));
    }

    private Object wrapCommon(Object object) {
        if (object != null) {
            for (Class<?> clazz : s_interfacesToWrap) {
                if (!clazz.isInstance(object)) continue;
                return this.wrap(clazz, object);
            }
        }
        return object;
    }

    private static class PreparedStatementHandler
    extends PooledConnObjectHandler<IJDBCPreparedStatement> {
        private boolean m_isClosed = false;

        public PreparedStatementHandler(IJDBCPreparedStatement iJDBCPreparedStatement, IPooledConnection iPooledConnection, IConnection iConnection, ConnectionHandler connectionHandler) {
            super(iJDBCPreparedStatement, iPooledConnection, iConnection, connectionHandler);
        }

        @Override
        protected void invokeCloseMethod(Method method, Object[] objectArray) throws Throwable {
            if (!this.m_isClosed) {
                try {
                    this.getPooledConnection().onHandleStatementClose((PreparedStatement)this.getWrapped());
                }
                finally {
                    this.m_isClosed = true;
                }
            }
        }

        public void handleException(SQLException sQLException) throws SQLException {
            if (!this.m_isClosed && ((IJDBCPreparedStatement)this.getWrapped()).isClosed()) {
                try {
                    this.getPooledConnection().onHandleStatementError((PreparedStatement)this.getWrapped(), sQLException);
                }
                finally {
                    this.m_isClosed = true;
                }
            }
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (this.m_isClosed && !this.isCloseMethod(method, objectArray)) {
                if (this.isIsClosedMethod(method, objectArray)) {
                    return Boolean.TRUE;
                }
                if (method.getDeclaringClass() != Object.class) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STATEMENT_CLOSED, ((IJDBCPreparedStatement)this.getWrapped()).getWarningListener(), ExceptionType.NON_TRANSIENT, new Object[0]);
                }
            }
            return super.invoke(object, method, objectArray);
        }
    }

    private static class ConnectionHandler
    extends PooledConnObjectHandler<IJDBCConnection> {
        private static final Method s_getMetaDataMethod;
        private static final Method s_openMethod;
        private static final Method s_forceCloseMethod;
        private final AtomicBoolean m_isClosed = new AtomicBoolean(true);
        private volatile IDatabaseMetaData m_databaseMetadata = null;

        public ConnectionHandler(IJDBCConnection iJDBCConnection, IPooledConnection iPooledConnection) {
            super(iJDBCConnection, iPooledConnection, iJDBCConnection.getDSIConnection(), null);
        }

        public void handleException(SQLException sQLException) throws SQLException {
            if (!this.getDSIConnection().isAlive() && !this.m_isClosed.getAndSet(true)) {
                this.getPooledConnection().onHandleError(sQLException);
            }
        }

        @Override
        protected void invokeCloseMethod(Method method, Object[] objectArray) throws Throwable {
            if (!this.m_isClosed.getAndSet(true)) {
                try {
                    ((IJDBCConnection)this.getWrapped()).closeChildObjects();
                }
                finally {
                    this.getPooledConnection().onHandleClose();
                }
            }
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Class<?> clazz;
            if (method.equals(s_openMethod)) {
                if (!this.m_isClosed.getAndSet(false)) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_OPEN, ((IJDBCConnection)this.getWrapped()).getWarningListener(), ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
                }
                return null;
            }
            if (method.equals(s_forceCloseMethod)) {
                ((IJDBCConnection)this.getWrapped()).close();
                return null;
            }
            if (this.m_isClosed.get()) {
                if (this.isCloseMethod(method, objectArray)) {
                    return null;
                }
                if (this.isIsClosedMethod(method, objectArray)) {
                    return Boolean.TRUE;
                }
                if (method.getDeclaringClass() != Object.class) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, ((IJDBCConnection)this.getWrapped()).getWarningListener(), this.getExceptionTypeForCloseException(method, objectArray), new Object[0]);
                }
                return method.invoke(this.getWrapped(), objectArray);
            }
            if (method.equals(s_getMetaDataMethod)) {
                if (this.m_databaseMetadata == null) {
                    this.m_databaseMetadata = this.wrap(IDatabaseMetaData.class, super.invoke(object, method, objectArray));
                }
                return this.m_databaseMetadata;
            }
            Object object2 = super.invoke(object, method, objectArray);
            if (object2 != null && method.getDeclaringClass().equals(Connection.class) && Statement.class.isAssignableFrom(clazz = method.getReturnType())) {
                assert (IJDBCStatement.class.isAssignableFrom(object2.getClass()));
                if (PreparedStatement.class.isAssignableFrom(clazz)) {
                    assert (IJDBCPreparedStatement.class.isAssignableFrom(object2.getClass()));
                    object2 = Proxy.newProxyInstance(object2.getClass().getClassLoader(), PooledConnObjectHandler.getInterfaces(IJDBCPreparedStatement.class, object2, new Class[]{clazz}), (InvocationHandler)new PreparedStatementHandler((IJDBCPreparedStatement)object2, this.getPooledConnection(), this.getDSIConnection(), this));
                } else {
                    object2 = this.wrap(IJDBCStatement.class, object2);
                }
            }
            return object2;
        }

        private ExceptionType getExceptionTypeForCloseException(Method method, Object[] objectArray) {
            if (method.getDeclaringClass() == Connection.class && method.getName() == "setClientInfo") {
                return ExceptionType.CLIENT_INFO;
            }
            return ExceptionType.NON_TRANSIENT_CONNECTION;
        }

        static {
            try {
                s_getMetaDataMethod = Connection.class.getDeclaredMethod("getMetaData", new Class[0]);
                s_openMethod = IConnectionHandle.class.getDeclaredMethod("open", new Class[0]);
                s_forceCloseMethod = IConnectionHandle.class.getDeclaredMethod("forceClose", new Class[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

