/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.jdbc41.future;

import com.cloudera.impala.dsi.core.interfaces.IStatement;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.jdbc.common.SConnection;
import com.cloudera.impala.jdbc.common.future.SStatement;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.utilities.JDBCVersion;
import java.sql.SQLException;

public class S41Statement
extends SStatement {
    public S41Statement(IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        this(iStatement, sConnection, n, JDBCVersion.JDBC41);
    }

    protected S41Statement(IStatement iStatement, SConnection sConnection, int n, JDBCVersion jDBCVersion) throws SQLException {
        super(iStatement, sConnection, n);
        this.m_jdbcVersion = jDBCVersion;
    }

    @Override
    public synchronized void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

