/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.jdbc42.future;

import com.cloudera.impala.dsi.dataengine.interfaces.future.IResultSet;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.impala.exceptions.ExceptionConverter;
import com.cloudera.impala.exceptions.JDBCMessageKey;
import com.cloudera.impala.jdbc.common.SResultSetMetaData;
import com.cloudera.impala.jdbc.common.future.SDatabaseMetaData;
import com.cloudera.impala.jdbc.jdbc41.future.S41MetaDataProxy;
import com.cloudera.impala.jdbc.jdbc42.S42ResultSetMetaData;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.IWarningListener;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ExceptionType;
import com.cloudera.impala.utilities.JDBCVersion;
import java.sql.SQLException;
import java.sql.SQLType;

public class S42MetaDataProxy
extends S41MetaDataProxy {
    public S42MetaDataProxy(SDatabaseMetaData sDatabaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger) throws SQLException {
        this(sDatabaseMetaData, iResultSet, metadataSourceID, iLogger, JDBCVersion.JDBC42);
    }

    public S42MetaDataProxy(SDatabaseMetaData sDatabaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger, JDBCVersion jDBCVersion) throws SQLException {
        super(sDatabaseMetaData, iResultSet, metadataSourceID, iLogger, jDBCVersion);
    }

    @Override
    protected SResultSetMetaData createResultSetMetadata() {
        return new S42ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener());
    }

    @Override
    public synchronized void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType, n2);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType);
        this.updateObject(this.findColumn(string), object, sQLType);
    }

    @Override
    public synchronized void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType, n);
        this.updateObject(this.findColumn(string), object, sQLType, n);
    }
}

