/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.utils;

import com.cloudera.impala.jdbc.utils.DSEncryptionProperties;
import com.cloudera.impala.jdbc.utils.DSEncryptionUtils;
import com.cloudera.impala.jdbc.utils.DSStringCache;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;

public class DSStringEncryptedCache
extends DSStringCache {
    private DSStringCache m_cache;
    private DSEncryptionProperties m_encryptProp;

    public DSStringEncryptedCache(ILogger iLogger, DSStringCache dSStringCache, boolean bl, boolean bl2, DSEncryptionProperties dSEncryptionProperties) {
        super(iLogger, bl, bl2);
        this.m_cache = dSStringCache;
        this.m_encryptProp = dSEncryptionProperties;
    }

    @Override
    public String getValue(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (string == null) {
            return null;
        }
        String string2 = this.m_cache.getValue(string);
        if (string2 == null) {
            return null;
        }
        this.m_encryptProp.initDecryptionCipher(this.m_logger);
        String string3 = DSEncryptionUtils.DecryptFromHex(string2, this.m_encryptProp, this.m_logger);
        return string3;
    }

    @Override
    public long getExpiry(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_cache.getExpiry(string);
    }

    @Override
    public boolean setValue(String string, String string2, long l) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_encryptProp.initEncryptionCipher(this.m_logger);
        String string3 = DSEncryptionUtils.EncryptFromHex(string2, this.m_encryptProp, this.m_logger);
        return this.m_cache.setValue(string, string3, l);
    }
}

