/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.temptable.column;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.BigIntColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.BinaryColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.BooleanColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.CharColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.ColumnSliceArray;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.DateColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.DoubleColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.ExactNumColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.FileMarkerColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.GuidColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.IColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.IntegerColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.RealColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.SmallIntColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.TimeColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.TimestampColumnSlice;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.TinyIntColumnSlice;

public class ColumnSliceBuilder {
    public static ColumnSliceArray buildColumnSliceArray(IColumn[] iColumnArray, boolean[] blArray, int n, int n2) {
        int[] nArray = new int[blArray.length];
        int n3 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            nArray[i] = blArray[i] ? n3++ : -1;
        }
        IColumnSlice[] iColumnSliceArray = new IColumnSlice[n3];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) continue;
            iColumnSliceArray[nArray[i]] = ColumnSliceBuilder.createColumnSlice(iColumnArray[i], i, n, n2);
        }
        return new ColumnSliceArray(iColumnSliceArray, nArray, n);
    }

    private static IColumnSlice createColumnSlice(IColumn iColumn, int n, int n2, int n3) {
        switch (iColumn.getTypeMetadata().getType()) {
            case -7: 
            case 16: {
                return new BooleanColumnSlice(n2, n);
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                if (ColumnSizeCalculator.isLongData(iColumn, n3)) {
                    return new FileMarkerColumnSlice(n2, n);
                }
                return new CharColumnSlice(n2, n);
            }
            case -4: 
            case -3: 
            case -2: {
                if (ColumnSizeCalculator.isLongData(iColumn, n3)) {
                    return new FileMarkerColumnSlice(n2, n);
                }
                return new BinaryColumnSlice(n2, n);
            }
            case -5: {
                return new BigIntColumnSlice(n2, n);
            }
            case 4: {
                return new IntegerColumnSlice(n2, n, iColumn.getTypeMetadata().isSigned());
            }
            case 5: {
                return new SmallIntColumnSlice(n2, n, iColumn.getTypeMetadata().isSigned());
            }
            case -6: {
                return new TinyIntColumnSlice(n2, n, iColumn.getTypeMetadata().isSigned());
            }
            case 7: {
                return new RealColumnSlice(n2, n);
            }
            case 6: 
            case 8: {
                return new DoubleColumnSlice(n2, n);
            }
            case -11: {
                return new GuidColumnSlice(n2, n);
            }
            case 2: 
            case 3: {
                return new ExactNumColumnSlice(n2, n);
            }
            case 91: {
                return new DateColumnSlice(n2, n);
            }
            case 92: {
                return new TimeColumnSlice(n2, n);
            }
            case 93: {
                return new TimestampColumnSlice(n2, n);
            }
        }
        throw new UnsupportedOperationException("unknown columnslice type to create.");
    }
}

