/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.value.scalar;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.impala.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.impala.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.List;

public class ETRTrim
extends ETScalarFn {
    public ETRTrim(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == this.getNumChildren());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (iColumn.getTypeMetadata().isCharacterType());
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (this.hasMoreData(0)) {
            throw SQLEngineExceptionFactory.invalidScalarFunctionDataException("RTRIM", 1);
        }
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper.getChar();
        int n = string.length();
        for (int i = string.length() - 1; i >= 0 && Character.isWhitespace(string.charAt(i)); --i) {
            --n;
        }
        string = string.substring(0, n);
        eTDataRequest.getData().setChar(string);
        return DataRetrievalUtil.retrieveCharData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
    }
}

